/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.phpdt.ltk.core;

import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.util.ArrayList;
import net.sourceforge.phpdt.core.ISourceRange;
import net.sourceforge.phpdt.core.compiler.InvalidInputException;
import net.sourceforge.phpdt.internal.compiler.parser.Scanner;
import net.sourceforge.phpdt.internal.compiler.parser.SyntaxError;
import net.sourceforge.phpdt.internal.core.SourceMethod;
import net.sourceforge.phpdt.ltk.core.CoreTexts;
import net.sourceforge.phpdt.ltk.core.RenameIdentifierDelegate;
import net.sourceforge.phpdt.ltk.core.RenameIdentifierInfo;
import net.sourceforge.phpeclipse.PHPeclipsePlugin;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.ltk.core.refactoring.CompositeChange;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.participants.CheckConditionsContext;
import org.eclipse.ltk.core.refactoring.participants.IConditionChecker;
import org.eclipse.ltk.core.refactoring.participants.ValidateEditChecker;

public class RenameLocalVariableDelegate
extends RenameIdentifierDelegate {
    static /* synthetic */ Class class$0;

    public RenameLocalVariableDelegate(RenameIdentifierInfo info) {
        super(info);
    }

    RefactoringStatus checkInitialConditions() {
        RefactoringStatus result = new RefactoringStatus();
        IFile sourceFile = this.info.getSourceFile();
        if (sourceFile == null || !sourceFile.exists()) {
            result.addFatalError(CoreTexts.renamePropertyDelegate_noSourceFile);
        } else if (this.info.getSourceFile().isReadOnly()) {
            result.addFatalError(CoreTexts.renamePropertyDelegate_roFile);
        } else if (this.isEmpty(this.info.getOldName())) {
            result.addFatalError(CoreTexts.renamePropertyDelegate_noPHPKey);
        }
        return result;
    }

    RefactoringStatus checkFinalConditions(IProgressMonitor pm, CheckConditionsContext ctxt) {
        String msg;
        RefactoringStatus result = new RefactoringStatus();
        pm.beginTask(CoreTexts.renamePropertyDelegate_checking, 100);
        IFile file = this.info.getSourceFile();
        IProject project = file.getProject();
        try {
            SourceMethod method = this.info.getMethod();
            ISourceRange range = method.getSourceRange();
            if (project.isNatureEnabled("net.sourceforge.phpeclipse.phpnature")) {
                this.determineMethodOffsets(file, range.getOffset(), range.getLength(), result);
            }
        }
        catch (CoreException e) {
            msg = "Project: " + project.getLocation().toOSString() + " CoreException " + e.getMessage();
            result.addError(msg);
        }
        catch (Exception e) {
            msg = "Project: " + project.getLocation().toOSString() + " Exception " + e.getMessage();
            result.addError(msg);
        }
        pm.worked(50);
        if (ctxt != null) {
            IFile[] files = new IFile[this.phpFiles.size()];
            this.phpFiles.keySet().toArray(files);
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.ltk.core.refactoring.participants.ValidateEditChecker");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            IConditionChecker checker = ctxt.getChecker((Class)clazz);
            ValidateEditChecker editChecker = (ValidateEditChecker)checker;
            editChecker.addFiles(files);
        }
        pm.done();
        return result;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void createChange(IProgressMonitor pm, CompositeChange rootChange) {
        try {
            pm.beginTask(CoreTexts.renamePropertyDelegate_collectingChanges, 100);
            rootChange.addAll(this.createChangesForContainer(pm));
        }
        catch (Throwable throwable) {
            Object var3_4 = null;
            pm.done();
            throw throwable;
        }
        {
            Object var3_5 = null;
        }
        pm.done();
    }

    private void determineMethodOffsets(IFile file, int offset, int length, RefactoringStatus status) {
        ArrayList<Integer> matches = new ArrayList<Integer>();
        try {
            String msg;
            String content = this.readFileContent(file, status);
            Scanner firstScanner = new Scanner(true, false);
            firstScanner.setSource(content.toCharArray());
            int fToken = 0;
            int start = 0;
            int phpdocStart = -1;
            try {
                fToken = firstScanner.getNextToken();
                while (fToken != 0 && start < offset) {
                    phpdocStart = fToken == 903 ? firstScanner.getCurrentTokenStartPosition() : -1;
                    fToken = firstScanner.getNextToken();
                    start = firstScanner.getCurrentTokenStartPosition();
                }
            }
            catch (InvalidInputException e) {
                msg = "File: " + file.getLocation().toOSString() + " InvalidInputException " + e.getMessage();
                status.addError(msg);
            }
            catch (SyntaxError e) {
                msg = "File: " + file.getLocation().toOSString() + " SyntaxError " + e.getMessage();
                status.addError(msg);
            }
            if (phpdocStart >= 0 && phpdocStart < offset) {
                length += offset - phpdocStart;
                offset = phpdocStart;
            }
            String methodString = content.substring(offset, offset + length);
            Scanner secondScanner = new Scanner(true, false);
            secondScanner.setSource(methodString.toCharArray());
            secondScanner.setPHPMode(true);
            String wordStr = this.info.getOldName();
            boolean renameDQString = this.info.isRenameDQString();
            boolean renamePHPdoc = this.info.isRenamePHPdoc();
            boolean renameOtherComments = this.info.isRenameOtherComments();
            char[] word = wordStr.toCharArray();
            fToken = 0;
            try {
                fToken = secondScanner.getNextToken();
                while (fToken != 0) {
                    int index;
                    int tokenOffset;
                    String tokenString;
                    if (fToken == 150) {
                        if (secondScanner.equalsCurrentTokenSource(word)) {
                            matches.add(new Integer(secondScanner.getCurrentTokenStartPosition() + offset));
                        }
                    } else if (fToken == 136 && renameDQString) {
                        tokenString = new String(secondScanner.getCurrentTokenSource());
                        tokenOffset = secondScanner.getCurrentTokenStartPosition();
                        index = -1;
                        while ((index = tokenString.indexOf(wordStr, index + 1)) >= 0) {
                            matches.add(new Integer(offset + tokenOffset + index));
                        }
                    } else if (fToken == 903 && renamePHPdoc) {
                        tokenString = new String(secondScanner.getCurrentTokenSource());
                        tokenOffset = secondScanner.getCurrentTokenStartPosition();
                        index = -1;
                        while ((index = tokenString.indexOf(wordStr, index + 1)) >= 0) {
                            matches.add(new Integer(offset + tokenOffset + index));
                        }
                    } else if ((fToken == 902 || fToken == 901) && renameOtherComments) {
                        tokenString = new String(secondScanner.getCurrentTokenSource());
                        tokenOffset = secondScanner.getCurrentTokenStartPosition();
                        index = -1;
                        while ((index = tokenString.indexOf(wordStr, index + 1)) >= 0) {
                            matches.add(new Integer(offset + tokenOffset + index));
                        }
                    }
                    fToken = secondScanner.getNextToken();
                }
            }
            catch (InvalidInputException e) {
                String msg2 = "File: " + file.getLocation().toOSString() + " InvalidInputException " + e.getMessage();
                status.addError(msg2);
            }
            catch (SyntaxError e) {
                String msg3 = "File: " + file.getLocation().toOSString() + " SyntaxError " + e.getMessage();
                status.addError(msg3);
            }
        }
        catch (Exception e) {
            String msg = "File: " + file.getLocation().toOSString() + " Exception " + e.getMessage();
            status.addError(msg);
        }
        if (matches.size() > 0) {
            this.phpFiles.put(file, matches);
        }
    }

    private String readFileContent(IFile file, RefactoringStatus refStatus) {
        String result = null;
        try {
            InputStream is = file.getContents();
            byte[] buf = new byte[1024];
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            int len = is.read(buf);
            while (len > 0) {
                bos.write(buf, 0, len);
                len = is.read(buf);
            }
            is.close();
            result = new String(bos.toByteArray());
        }
        catch (Exception ex) {
            String msg = ex.toString();
            refStatus.addFatalError(msg);
            String pluginId = PHPeclipsePlugin.getPluginId();
            Status status = new Status(4, pluginId, 0, msg, (Throwable)ex);
            PHPeclipsePlugin.getDefault().getLog().log((IStatus)status);
        }
        return result;
    }
}

