/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.phpdt.ui.text;

import net.sourceforge.phpdt.internal.ui.text.FastJavaPartitionScanner;
import net.sourceforge.phpdt.internal.ui.text.IPHPPartitions;
import net.sourceforge.phpdt.internal.ui.text.JavaColorManager;
import net.sourceforge.phpdt.internal.ui.text.phpdoc.PHPDocCodeScanner;
import net.sourceforge.phpdt.ui.text.SingleTokenPHPScanner;
import net.sourceforge.phpeclipse.phpeditor.php.HTMLPartitionScanner;
import net.sourceforge.phpeclipse.phpeditor.php.PHPCodeScanner;
import net.sourceforge.phpeclipse.phpeditor.php.PHPDocumentPartitioner;
import net.sourceforge.phpeclipse.phpeditor.php.PHPPartitionScanner;
import net.sourceforge.phpeclipse.phpeditor.php.SmartyCodeScanner;
import net.sourceforge.phpeclipse.phpeditor.php.SmartyDocCodeScanner;
import net.sourceforge.phpeclipse.xml.ui.XMLPlugin;
import net.sourceforge.phpeclipse.xml.ui.text.XMLTextTools;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentExtension3;
import org.eclipse.jface.text.IDocumentPartitioner;
import org.eclipse.jface.text.rules.DefaultPartitioner;
import org.eclipse.jface.text.rules.IPartitionTokenScanner;
import org.eclipse.jface.text.rules.RuleBasedScanner;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;

public class JavaTextTools
implements IPHPPartitions {
    private static final String[] LEGAL_CONTENT_TYPES = new String[]{"__php_phpdoc_comment", "__php_multiline_comment", "__php_singleline_comment", "__php_string", "__php_string_sq", "__php_string_heredoc"};
    private static HTMLPartitionScanner SMARTY_PARTITION_SCANNER = null;
    private JavaColorManager colorManager;
    private PHPCodeScanner fCodeScanner;
    private SingleTokenPHPScanner fMultilineCommentScanner;
    private SingleTokenPHPScanner fSinglelineCommentScanner;
    private PHPDocCodeScanner fPHPDocScanner;
    private SmartyCodeScanner fSmartyScanner;
    private SmartyDocCodeScanner fSmartyDocScanner;
    private FastJavaPartitionScanner fPartitionScanner;
    private IPreferenceStore fPreferenceStore;
    private XMLTextTools xmlTextTools;
    private Preferences fCorePreferenceStore;
    private PreferenceListener fPreferenceListener = new PreferenceListener();
    private PHPPartitionScanner jspPartitionScanner = null;

    public JavaTextTools(IPreferenceStore store, Preferences coreStore) {
        this(store, coreStore, true);
    }

    public JavaTextTools(IPreferenceStore store, Preferences coreStore, boolean autoDisposeOnDisplayDispose) {
        this.xmlTextTools = new XMLTextTools(XMLPlugin.getDefault().getPreferenceStore());
        this.colorManager = new JavaColorManager(autoDisposeOnDisplayDispose);
        this.fPreferenceStore = store;
        this.fPreferenceStore.addPropertyChangeListener((IPropertyChangeListener)this.fPreferenceListener);
        this.fCorePreferenceStore = coreStore;
        if (this.fCorePreferenceStore != null) {
            this.fCorePreferenceStore.addPropertyChangeListener((Preferences.IPropertyChangeListener)this.fPreferenceListener);
        }
        this.fCodeScanner = new PHPCodeScanner(this.colorManager, store);
        this.fMultilineCommentScanner = new SingleTokenPHPScanner(this.colorManager, store, "_php_multilineComment");
        this.fSinglelineCommentScanner = new SingleTokenPHPScanner(this.colorManager, store, "_php_singlelineComment");
        this.fPHPDocScanner = new PHPDocCodeScanner(this.colorManager, store);
        this.fSmartyScanner = new SmartyCodeScanner(this.colorManager, store);
        this.fSmartyDocScanner = new SmartyDocCodeScanner(this.colorManager, store);
        this.fPartitionScanner = new FastJavaPartitionScanner();
    }

    public XMLTextTools getXMLTextTools() {
        return this.xmlTextTools;
    }

    public void dispose() {
        this.fCodeScanner = null;
        this.fMultilineCommentScanner = null;
        this.fSinglelineCommentScanner = null;
        this.fPHPDocScanner = null;
        if (this.colorManager != null) {
            this.colorManager.dispose();
            this.colorManager = null;
        }
        if (this.fPreferenceStore != null) {
            this.fPreferenceStore.removePropertyChangeListener((IPropertyChangeListener)this.fPreferenceListener);
            this.fPreferenceStore = null;
            if (this.fCorePreferenceStore != null) {
                this.fCorePreferenceStore.removePropertyChangeListener((Preferences.IPropertyChangeListener)this.fPreferenceListener);
                this.fCorePreferenceStore = null;
            }
            this.fPreferenceListener = null;
        }
    }

    public JavaColorManager getColorManager() {
        return this.colorManager;
    }

    public RuleBasedScanner getCodeScanner() {
        return this.fCodeScanner;
    }

    public RuleBasedScanner getMultilineCommentScanner() {
        return this.fMultilineCommentScanner;
    }

    public RuleBasedScanner getSmartyScanner() {
        return this.fSmartyScanner;
    }

    public RuleBasedScanner getSmartyDocScanner() {
        return this.fSmartyDocScanner;
    }

    public RuleBasedScanner getSinglelineCommentScanner() {
        return this.fSinglelineCommentScanner;
    }

    public RuleBasedScanner getJavaDocScanner() {
        return this.fPHPDocScanner;
    }

    public IDocumentPartitioner createDocumentPartitioner() {
        return this.createDocumentPartitioner(".php");
    }

    public IDocumentPartitioner createDocumentPartitioner(String extension) {
        IDocumentPartitioner partitioner = null;
        if (extension.equalsIgnoreCase(".html") || extension.equalsIgnoreCase(".htm")) {
            partitioner = this.createHTMLPartitioner();
            partitioner = this.createJSPPartitioner();
        } else if (extension.equalsIgnoreCase(".xml")) {
            partitioner = this.createXMLPartitioner();
        } else if (extension.equalsIgnoreCase(".tpl")) {
            partitioner = this.createSmartyPartitioner();
        }
        if (partitioner == null) {
            partitioner = this.createJSPPartitioner();
        }
        return partitioner;
    }

    public void setupHTMLDocumentPartitioner(IDocument document, String partitioning, Object element) {
        IDocumentPartitioner partitioner = this.createDocumentPartitioner(".html");
        document.setDocumentPartitioner(partitioner);
        partitioner.connect(document);
    }

    public void setupSmartyDocumentPartitioner(IDocument document, String partitioning, Object element) {
        IDocumentPartitioner partitioner = this.createDocumentPartitioner(".tpl");
        document.setDocumentPartitioner(partitioner);
        partitioner.connect(document);
    }

    public String[] getPartitionManagingPositionCategories() {
        return new String[]{"__content_types_category"};
    }

    protected void adaptToPreferenceChange(PropertyChangeEvent event) {
        if (this.fCodeScanner.affectsBehavior(event)) {
            this.fCodeScanner.adaptToPreferenceChange(event);
        }
        if (this.fMultilineCommentScanner.affectsBehavior(event)) {
            this.fMultilineCommentScanner.adaptToPreferenceChange(event);
        }
        if (this.fSinglelineCommentScanner.affectsBehavior(event)) {
            this.fSinglelineCommentScanner.adaptToPreferenceChange(event);
        }
        if (this.fPHPDocScanner.affectsBehavior(event)) {
            this.fPHPDocScanner.adaptToPreferenceChange(event);
        }
        if (this.fSmartyScanner.affectsBehavior(event)) {
            this.fSmartyScanner.adaptToPreferenceChange(event);
        }
        if (this.fSmartyDocScanner.affectsBehavior(event)) {
            this.fSmartyDocScanner.adaptToPreferenceChange(event);
        }
    }

    public IDocumentPartitioner createHTMLPartitioner() {
        return this.xmlTextTools.createXMLPartitioner();
    }

    public IDocumentPartitioner createPHPPartitioner() {
        return new DefaultPartitioner((IPartitionTokenScanner)this.getPHPPartitionScanner(), LEGAL_CONTENT_TYPES);
    }

    private IDocumentPartitioner createJSPPartitioner() {
        return new PHPDocumentPartitioner(this.getJSPPartitionScanner());
    }

    private IDocumentPartitioner createSmartyPartitioner() {
        return new DefaultPartitioner((IPartitionTokenScanner)JavaTextTools.getSmartyPartitionScanner(), XMLTextTools.TYPES);
    }

    private IDocumentPartitioner createXMLPartitioner() {
        return this.xmlTextTools.createXMLPartitioner();
    }

    private FastJavaPartitionScanner getPHPPartitionScanner() {
        return this.fPartitionScanner;
    }

    private static HTMLPartitionScanner getSmartyPartitionScanner() {
        if (SMARTY_PARTITION_SCANNER == null) {
            SMARTY_PARTITION_SCANNER = new HTMLPartitionScanner(4);
        }
        return SMARTY_PARTITION_SCANNER;
    }

    private PHPPartitionScanner getJSPPartitionScanner() {
        if (this.jspPartitionScanner == null) {
            this.jspPartitionScanner = new PHPPartitionScanner();
        }
        return this.jspPartitionScanner;
    }

    public void setupJavaDocumentPartitioner(IDocument document) {
        this.setupJavaDocumentPartitioner(document, "__dftl_partitioning");
    }

    public void setupJavaDocumentPartitioner(IDocument document, String partitioning) {
        IDocumentPartitioner partitioner = this.createDocumentPartitioner();
        if (document instanceof IDocumentExtension3) {
            IDocumentExtension3 extension3 = (IDocumentExtension3)document;
            extension3.setDocumentPartitioner(partitioning, partitioner);
        } else {
            document.setDocumentPartitioner(partitioner);
        }
        partitioner.connect(document);
    }

    protected IPreferenceStore getPreferenceStore() {
        return this.fPreferenceStore;
    }

    protected Preferences getCorePreferenceStore() {
        return this.fCorePreferenceStore;
    }

    private class PreferenceListener
    implements IPropertyChangeListener,
    Preferences.IPropertyChangeListener {
        PreferenceListener() {
        }

        public void propertyChange(PropertyChangeEvent event) {
            JavaTextTools.this.adaptToPreferenceChange(event);
        }

        public void propertyChange(Preferences.PropertyChangeEvent event) {
            JavaTextTools.this.adaptToPreferenceChange(new PropertyChangeEvent(event.getSource(), event.getProperty(), event.getOldValue(), event.getNewValue()));
        }
    }
}

