/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.phpdt.ui.text;

import java.util.Vector;
import net.sourceforge.phpdt.internal.ui.text.AbstractJavaScanner;
import net.sourceforge.phpdt.internal.ui.text.ContentAssistPreference;
import net.sourceforge.phpdt.internal.ui.text.HTMLTextPresenter;
import net.sourceforge.phpdt.internal.ui.text.JavaAnnotationHover;
import net.sourceforge.phpdt.internal.ui.text.JavaCompositeReconcilingStrategy;
import net.sourceforge.phpdt.internal.ui.text.JavaElementProvider;
import net.sourceforge.phpdt.internal.ui.text.JavaOutlineInformationControl;
import net.sourceforge.phpdt.internal.ui.text.JavaPresentationReconciler;
import net.sourceforge.phpdt.internal.ui.text.JavaReconciler;
import net.sourceforge.phpdt.internal.ui.text.java.JavaFormattingStrategy;
import net.sourceforge.phpdt.internal.ui.text.java.JavaStringAutoIndentStrategyDQ;
import net.sourceforge.phpdt.internal.ui.text.java.JavaStringAutoIndentStrategySQ;
import net.sourceforge.phpdt.internal.ui.text.java.hover.JavaEditorTextHoverDescriptor;
import net.sourceforge.phpdt.internal.ui.text.java.hover.JavaEditorTextHoverProxy;
import net.sourceforge.phpdt.internal.ui.text.java.hover.JavaInformationProvider;
import net.sourceforge.phpdt.internal.ui.text.phpdoc.JavaDocAutoIndentStrategy;
import net.sourceforge.phpdt.internal.ui.text.phpdoc.PHPDocCodeScanner;
import net.sourceforge.phpdt.internal.ui.text.phpdoc.PHPDocCompletionProcessor;
import net.sourceforge.phpdt.ui.text.IColorManager;
import net.sourceforge.phpdt.ui.text.PHPStringDQCodeScanner;
import net.sourceforge.phpdt.ui.text.SingleTokenPHPScanner;
import net.sourceforge.phpeclipse.PHPeclipsePlugin;
import net.sourceforge.phpeclipse.phpeditor.php.HTMLCompletionProcessor;
import net.sourceforge.phpeclipse.phpeditor.php.PHPAutoIndentStrategy;
import net.sourceforge.phpeclipse.phpeditor.php.PHPCodeScanner;
import net.sourceforge.phpeclipse.phpeditor.php.PHPCompletionProcessor;
import net.sourceforge.phpeclipse.phpeditor.php.PHPDoubleClickSelector;
import net.sourceforge.phpeclipse.xml.ui.XMLPlugin;
import net.sourceforge.phpeclipse.xml.ui.internal.text.XMLConfiguration;
import net.sourceforge.phpeclipse.xml.ui.text.XMLTextTools;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.DefaultIndentLineAutoEditStrategy;
import org.eclipse.jface.text.DefaultInformationControl;
import org.eclipse.jface.text.IAutoEditStrategy;
import org.eclipse.jface.text.IInformationControl;
import org.eclipse.jface.text.IInformationControlCreator;
import org.eclipse.jface.text.ITextDoubleClickStrategy;
import org.eclipse.jface.text.ITextHover;
import org.eclipse.jface.text.TextAttribute;
import org.eclipse.jface.text.contentassist.ContentAssistant;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.jface.text.contentassist.IContentAssistant;
import org.eclipse.jface.text.formatter.ContentFormatter;
import org.eclipse.jface.text.formatter.IContentFormatter;
import org.eclipse.jface.text.formatter.IFormattingStrategy;
import org.eclipse.jface.text.information.IInformationPresenter;
import org.eclipse.jface.text.information.IInformationProvider;
import org.eclipse.jface.text.information.InformationPresenter;
import org.eclipse.jface.text.presentation.IPresentationDamager;
import org.eclipse.jface.text.presentation.IPresentationReconciler;
import org.eclipse.jface.text.presentation.IPresentationRepairer;
import org.eclipse.jface.text.presentation.PresentationReconciler;
import org.eclipse.jface.text.reconciler.IReconciler;
import org.eclipse.jface.text.rules.BufferedRuleBasedScanner;
import org.eclipse.jface.text.rules.DefaultDamagerRepairer;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.ITokenScanner;
import org.eclipse.jface.text.rules.RuleBasedScanner;
import org.eclipse.jface.text.rules.Token;
import org.eclipse.jface.text.source.IAnnotationHover;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.texteditor.ITextEditor;

public class PHPSourceViewerConfiguration
extends SourceViewerConfiguration {
    public static final String PREFERENCE_TAB_WIDTH = "tabWidth";
    public static final String SPACES_FOR_TABS = "spacesForTabs";
    private ITextEditor fTextEditor;
    private String fDocumentPartitioning;
    private ContentFormatter fFormatter;
    private AbstractJavaScanner fCodeScanner;
    private AbstractJavaScanner fMultilineCommentScanner;
    private AbstractJavaScanner fSinglelineCommentScanner;
    private AbstractJavaScanner fStringDQScanner;
    private AbstractJavaScanner fStringSQScanner;
    private AbstractJavaScanner fJavaDocScanner;
    private IPreferenceStore fPreferenceStore;
    private IColorManager fColorManager;
    private XMLTextTools fXMLTextTools;
    private XMLConfiguration xmlConfiguration;

    public PHPSourceViewerConfiguration(IColorManager colorManager, IPreferenceStore preferenceStore, ITextEditor editor, String partitioning) {
        this.fColorManager = colorManager;
        this.fPreferenceStore = preferenceStore;
        this.fTextEditor = editor;
        this.fDocumentPartitioning = partitioning;
        this.fXMLTextTools = XMLPlugin.getDefault().getXMLTextTools();
        this.xmlConfiguration = new XMLConfiguration(this.fXMLTextTools);
        this.fColorManager = colorManager;
        this.fPreferenceStore = preferenceStore;
        this.fTextEditor = editor;
        this.fDocumentPartitioning = partitioning;
        this.initializeScanners();
    }

    protected IColorManager getColorManager() {
        return this.fColorManager;
    }

    private void initializeScanners() {
        this.fCodeScanner = new PHPCodeScanner(this.getColorManager(), this.fPreferenceStore);
        this.fMultilineCommentScanner = new SingleTokenPHPScanner(this.getColorManager(), this.fPreferenceStore, "_php_multilineComment");
        this.fSinglelineCommentScanner = new SingleTokenPHPScanner(this.getColorManager(), this.fPreferenceStore, "_php_singlelineComment");
        this.fStringDQScanner = new PHPStringDQCodeScanner(this.getColorManager(), this.fPreferenceStore);
        this.fStringSQScanner = new SingleTokenPHPScanner(this.getColorManager(), this.fPreferenceStore, "_php_string_sq");
        this.fJavaDocScanner = new PHPDocCodeScanner(this.getColorManager(), this.fPreferenceStore);
    }

    public boolean affectsTextPresentation(PropertyChangeEvent event) {
        return this.fCodeScanner.affectsBehavior(event) || this.fMultilineCommentScanner.affectsBehavior(event) || this.fSinglelineCommentScanner.affectsBehavior(event) || this.fStringDQScanner.affectsBehavior(event) || this.fStringSQScanner.affectsBehavior(event) || this.fJavaDocScanner.affectsBehavior(event);
    }

    public void handlePropertyChangeEvent(PropertyChangeEvent event) {
        if (this.fCodeScanner.affectsBehavior(event)) {
            this.fCodeScanner.adaptToPreferenceChange(event);
        }
        if (this.fMultilineCommentScanner.affectsBehavior(event)) {
            this.fMultilineCommentScanner.adaptToPreferenceChange(event);
        }
        if (this.fSinglelineCommentScanner.affectsBehavior(event)) {
            this.fSinglelineCommentScanner.adaptToPreferenceChange(event);
        }
        if (this.fStringDQScanner.affectsBehavior(event)) {
            this.fStringDQScanner.adaptToPreferenceChange(event);
        }
        if (this.fStringSQScanner.affectsBehavior(event)) {
            this.fStringSQScanner.adaptToPreferenceChange(event);
        }
        if (this.fJavaDocScanner.affectsBehavior(event)) {
            this.fJavaDocScanner.adaptToPreferenceChange(event);
        }
    }

    public IContentFormatter getContentFormatter(ISourceViewer sourceViewer) {
        if (this.fFormatter == null) {
            this.fFormatter = new ContentFormatter();
            JavaFormattingStrategy strategy = new JavaFormattingStrategy(sourceViewer);
            this.fFormatter.setFormattingStrategy((IFormattingStrategy)strategy, "__dftl_partition_content_type");
            this.fFormatter.enablePartitionAwareFormatting(false);
            this.fFormatter.setPartitionManagingPositionCategories(this.getPartitionManagingPositionCategories());
        }
        return this.fFormatter;
    }

    public String[] getPartitionManagingPositionCategories() {
        return new String[]{"__content_types_category"};
    }

    public ITextEditor getEditor() {
        return this.fTextEditor;
    }

    protected IPreferenceStore getPreferenceStore() {
        return PHPeclipsePlugin.getDefault().getPreferenceStore();
    }

    public IAnnotationHover getAnnotationHover(ISourceViewer sourceViewer) {
        return new JavaAnnotationHover(JavaAnnotationHover.VERTICAL_RULER_HOVER);
    }

    public IAnnotationHover getOverviewRulerAnnotationHover(ISourceViewer sourceViewer) {
        return new JavaAnnotationHover(JavaAnnotationHover.OVERVIEW_RULER_HOVER);
    }

    public IAutoEditStrategy[] getAutoEditStrategies(ISourceViewer sourceViewer, String contentType) {
        DefaultIndentLineAutoEditStrategy strategy = new DefaultIndentLineAutoEditStrategy();
        strategy = "__php_phpdoc_comment".equals(contentType) || "__php_multiline_comment".equals(contentType) ? new JavaDocAutoIndentStrategy(this.getConfiguredDocumentPartitioning(sourceViewer)) : ("__php_string".equals(contentType) ? new JavaStringAutoIndentStrategyDQ(this.getConfiguredDocumentPartitioning(sourceViewer)) : ("__php_string_sq".equals(contentType) ? new JavaStringAutoIndentStrategySQ(this.getConfiguredDocumentPartitioning(sourceViewer)) : ("__php_template_data".equals(contentType) || "__php_script_code".equals(contentType) || "__dftl_partition_content_type".equals(contentType) || "___php_partitioning".equals(contentType) || "__php_scripting_area ".equals(contentType) ? new PHPAutoIndentStrategy() : new DefaultIndentLineAutoEditStrategy())));
        IAutoEditStrategy[] result = new IAutoEditStrategy[]{strategy};
        return result;
    }

    protected RuleBasedScanner getCodeScanner() {
        return this.fCodeScanner;
    }

    protected RuleBasedScanner getMultilineCommentScanner() {
        return this.fMultilineCommentScanner;
    }

    protected RuleBasedScanner getSinglelineCommentScanner() {
        return this.fSinglelineCommentScanner;
    }

    protected RuleBasedScanner getStringDQScanner() {
        return this.fStringDQScanner;
    }

    protected RuleBasedScanner getStringSQScanner() {
        return this.fStringSQScanner;
    }

    public IReconciler getReconciler(ISourceViewer sourceViewer) {
        ITextEditor editor = this.getEditor();
        if (editor != null && editor.isEditable()) {
            JavaCompositeReconcilingStrategy strategy = new JavaCompositeReconcilingStrategy(editor, this.getConfiguredDocumentPartitioning(sourceViewer));
            JavaReconciler reconciler = new JavaReconciler(editor, strategy, false);
            reconciler.setIsIncrementalReconciler(false);
            reconciler.setProgressMonitor((IProgressMonitor)new NullProgressMonitor());
            reconciler.setDelay(500);
            return reconciler;
        }
        return null;
    }

    public int[] getConfiguredTextHoverStateMasks(ISourceViewer sourceViewer, String contentType) {
        JavaEditorTextHoverDescriptor[] hoverDescs = PHPeclipsePlugin.getDefault().getJavaEditorTextHoverDescriptors();
        int[] stateMasks = new int[hoverDescs.length];
        int stateMasksLength = 0;
        int i = 0;
        while (i < hoverDescs.length) {
            if (hoverDescs[i].isEnabled()) {
                int j = 0;
                int stateMask = hoverDescs[i].getStateMask();
                while (j < stateMasksLength) {
                    if (stateMasks[j] == stateMask) break;
                    ++j;
                }
                if (j == stateMasksLength) {
                    stateMasks[stateMasksLength++] = stateMask;
                }
            }
            ++i;
        }
        if (stateMasksLength == hoverDescs.length) {
            return stateMasks;
        }
        int[] shortenedStateMasks = new int[stateMasksLength];
        System.arraycopy(stateMasks, 0, shortenedStateMasks, 0, stateMasksLength);
        return shortenedStateMasks;
    }

    public ITextHover getTextHover(ISourceViewer sourceViewer, String contentType, int stateMask) {
        JavaEditorTextHoverDescriptor[] hoverDescs = PHPeclipsePlugin.getDefault().getJavaEditorTextHoverDescriptors();
        int i = 0;
        while (i < hoverDescs.length) {
            if (hoverDescs[i].isEnabled() && hoverDescs[i].getStateMask() == stateMask) {
                return new JavaEditorTextHoverProxy(hoverDescs[i], (IEditorPart)this.getEditor());
            }
            ++i;
        }
        return null;
    }

    public ITextHover getTextHover(ISourceViewer sourceViewer, String contentType) {
        return this.getTextHover(sourceViewer, contentType, 255);
    }

    protected RuleBasedScanner getPHPDocScanner() {
        return this.fJavaDocScanner;
    }

    public String[] getConfiguredContentTypes(ISourceViewer sourceViewer) {
        return new String[]{"__dftl_partition_content_type", "__php_scripting_area ", "__html", "__html_multiline_comment", "___php_partitioning", "__php_singleline_comment", "__php_multiline_comment", "__php_phpdoc_comment", "__php_string", "__php_string_sq", "__php_string_heredoc", "__css", "__css_multiline_comment", "__javascript", "__js_multiline_comment", "__smarty", "__smarty_multiline_comment", "__xml_processing_instruction", "__xml_comment", "__xml_declaration", "__xml_tag", "__xml_attribute", "__xml_cdata", "__dtd_internal", "__dtd_internal_pi", "__dtd_internal_comment", "__dtd_internal_declaration", "__php_template_data", "__php_script_code"};
    }

    public String[] getConfiguredHTMLContentTypes() {
        return new String[]{"__xml_processing_instruction", "__xml_comment", "__xml_declaration", "__xml_tag", "__xml_attribute", "__xml_cdata", "__dtd_internal", "__dtd_internal_pi", "__dtd_internal_comment", "__dtd_internal_declaration"};
    }

    public String[] getConfiguredPHPContentTypes() {
        return new String[]{"__dftl_partition_content_type", "___php_partitioning", "__php_singleline_comment", "__php_multiline_comment", "__php_phpdoc_comment", "__php_string", "__php_string_sq", "__php_string_heredoc", "__css", "__css_multiline_comment", "__javascript", "__js_multiline_comment", "__smarty", "__smarty_multiline_comment"};
    }

    public String getConfiguredDocumentPartitioning(ISourceViewer sourceViewer) {
        if (this.fDocumentPartitioning != null) {
            return this.fDocumentPartitioning;
        }
        return super.getConfiguredDocumentPartitioning(sourceViewer);
    }

    public IContentAssistant getContentAssistant(ISourceViewer sourceViewer) {
        ContentAssistant assistant = new ContentAssistant();
        Object processor = new HTMLCompletionProcessor((IEditorPart)this.getEditor());
        assistant.setDocumentPartitioning(this.getConfiguredDocumentPartitioning(sourceViewer));
        assistant.setContentAssistProcessor((IContentAssistProcessor)processor, "__html");
        assistant.setContentAssistProcessor((IContentAssistProcessor)processor, "__html_multiline_comment");
        assistant.setContentAssistProcessor((IContentAssistProcessor)processor, "__css");
        assistant.setContentAssistProcessor((IContentAssistProcessor)processor, "__css_multiline_comment");
        assistant.setContentAssistProcessor((IContentAssistProcessor)processor, "__javascript");
        assistant.setContentAssistProcessor((IContentAssistProcessor)processor, "__js_multiline_comment");
        assistant.setContentAssistProcessor((IContentAssistProcessor)processor, "__smarty");
        assistant.setContentAssistProcessor((IContentAssistProcessor)processor, "__smarty_multiline_comment");
        assistant.setContentAssistProcessor((IContentAssistProcessor)processor, "__php_template_data");
        String[] htmlTypes = this.getConfiguredHTMLContentTypes();
        int i = 0;
        while (i < htmlTypes.length) {
            assistant.setContentAssistProcessor((IContentAssistProcessor)processor, htmlTypes[i]);
            ++i;
        }
        processor = new PHPCompletionProcessor((IEditorPart)this.getEditor());
        assistant.setContentAssistProcessor((IContentAssistProcessor)processor, "__php_script_code");
        assistant.setContentAssistProcessor((IContentAssistProcessor)processor, "___php_partitioning");
        assistant.setContentAssistProcessor((IContentAssistProcessor)processor, "__php_string");
        assistant.setContentAssistProcessor((IContentAssistProcessor)processor, "__php_string_sq");
        assistant.setContentAssistProcessor((IContentAssistProcessor)processor, "__php_string_heredoc");
        assistant.setContentAssistProcessor((IContentAssistProcessor)new PHPDocCompletionProcessor((IEditorPart)this.getEditor()), "__php_phpdoc_comment");
        ContentAssistPreference.configure(assistant, this.getPreferenceStore());
        assistant.setContextInformationPopupOrientation(20);
        assistant.setInformationControlCreator(this.getInformationControlCreator(sourceViewer));
        return assistant;
    }

    public String[] getDefaultPrefixes(ISourceViewer sourceViewer, String contentType) {
        return new String[]{"//", ""};
    }

    public ITextDoubleClickStrategy getDoubleClickStrategy(ISourceViewer sourceViewer, String contentType) {
        return new PHPDoubleClickSelector();
    }

    public String[] getIndentPrefixes(ISourceViewer sourceViewer, String contentType) {
        Vector<String> vector = new Vector<String>();
        IPreferenceStore preferences = PHPeclipsePlugin.getDefault().getPreferenceStore();
        int tabWidth = preferences.getInt("net.sourceforge.phpeclipse.formatter.tabulation.size");
        boolean useSpaces = this.getPreferenceStore().getBoolean(SPACES_FOR_TABS);
        int i = 0;
        while (i <= tabWidth) {
            int j;
            StringBuffer prefix = new StringBuffer();
            if (useSpaces) {
                j = 0;
                while (j + i < tabWidth) {
                    prefix.append(' ');
                    ++j;
                }
                if (i != 0) {
                    prefix.append('\t');
                }
            } else {
                j = 0;
                while (j < i) {
                    prefix.append(' ');
                    ++j;
                }
                if (i != tabWidth) {
                    prefix.append('\t');
                }
            }
            vector.add(prefix.toString());
            ++i;
        }
        vector.add("");
        return vector.toArray(new String[vector.size()]);
    }

    public IPresentationReconciler getPresentationReconciler(ISourceViewer sourceViewer) {
        JavaPresentationReconciler phpReconciler = new JavaPresentationReconciler();
        phpReconciler.setDocumentPartitioning(this.getConfiguredDocumentPartitioning(sourceViewer));
        DefaultDamagerRepairer phpDR = new DefaultDamagerRepairer((ITokenScanner)this.getCodeScanner());
        phpReconciler.setDamager((IPresentationDamager)phpDR, "__dftl_partition_content_type");
        phpReconciler.setRepairer((IPresentationRepairer)phpDR, "__dftl_partition_content_type");
        phpDR = new DefaultDamagerRepairer((ITokenScanner)this.getCodeScanner());
        phpReconciler.setDamager((IPresentationDamager)phpDR, "___php_partitioning");
        phpReconciler.setRepairer((IPresentationRepairer)phpDR, "___php_partitioning");
        phpDR = new DefaultDamagerRepairer((ITokenScanner)this.getPHPDocScanner());
        phpReconciler.setDamager((IPresentationDamager)phpDR, "__php_phpdoc_comment");
        phpReconciler.setRepairer((IPresentationRepairer)phpDR, "__php_phpdoc_comment");
        phpDR = new DefaultDamagerRepairer((ITokenScanner)this.getStringDQScanner());
        phpReconciler.setDamager((IPresentationDamager)phpDR, "__php_string");
        phpReconciler.setRepairer((IPresentationRepairer)phpDR, "__php_string");
        phpDR = new DefaultDamagerRepairer((ITokenScanner)this.getStringSQScanner());
        phpReconciler.setDamager((IPresentationDamager)phpDR, "__php_string_sq");
        phpReconciler.setRepairer((IPresentationRepairer)phpDR, "__php_string_sq");
        phpDR = new DefaultDamagerRepairer((ITokenScanner)this.getStringDQScanner());
        phpReconciler.setDamager((IPresentationDamager)phpDR, "__php_string_heredoc");
        phpReconciler.setRepairer((IPresentationRepairer)phpDR, "__php_string_heredoc");
        phpDR = new DefaultDamagerRepairer((ITokenScanner)this.getSinglelineCommentScanner());
        phpReconciler.setDamager((IPresentationDamager)phpDR, "__php_singleline_comment");
        phpReconciler.setRepairer((IPresentationRepairer)phpDR, "__php_singleline_comment");
        phpDR = new DefaultDamagerRepairer((ITokenScanner)this.getMultilineCommentScanner());
        phpReconciler.setDamager((IPresentationDamager)phpDR, "__php_multiline_comment");
        phpReconciler.setRepairer((IPresentationRepairer)phpDR, "__php_multiline_comment");
        PresentationReconciler reconciler = new PresentationReconciler();
        reconciler.setDocumentPartitioning(this.getConfiguredDocumentPartitioning(sourceViewer));
        DefaultDamagerRepairer dr = new DefaultDamagerRepairer((ITokenScanner)this.getPHPDocScanner());
        reconciler.setDamager((IPresentationDamager)dr, "__dftl_partition_content_type");
        reconciler.setRepairer((IPresentationRepairer)dr, "__dftl_partition_content_type");
        this.configureEmbeddedPresentationReconciler(reconciler, this.xmlConfiguration.getPresentationReconciler(sourceViewer), this.xmlConfiguration.getConfiguredContentTypes(sourceViewer), "__php_template_data");
        this.configureEmbeddedPresentationReconciler(reconciler, (IPresentationReconciler)phpReconciler, this.getConfiguredPHPContentTypes(), "__php_script_code");
        return reconciler;
    }

    private void configureEmbeddedPresentationReconciler(PresentationReconciler reconciler, IPresentationReconciler embedded, String[] types, String defaultType) {
        int i = 0;
        while (i < types.length) {
            String type = types[i];
            IPresentationDamager damager = embedded.getDamager(type);
            IPresentationRepairer repairer = embedded.getRepairer(type);
            if (type == "__dftl_partition_content_type") {
                type = defaultType;
            }
            reconciler.setDamager(damager, type);
            reconciler.setRepairer(repairer, type);
            ++i;
        }
    }

    public int getTabWidth(ISourceViewer sourceViewer) {
        return this.getPreferenceStore().getInt(PREFERENCE_TAB_WIDTH);
    }

    public IInformationControlCreator getInformationControlCreator(ISourceViewer sourceViewer) {
        return new IInformationControlCreator(){

            public IInformationControl createInformationControl(Shell parent) {
                return new DefaultInformationControl(parent, 0, (DefaultInformationControl.IInformationPresenter)new HTMLTextPresenter(true));
            }
        };
    }

    public IInformationPresenter getInformationPresenter(ISourceViewer sourceViewer) {
        InformationPresenter presenter = new InformationPresenter(this.getInformationPresenterControlCreator(sourceViewer));
        presenter.setDocumentPartitioning(this.getConfiguredDocumentPartitioning(sourceViewer));
        JavaInformationProvider provider = new JavaInformationProvider((IEditorPart)this.getEditor());
        presenter.setInformationProvider((IInformationProvider)provider, "__dftl_partition_content_type");
        presenter.setInformationProvider((IInformationProvider)provider, "__php_phpdoc_comment");
        presenter.setSizeConstraints(60, 10, true, true);
        return presenter;
    }

    private IInformationControlCreator getInformationPresenterControlCreator(ISourceViewer sourceViewer) {
        return new IInformationControlCreator(){

            public IInformationControl createInformationControl(Shell parent) {
                int shellStyle = 16;
                int style = 768;
                return new DefaultInformationControl(parent, shellStyle, style, (DefaultInformationControl.IInformationPresenter)new HTMLTextPresenter(false));
            }
        };
    }

    private IInformationControlCreator getOutlinePresenterControlCreator(ISourceViewer sourceViewer) {
        return new IInformationControlCreator(){

            public IInformationControl createInformationControl(Shell parent) {
                int shellStyle = 16;
                int treeStyle = 768;
                return new JavaOutlineInformationControl(parent, shellStyle, treeStyle);
            }
        };
    }

    public IInformationPresenter getOutlinePresenter(ISourceViewer sourceViewer, boolean doCodeResolve) {
        InformationPresenter presenter = new InformationPresenter(this.getOutlinePresenterControlCreator(sourceViewer));
        presenter.setAnchor(InformationPresenter.ANCHOR_GLOBAL);
        JavaElementProvider provider = new JavaElementProvider((IEditorPart)this.getEditor(), doCodeResolve);
        presenter.setInformationProvider((IInformationProvider)provider, "__dftl_partition_content_type");
        presenter.setInformationProvider((IInformationProvider)provider, "__php_script_code");
        presenter.setInformationProvider((IInformationProvider)provider, "___php_partitioning");
        presenter.setInformationProvider((IInformationProvider)provider, "__php_phpdoc_comment");
        presenter.setInformationProvider((IInformationProvider)provider, "__smarty_multiline_comment");
        presenter.setInformationProvider((IInformationProvider)provider, "__html");
        presenter.setInformationProvider((IInformationProvider)provider, "__html_multiline_comment");
        presenter.setSizeConstraints(40, 20, true, false);
        return presenter;
    }

    static class SingleTokenScanner
    extends BufferedRuleBasedScanner {
        public SingleTokenScanner(TextAttribute attribute) {
            this.setDefaultReturnToken((IToken)new Token((Object)attribute));
        }
    }
}

