/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.phpdt.ui.wizards;

import java.util.ArrayList;
import java.util.List;
import net.sourceforge.phpdt.core.Flags;
import net.sourceforge.phpdt.core.IBuffer;
import net.sourceforge.phpdt.core.ICompilationUnit;
import net.sourceforge.phpdt.core.IJavaElement;
import net.sourceforge.phpdt.core.IPackageFragment;
import net.sourceforge.phpdt.core.ISourceRange;
import net.sourceforge.phpdt.core.IType;
import net.sourceforge.phpdt.core.ToolFactory;
import net.sourceforge.phpdt.core.compiler.InvalidInputException;
import net.sourceforge.phpdt.externaltools.internal.ui.StatusInfo;
import net.sourceforge.phpdt.internal.compiler.parser.Scanner;
import net.sourceforge.phpdt.internal.corext.codemanipulation.StubUtility;
import net.sourceforge.phpdt.internal.corext.template.php.JavaContext;
import net.sourceforge.phpdt.internal.corext.template.php.Templates;
import net.sourceforge.phpdt.internal.corext.util.JavaModelUtil;
import net.sourceforge.phpdt.internal.ui.PHPUiImages;
import net.sourceforge.phpdt.internal.ui.util.SWTUtil;
import net.sourceforge.phpdt.internal.ui.wizards.NewWizardMessages;
import net.sourceforge.phpdt.internal.ui.wizards.dialogfields.DialogField;
import net.sourceforge.phpdt.internal.ui.wizards.dialogfields.IDialogFieldListener;
import net.sourceforge.phpdt.internal.ui.wizards.dialogfields.IListAdapter;
import net.sourceforge.phpdt.internal.ui.wizards.dialogfields.IStringButtonAdapter;
import net.sourceforge.phpdt.internal.ui.wizards.dialogfields.LayoutUtil;
import net.sourceforge.phpdt.internal.ui.wizards.dialogfields.ListDialogField;
import net.sourceforge.phpdt.internal.ui.wizards.dialogfields.SelectionButtonDialogField;
import net.sourceforge.phpdt.internal.ui.wizards.dialogfields.SelectionButtonDialogFieldGroup;
import net.sourceforge.phpdt.internal.ui.wizards.dialogfields.Separator;
import net.sourceforge.phpdt.internal.ui.wizards.dialogfields.StringButtonDialogField;
import net.sourceforge.phpdt.internal.ui.wizards.dialogfields.StringButtonStatusDialogField;
import net.sourceforge.phpdt.internal.ui.wizards.dialogfields.StringDialogField;
import net.sourceforge.phpdt.ui.CodeGeneration;
import net.sourceforge.phpdt.ui.PreferenceConstants;
import net.sourceforge.phpdt.ui.wizards.NewContainerWizardPage;
import net.sourceforge.phpeclipse.PHPeclipsePlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.templates.Template;
import org.eclipse.jface.text.templates.TemplateException;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public abstract class NewTypeWizardPage
extends NewContainerWizardPage {
    public int F_PUBLIC = 1;
    public int F_PRIVATE = 2;
    public int F_PROTECTED = 4;
    public int F_STATIC = 8;
    public int F_FINAL = 16;
    private static final String PAGE_NAME = "NewTypeWizardPage";
    protected static final String PACKAGE = "NewTypeWizardPage.package";
    protected static final String ENCLOSING = "NewTypeWizardPage.enclosing";
    protected static final String ENCLOSINGSELECTION = "NewTypeWizardPage.enclosing.selection";
    protected static final String TYPENAME = "NewTypeWizardPage.typename";
    protected static final String SUPER = "NewTypeWizardPage.superclass";
    protected static final String INTERFACES = "NewTypeWizardPage.interfaces";
    protected static final String MODIFIERS = "NewTypeWizardPage.modifiers";
    protected static final String METHODS = "NewTypeWizardPage.methods";
    private StringButtonStatusDialogField fPackageDialogField;
    private SelectionButtonDialogField fEnclosingTypeSelection;
    private StringButtonDialogField fEnclosingTypeDialogField;
    private boolean fCanModifyPackage;
    private boolean fCanModifyEnclosingType;
    private IPackageFragment fCurrPackage;
    private StringDialogField fTypeNameDialogField;
    private StringButtonDialogField fSuperClassDialogField;
    private ListDialogField fSuperInterfacesDialogField;
    private SelectionButtonDialogFieldGroup fAccMdfButtons;
    private SelectionButtonDialogFieldGroup fOtherMdfButtons;
    private IType fCreatedType = null;
    protected IStatus fEnclosingTypeStatus;
    protected IStatus fPackageStatus;
    protected IStatus fTypeNameStatus;
    protected IStatus fModifierStatus;
    private boolean fIsClass;
    private int fStaticMdfIndex;
    private final int PUBLIC_INDEX = 0;
    private final int DEFAULT_INDEX = 1;
    private final int PRIVATE_INDEX = 2;
    private final int PROTECTED_INDEX = 3;
    private final int ABSTRACT_INDEX = 0;
    private final int FINAL_INDEX = 1;

    public NewTypeWizardPage(boolean isClass, String pageName) {
        super(pageName);
        String[] buttonNames2;
        this.fIsClass = isClass;
        TypeFieldsAdapter adapter = new TypeFieldsAdapter();
        this.fPackageDialogField = new StringButtonStatusDialogField(adapter);
        this.fPackageDialogField.setDialogFieldListener(adapter);
        this.fPackageDialogField.setLabelText(NewWizardMessages.getString("NewTypeWizardPage.package.label"));
        this.fPackageDialogField.setButtonLabel(NewWizardMessages.getString("NewTypeWizardPage.package.button"));
        this.fPackageDialogField.setStatusWidthHint(NewWizardMessages.getString("NewTypeWizardPage.default"));
        this.fEnclosingTypeSelection = new SelectionButtonDialogField(32);
        this.fEnclosingTypeSelection.setDialogFieldListener(adapter);
        this.fEnclosingTypeSelection.setLabelText(NewWizardMessages.getString("NewTypeWizardPage.enclosing.selection.label"));
        this.fEnclosingTypeDialogField = new StringButtonDialogField(adapter);
        this.fEnclosingTypeDialogField.setDialogFieldListener(adapter);
        this.fEnclosingTypeDialogField.setButtonLabel(NewWizardMessages.getString("NewTypeWizardPage.enclosing.button"));
        this.fTypeNameDialogField = new StringDialogField();
        this.fTypeNameDialogField.setDialogFieldListener(adapter);
        this.fTypeNameDialogField.setLabelText(NewWizardMessages.getString("NewTypeWizardPage.typename.label"));
        this.fSuperClassDialogField = new StringButtonDialogField(adapter);
        this.fSuperClassDialogField.setDialogFieldListener(adapter);
        this.fSuperClassDialogField.setLabelText(NewWizardMessages.getString("NewTypeWizardPage.superclass.label"));
        this.fSuperClassDialogField.setButtonLabel(NewWizardMessages.getString("NewTypeWizardPage.superclass.button"));
        String[] stringArray = new String[3];
        stringArray[0] = NewWizardMessages.getString("NewTypeWizardPage.interfaces.add");
        stringArray[2] = NewWizardMessages.getString("NewTypeWizardPage.interfaces.remove");
        String[] addButtons = stringArray;
        this.fSuperInterfacesDialogField = new ListDialogField(adapter, addButtons, (ILabelProvider)new InterfacesListLabelProvider());
        this.fSuperInterfacesDialogField.setDialogFieldListener(adapter);
        String interfaceLabel = this.fIsClass ? NewWizardMessages.getString("NewTypeWizardPage.interfaces.class.label") : NewWizardMessages.getString("NewTypeWizardPage.interfaces.ifc.label");
        this.fSuperInterfacesDialogField.setLabelText(interfaceLabel);
        this.fSuperInterfacesDialogField.setRemoveButtonIndex(2);
        String[] buttonNames1 = new String[]{NewWizardMessages.getString("NewTypeWizardPage.modifiers.public"), NewWizardMessages.getString("NewTypeWizardPage.modifiers.default"), NewWizardMessages.getString("NewTypeWizardPage.modifiers.private"), NewWizardMessages.getString("NewTypeWizardPage.modifiers.protected")};
        this.fAccMdfButtons = new SelectionButtonDialogFieldGroup(16, buttonNames1, 4);
        this.fAccMdfButtons.setDialogFieldListener(adapter);
        this.fAccMdfButtons.setLabelText(NewWizardMessages.getString("NewTypeWizardPage.modifiers.acc.label"));
        this.fAccMdfButtons.setSelection(0, true);
        if (this.fIsClass) {
            buttonNames2 = new String[]{NewWizardMessages.getString("NewTypeWizardPage.modifiers.abstract"), NewWizardMessages.getString("NewTypeWizardPage.modifiers.final"), NewWizardMessages.getString("NewTypeWizardPage.modifiers.static")};
            this.fStaticMdfIndex = 2;
        } else {
            buttonNames2 = new String[]{NewWizardMessages.getString("NewTypeWizardPage.modifiers.static")};
            this.fStaticMdfIndex = 0;
        }
        this.fOtherMdfButtons = new SelectionButtonDialogFieldGroup(32, buttonNames2, 4);
        this.fOtherMdfButtons.setDialogFieldListener(adapter);
        this.fAccMdfButtons.enableSelectionButton(2, false);
        this.fAccMdfButtons.enableSelectionButton(3, false);
        this.fOtherMdfButtons.enableSelectionButton(this.fStaticMdfIndex, false);
        this.fPackageStatus = new StatusInfo();
        this.fEnclosingTypeStatus = new StatusInfo();
        this.fCanModifyPackage = true;
        this.fCanModifyEnclosingType = true;
        this.updateEnableState();
        this.fTypeNameStatus = new StatusInfo();
        this.fModifierStatus = new StatusInfo();
    }

    protected void initTypePage(IJavaElement elem) {
        String initSuperclass = "java.lang.Object";
        ArrayList initSuperinterfaces = new ArrayList(5);
        IPackageFragment pack = null;
        if (elem != null) {
            pack = (IPackageFragment)elem.getAncestor(4);
            IType typeInCU = (IType)elem.getAncestor(7);
            if (typeInCU != null) {
                if (typeInCU.getCompilationUnit() != null) {
                }
            } else {
                ICompilationUnit iCompilationUnit = (ICompilationUnit)elem.getAncestor(5);
            }
        }
        this.setPackageFragment(pack, true);
        this.setEnclosingTypeSelection(false, true);
        this.setTypeName("", true);
        this.setSuperClass(initSuperclass, true);
        this.setSuperInterfaces(initSuperinterfaces, true);
    }

    protected void createSeparator(Composite composite, int nColumns) {
        new Separator(258).doFillIntoGrid(composite, nColumns, this.convertHeightInCharsToPixels(1));
    }

    protected void createPackageControls(Composite composite, int nColumns) {
        this.fPackageDialogField.doFillIntoGrid(composite, nColumns);
        LayoutUtil.setWidthHint((Control)this.fPackageDialogField.getTextControl(null), this.getMaxFieldWidth());
        LayoutUtil.setHorizontalGrabbing((Control)this.fPackageDialogField.getTextControl(null));
    }

    protected void createEnclosingTypeControls(Composite composite, int nColumns) {
        Composite tabGroup = new Composite(composite, 0);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        tabGroup.setLayout((Layout)layout);
        this.fEnclosingTypeSelection.doFillIntoGrid(tabGroup, 1);
        Text c = this.fEnclosingTypeDialogField.getTextControl(composite);
        GridData gd = new GridData(768);
        gd.widthHint = this.getMaxFieldWidth();
        gd.horizontalSpan = 2;
        c.setLayoutData((Object)gd);
        Button button = this.fEnclosingTypeDialogField.getChangeControl(composite);
        gd = new GridData(256);
        gd.heightHint = SWTUtil.getButtonHeightHint(button);
        gd.widthHint = SWTUtil.getButtonWidthHint(button);
        button.setLayoutData((Object)gd);
    }

    protected void createTypeNameControls(Composite composite, int nColumns) {
        this.fTypeNameDialogField.doFillIntoGrid(composite, nColumns - 1);
        DialogField.createEmptySpace(composite);
        LayoutUtil.setWidthHint((Control)this.fTypeNameDialogField.getTextControl(null), this.getMaxFieldWidth());
    }

    protected void createModifierControls(Composite composite, int nColumns) {
        LayoutUtil.setHorizontalSpan((Control)this.fAccMdfButtons.getLabelControl(composite), 1);
        Composite control = this.fAccMdfButtons.getSelectionButtonsGroup(composite);
        GridData gd = new GridData(256);
        gd.horizontalSpan = nColumns - 2;
        control.setLayoutData((Object)gd);
        DialogField.createEmptySpace(composite);
        DialogField.createEmptySpace(composite);
        control = this.fOtherMdfButtons.getSelectionButtonsGroup(composite);
        gd = new GridData(256);
        gd.horizontalSpan = nColumns - 2;
        control.setLayoutData((Object)gd);
        DialogField.createEmptySpace(composite);
    }

    protected void createSuperClassControls(Composite composite, int nColumns) {
        this.fSuperClassDialogField.doFillIntoGrid(composite, nColumns);
        LayoutUtil.setWidthHint((Control)this.fSuperClassDialogField.getTextControl(null), this.getMaxFieldWidth());
    }

    protected void createSuperInterfacesControls(Composite composite, int nColumns) {
        this.fSuperInterfacesDialogField.doFillIntoGrid(composite, nColumns);
        GridData gd = (GridData)this.fSuperInterfacesDialogField.getListControl(null).getLayoutData();
        gd.heightHint = this.fIsClass ? this.convertHeightInCharsToPixels(3) : this.convertHeightInCharsToPixels(6);
        gd.grabExcessVerticalSpace = false;
        gd.widthHint = this.getMaxFieldWidth();
    }

    protected void setFocus() {
        this.fTypeNameDialogField.setFocus();
    }

    private void typePageDialogFieldChanged(DialogField field) {
        String fieldName = null;
        if (field == this.fPackageDialogField) {
            this.fPackageStatus = this.packageChanged();
            this.updatePackageStatusLabel();
            this.fTypeNameStatus = this.typeNameChanged();
            fieldName = PACKAGE;
        } else if (field == this.fEnclosingTypeDialogField) {
            this.fTypeNameStatus = this.typeNameChanged();
            fieldName = ENCLOSING;
        } else if (field == this.fEnclosingTypeSelection) {
            this.updateEnableState();
            boolean isEnclosedType = this.isEnclosingTypeSelected();
            if (!isEnclosedType) {
                if (this.fAccMdfButtons.isSelected(2) || this.fAccMdfButtons.isSelected(3)) {
                    this.fAccMdfButtons.setSelection(2, false);
                    this.fAccMdfButtons.setSelection(3, false);
                    this.fAccMdfButtons.setSelection(0, true);
                }
                if (this.fOtherMdfButtons.isSelected(this.fStaticMdfIndex)) {
                    this.fOtherMdfButtons.setSelection(this.fStaticMdfIndex, false);
                }
            }
            this.fAccMdfButtons.enableSelectionButton(2, isEnclosedType && this.fIsClass);
            this.fAccMdfButtons.enableSelectionButton(3, isEnclosedType && this.fIsClass);
            this.fOtherMdfButtons.enableSelectionButton(this.fStaticMdfIndex, isEnclosedType);
            this.fTypeNameStatus = this.typeNameChanged();
            fieldName = ENCLOSINGSELECTION;
        } else if (field == this.fTypeNameDialogField) {
            this.fTypeNameStatus = this.typeNameChanged();
            fieldName = TYPENAME;
        } else if (field == this.fSuperClassDialogField) {
            fieldName = SUPER;
        } else if (field == this.fSuperInterfacesDialogField) {
            fieldName = INTERFACES;
        } else if (field == this.fOtherMdfButtons) {
            this.fModifierStatus = this.modifiersChanged();
            fieldName = MODIFIERS;
        } else {
            fieldName = METHODS;
        }
        this.handleFieldChanged(fieldName);
    }

    protected void handleFieldChanged(String fieldName) {
        super.handleFieldChanged(fieldName);
        if (fieldName == "NewContainerWizardPage.container") {
            this.fPackageStatus = this.packageChanged();
            this.fTypeNameStatus = this.typeNameChanged();
        }
    }

    public String getPackageText() {
        return this.fPackageDialogField.getText();
    }

    public String getEnclosingTypeText() {
        return this.fEnclosingTypeDialogField.getText();
    }

    public IPackageFragment getPackageFragment() {
        if (!this.isEnclosingTypeSelected()) {
            return this.fCurrPackage;
        }
        return null;
    }

    public void setPackageFragment(IPackageFragment pack, boolean canBeModified) {
        this.fCurrPackage = pack;
        this.fCanModifyPackage = canBeModified;
        String str = pack == null ? "" : pack.getElementName();
        this.fPackageDialogField.setText(str);
        this.updateEnableState();
    }

    public IType getEnclosingType() {
        return null;
    }

    public boolean isEnclosingTypeSelected() {
        return this.fEnclosingTypeSelection.isSelected();
    }

    public void setEnclosingTypeSelection(boolean isSelected, boolean canBeModified) {
        this.fEnclosingTypeSelection.setSelection(isSelected);
        this.fEnclosingTypeSelection.setEnabled(canBeModified);
        this.updateEnableState();
    }

    public String getTypeName() {
        return this.fTypeNameDialogField.getText();
    }

    public void setTypeName(String name, boolean canBeModified) {
        this.fTypeNameDialogField.setText(name);
        this.fTypeNameDialogField.setEnabled(canBeModified);
    }

    public int getModifiers() {
        int mdf = 0;
        if (this.fAccMdfButtons.isSelected(0)) {
            mdf += this.F_PUBLIC;
        } else if (this.fAccMdfButtons.isSelected(2)) {
            mdf += this.F_PRIVATE;
        } else if (this.fAccMdfButtons.isSelected(3)) {
            mdf += this.F_PROTECTED;
        }
        if (this.fOtherMdfButtons.isSelected(1)) {
            mdf += this.F_FINAL;
        }
        if (this.fOtherMdfButtons.isSelected(this.fStaticMdfIndex)) {
            mdf += this.F_STATIC;
        }
        return mdf;
    }

    public void setModifiers(int modifiers, boolean canBeModified) {
        if (Flags.isPublic(modifiers)) {
            this.fAccMdfButtons.setSelection(0, true);
        } else if (Flags.isPrivate(modifiers)) {
            this.fAccMdfButtons.setSelection(2, true);
        } else if (Flags.isProtected(modifiers)) {
            this.fAccMdfButtons.setSelection(3, true);
        } else {
            this.fAccMdfButtons.setSelection(1, true);
        }
        if (Flags.isFinal(modifiers)) {
            this.fOtherMdfButtons.setSelection(1, true);
        }
        if (Flags.isStatic(modifiers)) {
            this.fOtherMdfButtons.setSelection(this.fStaticMdfIndex, true);
        }
        this.fAccMdfButtons.setEnabled(canBeModified);
        this.fOtherMdfButtons.setEnabled(canBeModified);
    }

    public String getSuperClass() {
        return this.fSuperClassDialogField.getText();
    }

    public void setSuperClass(String name, boolean canBeModified) {
        this.fSuperClassDialogField.setText(name);
        this.fSuperClassDialogField.setEnabled(canBeModified);
    }

    public List getSuperInterfaces() {
        return this.fSuperInterfacesDialogField.getElements();
    }

    public void setSuperInterfaces(List interfacesNames, boolean canBeModified) {
        this.fSuperInterfacesDialogField.setElements(interfacesNames);
        this.fSuperInterfacesDialogField.setEnabled(canBeModified);
    }

    protected IStatus packageChanged() {
        StatusInfo status = new StatusInfo();
        this.fPackageDialogField.enableButton(this.getPackageFragmentRoot() != null);
        return status;
    }

    private void updatePackageStatusLabel() {
        String packName = this.getPackageText();
        if (packName.length() == 0) {
            this.fPackageDialogField.setStatus(NewWizardMessages.getString("NewTypeWizardPage.default"));
        } else {
            this.fPackageDialogField.setStatus("");
        }
    }

    private void updateEnableState() {
        boolean enclosing = this.isEnclosingTypeSelected();
        this.fPackageDialogField.setEnabled(this.fCanModifyPackage && !enclosing);
        this.fEnclosingTypeDialogField.setEnabled(this.fCanModifyEnclosingType && enclosing);
    }

    protected IStatus typeNameChanged() {
        StatusInfo status = new StatusInfo();
        String typeName = this.getTypeName();
        if (typeName.length() == 0) {
            status.setError(NewWizardMessages.getString("NewTypeWizardPage.error.EnterTypeName"));
            return status;
        }
        if (typeName.indexOf(46) != -1) {
            status.setError(NewWizardMessages.getString("NewTypeWizardPage.error.QualifiedName"));
            return status;
        }
        if (!this.isEnclosingTypeSelected()) {
            ICompilationUnit cu;
            IPackageFragment pack = this.getPackageFragment();
            if (pack != null && (cu = pack.getCompilationUnit(String.valueOf(typeName) + ".java")).getResource().exists()) {
                status.setError(NewWizardMessages.getString("NewTypeWizardPage.error.TypeNameExists"));
                return status;
            }
        } else {
            IType member;
            IType type = this.getEnclosingType();
            if (type != null && (member = type.getType(typeName)).exists()) {
                status.setError(NewWizardMessages.getString("NewTypeWizardPage.error.TypeNameExists"));
                return status;
            }
        }
        return status;
    }

    protected IStatus modifiersChanged() {
        StatusInfo status = new StatusInfo();
        this.getModifiers();
        return status;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void createType(IProgressMonitor monitor) throws CoreException, InterruptedException {
        block14: {
            if (monitor == null) {
                monitor = new NullProgressMonitor();
            }
            monitor.beginTask(NewWizardMessages.getString("NewTypeWizardPage.operationdesc"), 10);
            ICompilationUnit createdWorkingCopy = null;
            try {
                ICompilationUnit cu;
                monitor.worked(1);
                String clName = this.getTypeName();
                boolean isInnerClass = this.isEnclosingTypeSelected();
                int indent = 0;
                PreferenceConstants.getPreferenceStore();
                String lineDelimiter = null;
                lineDelimiter = System.getProperty("line.separator", "\n");
                this.constructTypeStub(lineDelimiter);
                IType createdType = createdWorkingCopy.getType(clName);
                ICompilationUnit iCompilationUnit = cu = createdType.getCompilationUnit();
                synchronized (iCompilationUnit) {
                    cu.reconcile();
                }
                iCompilationUnit = cu;
                synchronized (iCompilationUnit) {
                    cu.reconcile();
                }
                ISourceRange range = createdType.getSourceRange();
                IBuffer buf = cu.getBuffer();
                String originalContent = buf.getText(range.getOffset(), range.getLength());
                String formattedContent = StubUtility.codeFormat(originalContent, indent, lineDelimiter);
                buf.replace(range.getOffset(), range.getLength(), formattedContent);
                if (!isInnerClass) {
                    String fileComment = this.getFileComment(cu);
                    if (fileComment != null && fileComment.length() > 0) {
                        buf.replace(0, 0, String.valueOf(fileComment) + lineDelimiter);
                    }
                    cu.commit(false, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                } else {
                    monitor.worked(1);
                }
                this.fCreatedType = createdType;
            }
            catch (Throwable throwable) {
                Object var14_15 = null;
                if (createdWorkingCopy != null) {
                    createdWorkingCopy.destroy();
                }
                monitor.done();
                throw throwable;
            }
            {
                Object var14_16 = null;
                if (createdWorkingCopy == null) break block14;
            }
            createdWorkingCopy.destroy();
        }
        monitor.done();
    }

    public IType getCreatedType() {
        return this.fCreatedType;
    }

    private String constructTypeStub(String lineDelimiter) {
        StringBuffer buf = new StringBuffer();
        int modifiers = this.getModifiers();
        buf.append(Flags.toString(modifiers));
        if (modifiers != 0) {
            buf.append(' ');
        }
        buf.append(this.fIsClass ? "class " : "interface ");
        buf.append(this.getTypeName());
        buf.append('{');
        buf.append(lineDelimiter);
        buf.append(lineDelimiter);
        buf.append('}');
        buf.append(lineDelimiter);
        return buf.toString();
    }

    protected String getFileComment(ICompilationUnit parentCU) {
        return null;
    }

    private boolean isValidComment(String template) {
        Scanner scanner = ToolFactory.createScanner(true, false, false);
        scanner.setSource(template.toCharArray());
        try {
            int next = scanner.getNextToken();
            while (next == 901 || next == 903 || next == 902) {
                next = scanner.getNextToken();
            }
            return next == 0;
        }
        catch (InvalidInputException invalidInputException) {
            return false;
        }
    }

    protected String getTypeComment(ICompilationUnit parentCU) {
        if (PreferenceConstants.getPreferenceStore().getBoolean("net.sourceforge.phpdt.ui.phpdoc")) {
            try {
                StringBuffer typeName = new StringBuffer();
                if (this.isEnclosingTypeSelected()) {
                    typeName.append(JavaModelUtil.getTypeQualifiedName(this.getEnclosingType())).append('.');
                }
                typeName.append(this.getTypeName());
                String comment = CodeGeneration.getTypeComment(parentCU, typeName.toString(), String.valueOf('\n'));
                if (comment != null && this.isValidComment(comment)) {
                    return comment;
                }
            }
            catch (CoreException e) {
                PHPeclipsePlugin.log(e);
            }
        }
        return null;
    }

    protected String getTemplate(String name, ICompilationUnit parentCU) {
        return this.getTemplate(name, parentCU, 0);
    }

    protected String getTemplate(String name, ICompilationUnit parentCU, int pos) {
        try {
            Template[] templates = Templates.getInstance().getTemplates(name);
            if (templates.length > 0) {
                return JavaContext.evaluateTemplate(templates[0], parentCU, pos);
            }
        }
        catch (CoreException e) {
            PHPeclipsePlugin.log(e);
        }
        catch (BadLocationException e1) {
            e1.printStackTrace();
        }
        catch (TemplateException e1) {
            e1.printStackTrace();
        }
        return null;
    }

    private class InterfacesListLabelProvider
    extends LabelProvider {
        private Image fInterfaceImage = PHPUiImages.get("net.sourceforge.phpdt.internal.ui.int_obj.gif");

        public Image getImage(Object element) {
            return this.fInterfaceImage;
        }
    }

    private class TypeFieldsAdapter
    implements IStringButtonAdapter,
    IDialogFieldListener,
    IListAdapter {
        TypeFieldsAdapter() {
        }

        public void changeControlPressed(DialogField field) {
        }

        public void customButtonPressed(ListDialogField field, int index) {
        }

        public void selectionChanged(ListDialogField field) {
        }

        public void dialogFieldChanged(DialogField field) {
            NewTypeWizardPage.this.typePageDialogFieldChanged(field);
        }

        public void doubleClicked(ListDialogField field) {
        }
    }
}

