/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.phpeclipse.actions;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.Iterator;
import net.sourceforge.phpeclipse.PHPeclipsePlugin;
import net.sourceforge.phpeclipse.ui.editor.ShowExternalPreviewAction;
import net.sourceforge.phpeclipse.ui.overlaypages.ProjectPrefUtil;
import net.sourceforge.phpeclipse.webbrowser.IWebBrowser;
import net.sourceforge.phpeclipse.webbrowser.internal.BrowserManager;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPart;

public class PHPEclipseShowAction
implements IObjectActionDelegate {
    private IWorkbenchPart workbenchPart;

    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
        this.workbenchPart = targetPart;
    }

    public void run(IAction action) {
        ISelectionProvider selectionProvider = null;
        selectionProvider = this.workbenchPart.getSite().getSelectionProvider();
        StructuredSelection selection = null;
        selection = (StructuredSelection)selectionProvider.getSelection();
        IPreferenceStore store = PHPeclipsePlugin.getDefault().getPreferenceStore();
        Shell shell = null;
        Iterator iterator = null;
        iterator = selection.iterator();
        while (iterator.hasNext()) {
            Object obj = iterator.next();
            if (!(obj instanceof IResource)) continue;
            IResource resource = (IResource)obj;
            switch (resource.getType()) {
                case 1: {
                    IFile previewFile = (IFile)resource;
                    String extension = previewFile.getFileExtension().toLowerCase();
                    ProjectPrefUtil.getPreviewBooleanValue((IResource)previewFile, (String)"_bring_to_top_preview");
                    boolean bl = "html".equals(extension) || "htm".equals(extension) || "xhtml".equals(extension);
                    boolean bl2 = "xml".equals(extension) || "xsd".equals(extension) || "dtd".equals(extension);
                    String localhostURL = ShowExternalPreviewAction.getLocalhostURL((IPreferenceStore)store, (IFile)previewFile);
                    if (localhostURL == null) {
                        MessageDialog.openInformation(shell, (String)"Couldn't create localhost URL", (String)"Please configure your localhost and documentRoot");
                        return;
                    }
                    try {
                        PHPEclipseShowAction.open(new URL(localhostURL), shell, localhostURL);
                        break;
                    }
                    catch (MalformedURLException e) {
                        MessageDialog.openInformation(shell, (String)"MalformedURLException: ", (String)e.toString());
                    }
                }
            }
        }
    }

    public void selectionChanged(IAction action, ISelection selection) {
    }

    public static void open(URL url, Shell shell, String dialogTitle) {
        BrowserManager manager = BrowserManager.getInstance();
        IWebBrowser browser = manager.getCurrentWebBrowser();
        browser.openURL(url);
    }
}

