/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.phpeclipse.actions;

import java.io.File;
import java.util.List;
import net.sourceforge.phpdt.internal.ui.viewsupport.ListContentProvider;
import net.sourceforge.phpeclipse.PHPeclipsePlugin;
import net.sourceforge.phpeclipse.actions.IncludesScanner;
import net.sourceforge.phpeclipse.phpeditor.PHPEditor;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.TextSelection;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Point;
import org.eclipse.ui.IEditorActionDelegate;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.actions.ActionDelegate;
import org.eclipse.ui.dialogs.ListSelectionDialog;

public class PHPOpenAllIncludesEditorAction
extends ActionDelegate
implements IEditorActionDelegate {
    private IWorkbenchWindow fWindow;
    private PHPEditor fEditor;
    private IProject fProject;
    private IncludesScanner fIncludesScanner;

    public void dispose() {
    }

    public void init(IWorkbenchWindow window) {
        this.fWindow = window;
    }

    public void selectionChanged(IAction action, ISelection selection) {
        if (!selection.isEmpty()) {
            if (selection instanceof TextSelection) {
                action.setEnabled(true);
            } else if (this.fWindow.getActivePage() != null) {
                this.fWindow.getActivePage().getActivePart();
            }
        }
    }

    private IWorkbenchPage getActivePage() {
        IWorkbenchWindow workbenchWindow = this.fEditor.getEditorSite().getWorkbenchWindow();
        IWorkbenchPage page = workbenchWindow.getActivePage();
        return page;
    }

    public IContainer getWorkingLocation(IFileEditorInput editorInput) {
        if (editorInput == null || editorInput.getFile() == null) {
            return null;
        }
        return editorInput.getFile().getParent();
    }

    private IFile getIncludeFile(IProject project, IFileEditorInput editorInput, String relativeFilename) {
        Path path;
        IContainer container = this.getWorkingLocation(editorInput);
        project.getLocation().toString();
        IFile file = null;
        if (relativeFilename.startsWith("../")) {
            Path path2 = new Path(relativeFilename);
            file = container.getFile((IPath)path2);
            return file;
        }
        int index = relativeFilename.lastIndexOf(47);
        if (index >= 0 && (file = project.getFile((IPath)(path = new Path(relativeFilename)))).exists()) {
            return file;
        }
        path = new Path(relativeFilename);
        file = container.getFile((IPath)path);
        return file;
    }

    public void run(IAction action) {
        block10: {
            IEditorPart targetEditor;
            if (this.fEditor == null && (targetEditor = this.fWindow.getActivePage().getActiveEditor()) != null && targetEditor instanceof PHPEditor) {
                this.fEditor = (PHPEditor)targetEditor;
            }
            if (this.fEditor != null) {
                IFile f = ((IFileEditorInput)this.fEditor.getEditorInput()).getFile();
                this.fProject = f.getProject();
                ITextSelection selection = (ITextSelection)this.fEditor.getSelectionProvider().getSelection();
                IDocument doc = this.fEditor.getDocumentProvider().getDocument((Object)this.fEditor.getEditorInput());
                this.fIncludesScanner = new IncludesScanner(this.fProject, (IFileEditorInput)this.fEditor.getEditorInput());
                int pos = selection.getOffset();
                String filename = this.getPHPIncludeText(doc, pos);
                if (filename != null && !filename.equals("")) {
                    try {
                        IFile file = this.fIncludesScanner.getIncludeFile(filename);
                        this.fIncludesScanner.addFile(file);
                    }
                    catch (Exception exception) {}
                    try {
                        Object[] locations;
                        List list = this.fIncludesScanner.getList();
                        if (list == null || list.size() <= 0) break block10;
                        String workspaceLocation = String.valueOf(this.fProject.getLocation().toString()) + File.separatorChar;
                        ListSelectionDialog listSelectionDialog = new ListSelectionDialog(PHPeclipsePlugin.getDefault().getWorkbench().getActiveWorkbenchWindow().getShell(), (Object)list, (IStructuredContentProvider)new ListContentProvider(), (ILabelProvider)new LabelProvider(), "Select the includes to open.");
                        listSelectionDialog.setTitle("Multiple includes found");
                        if (listSelectionDialog.open() != 0 || (locations = listSelectionDialog.getResult()) == null) break block10;
                        try {
                            int i = 0;
                            while (i < locations.length) {
                                String openFilename = String.valueOf(workspaceLocation) + (String)locations[i];
                                PHPeclipsePlugin.getDefault().openFileInTextEditor(openFilename);
                                ++i;
                            }
                        }
                        catch (CoreException e) {
                            e.printStackTrace();
                        }
                    }
                    catch (Exception exception) {}
                }
            }
        }
    }

    public void setActiveEditor(IAction action, IEditorPart targetEditor) {
        if (targetEditor != null && targetEditor instanceof PHPEditor) {
            this.fEditor = (PHPEditor)targetEditor;
        }
    }

    private String getPHPIncludeText(IDocument doc, int pos) {
        Point word = null;
        int start = -1;
        int end = -1;
        try {
            char character;
            int position = pos;
            while (position >= 0) {
                character = doc.getChar(position);
                if (character == '\"' || character == '\'' || character == '\r' || character == '\n') break;
                --position;
            }
            start = position;
            position = pos;
            int length = doc.getLength();
            while (position < length) {
                character = doc.getChar(position);
                if (character == '\"' || character == '\'' || character == '\r' || character == '\n') break;
                ++position;
            }
            if ((end = position) > ++start) {
                word = new Point(start, end - start);
            }
        }
        catch (BadLocationException badLocationException) {}
        if (word != null) {
            try {
                return doc.get(word.x, word.y);
            }
            catch (BadLocationException badLocationException) {}
        }
        return "";
    }
}

