/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.phpeclipse.obfuscator;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Iterator;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import net.sourceforge.phpeclipse.PHPeclipsePlugin;
import net.sourceforge.phpeclipse.obfuscator.PHPIdentifier;
import org.eclipse.core.runtime.CoreException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class ObfuscatorIgnoreSet {
    private static final String TEMPLATE_TAG = "ignore";
    private HashMap fIdentifierMap = new HashMap();

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void addFromFile(File file) throws CoreException {
        FileInputStream stream = null;
        try {
            try {
                stream = new FileInputStream(file);
                this.addFromStream(stream);
            }
            catch (IOException e) {
                ObfuscatorIgnoreSet.throwReadException(e);
            }
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            try {
                if (stream == null) throw throwable;
                ((InputStream)stream).close();
                throw throwable;
            }
            catch (IOException iOException) {}
            throw throwable;
        }
        {
            Object var4_6 = null;
        }
        try {}
        catch (IOException iOException) {
            return;
        }
        if (stream == null) return;
        ((InputStream)stream).close();
    }

    public void addFromStream(InputStream stream) throws CoreException {
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder parser = factory.newDocumentBuilder();
            Document document = parser.parse(new InputSource(stream));
            NodeList elements = document.getElementsByTagName(TEMPLATE_TAG);
            int count = elements.getLength();
            int i = 0;
            while (i != count) {
                Node node = elements.item(i);
                NamedNodeMap attributes = node.getAttributes();
                if (attributes != null) {
                    StringBuffer buffer = new StringBuffer();
                    NodeList children = node.getChildNodes();
                    int j = 0;
                    while (j != children.getLength()) {
                        String value = children.item(j).getNodeValue();
                        if (value != null) {
                            buffer.append(value);
                        }
                        ++j;
                    }
                    String pattern = buffer.toString().trim();
                    this.fIdentifierMap.put(pattern, new PHPIdentifier(pattern, 3));
                }
                ++i;
            }
        }
        catch (ParserConfigurationException e) {
            ObfuscatorIgnoreSet.throwReadException(e);
        }
        catch (IOException e) {
            ObfuscatorIgnoreSet.throwReadException(e);
        }
        catch (SAXException e) {
            ObfuscatorIgnoreSet.throwReadException(e);
        }
    }

    private String getAttributeValue(NamedNodeMap attributes, String name) {
        Node node = attributes.getNamedItem(name);
        return node == null ? null : node.getNodeValue();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void saveToFile(File file) throws CoreException {
        FileOutputStream stream = null;
        try {
            try {
                stream = new FileOutputStream(file);
                this.saveToStream(stream);
            }
            catch (IOException e) {
                ObfuscatorIgnoreSet.throwWriteException(e);
            }
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            try {
                if (stream == null) throw throwable;
                ((OutputStream)stream).close();
                throw throwable;
            }
            catch (IOException iOException) {}
            throw throwable;
        }
        {
            Object var4_6 = null;
        }
        try {}
        catch (IOException iOException) {
            return;
        }
        if (stream == null) return;
        ((OutputStream)stream).close();
    }

    public void saveToStream(OutputStream stream) throws CoreException {
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document document = builder.newDocument();
            Element root = document.createElement("obfuscator");
            document.appendChild(root);
            Iterator iter = this.fIdentifierMap.keySet().iterator();
            while (iter.hasNext()) {
                Element node = document.createElement(TEMPLATE_TAG);
                root.appendChild(node);
                Text pattern = document.createTextNode((String)iter.next());
                node.appendChild(pattern);
            }
            Transformer transformer = TransformerFactory.newInstance().newTransformer();
            transformer.setOutputProperty("method", "xml");
            transformer.setOutputProperty("encoding", "UTF-8");
            DOMSource source = new DOMSource(document);
            StreamResult result = new StreamResult(stream);
            transformer.transform(source, result);
        }
        catch (ParserConfigurationException e) {
            ObfuscatorIgnoreSet.throwWriteException(e);
        }
        catch (TransformerException e) {
            ObfuscatorIgnoreSet.throwWriteException(e);
        }
    }

    private static void throwReadException(Throwable t) throws CoreException {
        PHPeclipsePlugin.log(t);
    }

    private static void throwWriteException(Throwable t) throws CoreException {
        PHPeclipsePlugin.log(t);
    }

    public void clear() {
        this.fIdentifierMap.clear();
    }

    public HashMap getIdentifierMap() {
        return this.fIdentifierMap;
    }
}

