/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.phpeclipse.obfuscator;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import net.sourceforge.phpdt.core.compiler.ITerminalSymbols;
import net.sourceforge.phpdt.core.compiler.InvalidInputException;
import net.sourceforge.phpdt.internal.compiler.parser.Scanner;
import net.sourceforge.phpdt.internal.compiler.parser.SyntaxError;
import net.sourceforge.phpdt.internal.compiler.util.Util;
import net.sourceforge.phpdt.internal.ui.util.PHPFileUtil;
import net.sourceforge.phpeclipse.PHPeclipsePlugin;
import net.sourceforge.phpeclipse.obfuscator.PHPIdentifier;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;

public class ObfuscatorPass1Exporter
implements ITerminalSymbols {
    protected Scanner fScanner;
    protected int fToken;
    protected HashMap fIdentifierMap;

    public ObfuscatorPass1Exporter(Scanner scanner, HashMap identifierMap) {
        this.fScanner = scanner;
        this.fIdentifierMap = identifierMap;
    }

    private void getNextToken() {
        try {
            this.fToken = this.fScanner.getNextToken();
            return;
        }
        catch (InvalidInputException invalidInputException) {
            this.fToken = 1;
            return;
        }
    }

    private void parseIdentifiers(boolean goBack) {
        int counter = 0;
        PHPeclipsePlugin.getDefault().getPreferenceStore();
        try {
            while (this.fToken != 0 && this.fToken != 1) {
                PHPIdentifier value;
                String identifier;
                if (this.fToken == 150) {
                    identifier = new String(this.fScanner.getCurrentIdentifierSource());
                    value = (PHPIdentifier)this.fIdentifierMap.get(identifier);
                    if (value == null) {
                        this.fIdentifierMap.put(identifier, new PHPIdentifier(null, 3));
                    }
                    this.getNextToken();
                    continue;
                }
                if (this.fToken == 136) {
                    int i = this.fScanner.startPosition;
                    ArrayList<String> varList = new ArrayList<String>();
                    while (i < this.fScanner.currentPosition) {
                        char currentCharacter;
                        if ((currentCharacter = this.fScanner.source[i++]) != '$' || this.fScanner.source[i - 2] == '\\') continue;
                        StringBuffer varName = new StringBuffer();
                        varName.append("$");
                        while (i < this.fScanner.currentPosition) {
                            if (!Scanner.isPHPIdentifierPart(currentCharacter = this.fScanner.source[i++])) break;
                            varName.append(currentCharacter);
                        }
                        varList.add(varName.toString());
                    }
                    i = 0;
                    while (i < varList.size()) {
                        identifier = (String)varList.get(i);
                        value = (PHPIdentifier)this.fIdentifierMap.get(identifier);
                        if (value == null) {
                            this.fIdentifierMap.put(identifier, new PHPIdentifier(null, 3));
                        }
                        ++i;
                    }
                    this.getNextToken();
                    continue;
                }
                if (this.fToken == 130) {
                    this.getNextToken();
                    ++counter;
                    continue;
                }
                if (this.fToken == 131) {
                    this.getNextToken();
                    if (--counter != 0 || !goBack) continue;
                    return;
                }
                this.getNextToken();
            }
        }
        catch (SyntaxError syntaxError) {}
    }

    public void createFolder(IPath destinationPath) {
    }

    public void write(IResource resource, IPath destinationPath) throws CoreException, IOException {
        if (resource.getType() == 1) {
            this.writeFile((IFile)resource, destinationPath);
        } else {
            this.writeChildren((IContainer)resource, destinationPath);
        }
    }

    protected void writeChildren(IContainer folder, IPath destinationPath) throws CoreException, IOException {
        if (folder.isAccessible()) {
            IResource[] children = folder.members();
            int i = 0;
            while (i < children.length) {
                IResource child = children[i];
                this.writeResource(child, destinationPath.append(child.getName()));
                ++i;
            }
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void writeFile(IFile file, IPath destinationPath) throws IOException, CoreException {
        if (!PHPFileUtil.isPHPFile(file)) {
            return;
        }
        BufferedInputStream stream = null;
        char[] charArray = null;
        try {
            try {
                stream = new BufferedInputStream(file.getContents());
                charArray = Util.getInputStreamAsCharArray(stream, -1, null);
            }
            catch (IOException iOException) {
                Object var5_5 = null;
                try {
                    if (stream == null) return;
                    ((InputStream)stream).close();
                    return;
                }
                catch (IOException iOException2) {}
                return;
            }
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            try {}
            catch (IOException iOException) {}
            if (stream == null) throw throwable;
            ((InputStream)stream).close();
            throw throwable;
            throw throwable;
        }
        {
            Object var5_7 = null;
        }
        try {}
        catch (IOException iOException) {}
        if (stream != null) {
            ((InputStream)stream).close();
        }
        if (charArray == null) {
            return;
        }
        this.fScanner.setSource(charArray);
        this.fScanner.setPHPMode(false);
        this.fToken = 0;
        this.getNextToken();
        this.parseIdentifiers(false);
    }

    protected void writeResource(IResource resource, IPath destinationPath) throws CoreException, IOException {
        if (resource.getType() == 1) {
            this.writeFile((IFile)resource, destinationPath);
        } else {
            this.createFolder(destinationPath);
            this.writeChildren((IContainer)resource, destinationPath);
        }
    }
}

