/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.phpeclipse.obfuscator.export;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import net.sourceforge.phpdt.internal.compiler.parser.Scanner;
import net.sourceforge.phpeclipse.PHPeclipsePlugin;
import net.sourceforge.phpeclipse.obfuscator.ObfuscatorIgnores;
import net.sourceforge.phpeclipse.obfuscator.ObfuscatorPass1Exporter;
import net.sourceforge.phpeclipse.obfuscator.ObfuscatorPass2Exporter;
import net.sourceforge.phpeclipse.obfuscator.export.ObfuscatorExportMessages;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.operation.ModalContext;
import org.eclipse.ui.dialogs.IOverwriteQuery;

class ObfuscatorExportOperation
implements IRunnableWithProgress {
    private IPath fPath;
    private IProgressMonitor fMonitor;
    private ObfuscatorPass1Exporter fExporter1 = null;
    private ObfuscatorPass2Exporter fExporter2 = null;
    private HashMap fCurrentIdentifierMap = null;
    private HashMap fProjectMap = null;
    private String fCurrentProjectName = "";
    private List fResourcesToExport;
    private IOverwriteQuery fOverwriteCallback;
    private IResource fResource;
    private List errorTable = new ArrayList(1);
    private static final int OVERWRITE_NOT_SET = 0;
    private static final int OVERWRITE_NONE = 1;
    private static final int OVERWRITE_ALL = 2;
    private int overwriteState = 0;
    private boolean createContainerDirectories = true;

    public ObfuscatorExportOperation(IResource res, String destinationPath, IOverwriteQuery overwriteImplementor) {
        this.fResource = res;
        this.fPath = new Path(destinationPath);
        this.fOverwriteCallback = overwriteImplementor;
    }

    public ObfuscatorExportOperation(IResource res, List resources, String destinationPath, IOverwriteQuery overwriteImplementor) {
        this(res, destinationPath, overwriteImplementor);
        this.fResourcesToExport = resources;
    }

    protected void addError(String message, Throwable e) {
        this.errorTable.add(new Status(4, "org.eclipse.ui", 0, message, e));
    }

    protected int countChildrenOf(IResource resource) throws CoreException {
        if (resource.getType() == 1) {
            return 1;
        }
        int count = 0;
        if (resource.isAccessible()) {
            IResource[] children = ((IContainer)resource).members();
            int i = 0;
            while (i < children.length) {
                count += this.countChildrenOf(children[i]);
                ++i;
            }
        }
        return count;
    }

    protected int countSelectedResources() throws CoreException {
        int result = 0;
        Iterator resources = this.fResourcesToExport.iterator();
        while (resources.hasNext()) {
            result += this.countChildrenOf((IResource)resources.next());
        }
        return result;
    }

    protected void createLeadupDirectoriesFor(IResource resource) {
        IPath resourcePath = resource.getFullPath().removeLastSegments(1);
        int i = 0;
        while (i < resourcePath.segmentCount()) {
            this.fPath = this.fPath.append(resourcePath.segment(i));
            this.fExporter2.createFolder(this.fPath);
            ++i;
        }
    }

    protected void exportAllResources1() throws InterruptedException {
        if (this.fResource.getType() == 1) {
            this.exportFile1((IFile)this.fResource, this.fPath);
        } else {
            try {
                this.setExporters(this.fResource);
                this.exportChildren1(((IContainer)this.fResource).members(), this.fPath);
            }
            catch (CoreException e) {
                this.errorTable.add(e);
            }
        }
    }

    protected void exportAllResources2() throws InterruptedException {
        if (this.fResource.getType() == 1) {
            this.exportFile2((IFile)this.fResource, this.fPath);
        } else {
            try {
                this.setExporters(this.fResource);
                this.exportChildren2(((IContainer)this.fResource).members(), this.fPath);
            }
            catch (CoreException e) {
                this.errorTable.add(e);
            }
        }
    }

    protected void exportChildren1(IResource[] children, IPath currentPath) throws InterruptedException {
        int i = 0;
        while (i < children.length) {
            IResource child = children[i];
            if (child.isAccessible()) {
                if (child.getType() == 1) {
                    this.exportFile1((IFile)child, currentPath);
                } else {
                    IPath destination = currentPath.append(child.getName());
                    this.fExporter1.createFolder(destination);
                    try {
                        this.exportChildren1(((IContainer)child).members(), destination);
                    }
                    catch (CoreException e) {
                        this.errorTable.add(e.getStatus());
                    }
                }
            }
            ++i;
        }
    }

    protected void exportChildren2(IResource[] children, IPath currentPath) throws InterruptedException {
        int i = 0;
        while (i < children.length) {
            IResource child = children[i];
            if (child.isAccessible()) {
                if (child.getType() == 1) {
                    this.exportFile2((IFile)child, currentPath);
                } else {
                    IPath destination = currentPath.append(child.getName());
                    this.fExporter2.createFolder(destination);
                    try {
                        this.exportChildren2(((IContainer)child).members(), destination);
                    }
                    catch (CoreException e) {
                        this.errorTable.add(e.getStatus());
                    }
                }
            }
            ++i;
        }
    }

    protected void exportFile1(IFile file, IPath location) throws InterruptedException {
        IPath fullPath = location.append(file.getName());
        this.fMonitor.subTask(file.getFullPath().toString());
        String properPathString = fullPath.toOSString();
        new File(properPathString);
        try {
            this.setExporters((IResource)file);
            this.fExporter1.write((IResource)file, fullPath);
        }
        catch (IOException e) {
            this.errorTable.add(new Status(4, "org.eclipse.ui", 0, ObfuscatorExportMessages.format("ObfuscatorTransfer.errorExporting", new Object[]{fullPath, e.getMessage()}), (Throwable)e));
        }
        catch (CoreException e) {
            this.errorTable.add(new Status(4, "org.eclipse.ui", 0, ObfuscatorExportMessages.format("ObfuscatorTransfer.errorExporting", new Object[]{fullPath, e.getMessage()}), (Throwable)e));
        }
        this.fMonitor.worked(1);
        ModalContext.checkCanceled((IProgressMonitor)this.fMonitor);
    }

    protected void exportFile2(IFile file, IPath location) throws InterruptedException {
        IPath fullPath = location.append(file.getName());
        this.fMonitor.subTask(file.getFullPath().toString());
        String properPathString = fullPath.toOSString();
        File targetFile = new File(properPathString);
        if (targetFile.exists()) {
            if (!targetFile.canWrite()) {
                this.errorTable.add(new Status(4, "org.eclipse.ui", 0, ObfuscatorExportMessages.format("ObfuscatorTransfer.cannotOverwrite", new Object[]{targetFile.getAbsolutePath()}), null));
                this.fMonitor.worked(1);
                return;
            }
            if (this.overwriteState == 1) {
                return;
            }
            if (this.overwriteState != 2) {
                String overwriteAnswer = this.fOverwriteCallback.queryOverwrite(properPathString);
                if (overwriteAnswer.equals("CANCEL")) {
                    throw new InterruptedException();
                }
                if (overwriteAnswer.equals("NO")) {
                    this.fMonitor.worked(1);
                    return;
                }
                if (overwriteAnswer.equals("NOALL")) {
                    this.fMonitor.worked(1);
                    this.overwriteState = 1;
                    return;
                }
                if (overwriteAnswer.equals("ALL")) {
                    this.overwriteState = 2;
                }
            }
        }
        try {
            this.setExporters((IResource)file);
            this.fExporter2.write((IResource)file, fullPath);
        }
        catch (IOException e) {
            this.errorTable.add(new Status(4, "org.eclipse.ui", 0, ObfuscatorExportMessages.format("ObfuscatorTransfer.errorExporting", new Object[]{fullPath, e.getMessage()}), (Throwable)e));
        }
        catch (CoreException e) {
            this.errorTable.add(new Status(4, "org.eclipse.ui", 0, ObfuscatorExportMessages.format("ObfuscatorTransfer.errorExporting", new Object[]{fullPath, e.getMessage()}), (Throwable)e));
        }
        this.fMonitor.worked(1);
        ModalContext.checkCanceled((IProgressMonitor)this.fMonitor);
    }

    protected void exportSpecifiedResources1() throws InterruptedException {
        Iterator resources = this.fResourcesToExport.iterator();
        IPath initPath = (IPath)this.fPath.clone();
        while (resources.hasNext()) {
            IResource currentResource = (IResource)resources.next();
            if (!currentResource.isAccessible()) continue;
            this.setExporters(currentResource);
            this.fPath = initPath;
            if (this.fResource != null) {
                IPath containersToCreate = currentResource.getFullPath().removeFirstSegments(this.fResource.getFullPath().segmentCount()).removeLastSegments(1);
                int i = 0;
                while (i < containersToCreate.segmentCount()) {
                    this.fPath = this.fPath.append(containersToCreate.segment(i));
                    this.fExporter1.createFolder(this.fPath);
                    ++i;
                }
            }
            if (currentResource.getType() == 1) {
                this.exportFile1((IFile)currentResource, this.fPath);
                continue;
            }
            if (this.createContainerDirectories) {
                this.fPath = this.fPath.append(currentResource.getName());
                this.fExporter1.createFolder(this.fPath);
            }
            try {
                this.exportChildren1(((IContainer)currentResource).members(), this.fPath);
            }
            catch (CoreException e) {
                this.errorTable.add(e.getStatus());
            }
        }
    }

    protected void exportSpecifiedResources2() throws InterruptedException {
        Iterator resources = this.fResourcesToExport.iterator();
        IPath initPath = (IPath)this.fPath.clone();
        while (resources.hasNext()) {
            IResource currentResource = (IResource)resources.next();
            if (!currentResource.isAccessible()) continue;
            this.setExporters(currentResource);
            this.fPath = initPath;
            if (this.fResource != null) {
                IPath containersToCreate = currentResource.getFullPath().removeFirstSegments(this.fResource.getFullPath().segmentCount()).removeLastSegments(1);
                int i = 0;
                while (i < containersToCreate.segmentCount()) {
                    this.fPath = this.fPath.append(containersToCreate.segment(i));
                    this.fExporter2.createFolder(this.fPath);
                    ++i;
                }
            }
            if (currentResource.getType() == 1) {
                this.exportFile2((IFile)currentResource, this.fPath);
                continue;
            }
            if (this.createContainerDirectories) {
                this.fPath = this.fPath.append(currentResource.getName());
                this.fExporter2.createFolder(this.fPath);
            }
            try {
                this.exportChildren2(((IContainer)currentResource).members(), this.fPath);
            }
            catch (CoreException e) {
                this.errorTable.add(e.getStatus());
            }
        }
    }

    public IStatus getStatus() {
        IStatus[] errors = new IStatus[this.errorTable.size()];
        this.errorTable.toArray(errors);
        return new MultiStatus("org.eclipse.ui", 0, errors, ObfuscatorExportMessages.getString("ObfuscatorExportOperation.problemsExporting"), null);
    }

    protected boolean isDescendent(List resources, IResource child) {
        if (child.getType() == 4) {
            return false;
        }
        IContainer parent = child.getParent();
        if (resources.contains(parent)) {
            return true;
        }
        return this.isDescendent(resources, (IResource)parent);
    }

    private void setExporters(IResource resource) {
        if (this.fCurrentIdentifierMap == null) {
            if (this.fProjectMap == null) {
                this.fProjectMap = new HashMap();
            }
            this.createExporters(resource);
        } else {
            IProject project = resource.getProject();
            if (!this.fCurrentProjectName.equals(project.getName())) {
                HashMap temp = (HashMap)this.fProjectMap.get(project.getName());
                if (temp != null) {
                    this.fCurrentProjectName = project.getName();
                    this.fCurrentIdentifierMap = temp;
                    this.fExporter1 = new ObfuscatorPass1Exporter(new Scanner(false, false), this.fCurrentIdentifierMap);
                    this.fExporter2 = new ObfuscatorPass2Exporter(new Scanner(true, true), this.fCurrentIdentifierMap);
                    return;
                }
                this.createExporters(resource);
            }
        }
    }

    private void createExporters(IResource resource) {
        IProject project = resource.getProject();
        PHPeclipsePlugin.getDefault().getPreferenceStore();
        ObfuscatorIgnores ignore = new ObfuscatorIgnores(project);
        this.fCurrentIdentifierMap = ignore.getIdentifierMap();
        this.fCurrentProjectName = project.getName();
        this.fProjectMap.put(this.fCurrentProjectName, this.fCurrentIdentifierMap);
        this.fExporter1 = new ObfuscatorPass1Exporter(new Scanner(false, false), this.fCurrentIdentifierMap);
        this.fExporter2 = new ObfuscatorPass2Exporter(new Scanner(true, true), this.fCurrentIdentifierMap);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run(IProgressMonitor monitor) throws InterruptedException {
        this.fMonitor = monitor;
        IPath tempPath = (IPath)this.fPath.clone();
        if (this.fResource != null) {
            this.setExporters(this.fResource);
            if (this.createContainerDirectories && this.fResource.getType() != 1) {
                this.fPath = this.fPath.append(this.fResource.getName());
                this.fExporter2.createFolder(this.fPath);
            }
        }
        try {
            this.fCurrentIdentifierMap = null;
            this.fProjectMap = null;
            this.fCurrentProjectName = "";
            int totalWork = -1;
            try {
                totalWork = this.fResourcesToExport == null ? this.countChildrenOf(this.fResource) : this.countSelectedResources();
            }
            catch (CoreException e) {
                this.errorTable.add(e.getStatus());
            }
            monitor.beginTask(ObfuscatorExportMessages.getString("ObfuscatorTransfer.exportingTitle1"), totalWork);
            if (this.fResourcesToExport == null) {
                this.exportAllResources1();
            } else {
                this.exportSpecifiedResources1();
            }
            this.fPath = tempPath;
            monitor.beginTask(ObfuscatorExportMessages.getString("ObfuscatorTransfer.exportingTitle2"), totalWork);
            if (this.fResourcesToExport == null) {
                this.exportAllResources2();
            } else {
                this.exportSpecifiedResources2();
            }
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            monitor.done();
            throw throwable;
        }
        {
            Object var5_7 = null;
        }
        monitor.done();
    }

    public void setOverwriteFiles(boolean value) {
        if (value) {
            this.overwriteState = 2;
        }
    }
}

