/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.phpeclipse.obfuscator.export;

import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.util.List;
import net.sourceforge.phpeclipse.obfuscator.export.ObfuscatorExportMessages;
import net.sourceforge.phpeclipse.obfuscator.export.ObfuscatorExportOperation;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.dialogs.IOverwriteQuery;
import org.eclipse.ui.dialogs.WizardExportResourcesPage;

class WizardObfuscatorResourceExportPage1
extends WizardExportResourcesPage
implements Listener {
    private Combo destinationNameField;
    private Button destinationBrowseButton;
    protected Button overwriteExistingFilesCheckbox;
    private static final int SIZING_TEXT_FIELD_WIDTH = 250;
    private static final String STORE_DESTINATION_NAMES_ID = "WizardObfuscatorResourceExportPage1.STORE_DESTINATION_NAMES_ID";
    private static final String STORE_OVERWRITE_EXISTING_FILES_ID = "WizardObfuscatorResourceExportPage1.STORE_OVERWRITE_EXISTING_FILES_ID";
    private static final String SELECT_DESTINATION_MESSAGE = ObfuscatorExportMessages.getString("FileExport.selectDestinationMessage");
    private static final String SELECT_DESTINATION_TITLE = ObfuscatorExportMessages.getString("FileExport.selectDestinationTitle");

    protected WizardObfuscatorResourceExportPage1(String name, IStructuredSelection selection) {
        super(name, selection);
    }

    public WizardObfuscatorResourceExportPage1(IStructuredSelection selection) {
        this("fileSystemExportPage1", selection);
        this.setTitle(ObfuscatorExportMessages.getString("ObfuscatorTransfer.fileSystemTitle"));
        this.setDescription(ObfuscatorExportMessages.getString("FileExport.exportLocalFileSystem"));
    }

    protected void addDestinationItem(String value) {
        this.destinationNameField.add(value);
    }

    public void createControl(Composite parent) {
        super.createControl(parent);
        this.giveFocusToDestination();
    }

    protected void createDestinationGroup(Composite parent) {
        Font font = parent.getFont();
        Composite destinationSelectionGroup = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        destinationSelectionGroup.setLayout((Layout)layout);
        destinationSelectionGroup.setLayoutData((Object)new GridData(272));
        destinationSelectionGroup.setFont(font);
        Label destinationLabel = new Label(destinationSelectionGroup, 0);
        destinationLabel.setText(this.getDestinationLabel());
        destinationLabel.setFont(font);
        this.destinationNameField = new Combo(destinationSelectionGroup, 2052);
        this.destinationNameField.addListener(24, (Listener)this);
        this.destinationNameField.addListener(13, (Listener)this);
        GridData data = new GridData(768);
        data.widthHint = 250;
        this.destinationNameField.setLayoutData((Object)data);
        this.destinationNameField.setFont(font);
        this.destinationBrowseButton = new Button(destinationSelectionGroup, 8);
        this.destinationBrowseButton.setText(ObfuscatorExportMessages.getString("ObfuscatorTransfer.browse"));
        this.destinationBrowseButton.addListener(13, (Listener)this);
        this.destinationBrowseButton.setFont(font);
        this.setButtonLayoutData(this.destinationBrowseButton);
        new Label(parent, 0);
    }

    protected void createOptionsGroupButtons(Group optionsGroup) {
        Font font = optionsGroup.getFont();
        this.createOverwriteExisting(optionsGroup, font);
    }

    protected void createOverwriteExisting(Group optionsGroup, Font font) {
        this.overwriteExistingFilesCheckbox = new Button((Composite)optionsGroup, 16416);
        this.overwriteExistingFilesCheckbox.setText(ObfuscatorExportMessages.getString("ExportFile.overwriteExisting"));
        this.overwriteExistingFilesCheckbox.setFont(font);
    }

    protected boolean ensureDirectoryExists(File directory) {
        if (!directory.exists()) {
            if (!this.queryYesNoQuestion(ObfuscatorExportMessages.getString("ObfuscatorTransfer.createTargetDirectory"))) {
                return false;
            }
            if (!directory.mkdirs()) {
                this.displayErrorDialog(ObfuscatorExportMessages.getString("ObfuscatorTransfer.directoryCreationError"));
                this.giveFocusToDestination();
                return false;
            }
        }
        return true;
    }

    protected boolean ensureTargetIsValid(File targetDirectory) {
        if (targetDirectory.exists() && !targetDirectory.isDirectory()) {
            this.displayErrorDialog(ObfuscatorExportMessages.getString("FileExport.directoryExists"));
            this.giveFocusToDestination();
            return false;
        }
        return this.ensureDirectoryExists(targetDirectory);
    }

    protected boolean executeExportOperation(ObfuscatorExportOperation op) {
        op.setOverwriteFiles(this.overwriteExistingFilesCheckbox.getSelection());
        try {
            this.getContainer().run(true, true, (IRunnableWithProgress)op);
        }
        catch (InterruptedException interruptedException) {
            return false;
        }
        catch (InvocationTargetException e) {
            this.displayErrorDialog(e.getTargetException());
            return false;
        }
        IStatus status = op.getStatus();
        if (!status.isOK()) {
            ErrorDialog.openError((Shell)this.getContainer().getShell(), (String)ObfuscatorExportMessages.getString("ObfuscatorTransfer.exportProblems"), null, (IStatus)status);
            return false;
        }
        return true;
    }

    public boolean finish() {
        if (!this.ensureTargetIsValid(new File(this.getDestinationValue()))) {
            return false;
        }
        List resourcesToExport = this.getWhiteCheckedResources();
        this.saveDirtyEditors();
        this.saveWidgetValues();
        if (resourcesToExport.size() > 0) {
            return this.executeExportOperation(new ObfuscatorExportOperation(null, resourcesToExport, this.getDestinationValue(), (IOverwriteQuery)this));
        }
        MessageDialog.openInformation((Shell)this.getContainer().getShell(), (String)ObfuscatorExportMessages.getString("ObfuscatorTransfer.information"), (String)ObfuscatorExportMessages.getString("FileExport.noneSelected"));
        return false;
    }

    protected String getDestinationLabel() {
        return ObfuscatorExportMessages.getString("FileExport.toDirectory");
    }

    protected String getDestinationValue() {
        return this.destinationNameField.getText().trim();
    }

    protected void giveFocusToDestination() {
        this.destinationNameField.setFocus();
    }

    protected void handleDestinationBrowseButtonPressed() {
        DirectoryDialog dialog = new DirectoryDialog(this.getContainer().getShell(), 8192);
        dialog.setMessage(SELECT_DESTINATION_MESSAGE);
        dialog.setText(SELECT_DESTINATION_TITLE);
        dialog.setFilterPath(this.getDestinationValue());
        String selectedDirectoryName = dialog.open();
        if (selectedDirectoryName != null) {
            this.setErrorMessage(null);
            this.setDestinationValue(selectedDirectoryName);
        }
    }

    public void handleEvent(Event e) {
        Widget source = e.widget;
        if (source == this.destinationBrowseButton) {
            this.handleDestinationBrowseButtonPressed();
        }
        this.updatePageCompletion();
    }

    protected void internalSaveWidgetValues() {
        IDialogSettings settings = this.getDialogSettings();
        if (settings != null) {
            String[] directoryNames = settings.getArray(STORE_DESTINATION_NAMES_ID);
            if (directoryNames == null) {
                directoryNames = new String[]{};
            }
            directoryNames = this.addToHistory(directoryNames, this.getDestinationValue());
            settings.put(STORE_DESTINATION_NAMES_ID, directoryNames);
            settings.put(STORE_OVERWRITE_EXISTING_FILES_ID, this.overwriteExistingFilesCheckbox.getSelection());
        }
    }

    protected void restoreWidgetValues() {
        IDialogSettings settings = this.getDialogSettings();
        if (settings != null) {
            String[] directoryNames = settings.getArray(STORE_DESTINATION_NAMES_ID);
            if (directoryNames == null) {
                return;
            }
            this.setDestinationValue(directoryNames[0]);
            int i = 0;
            while (i < directoryNames.length) {
                this.addDestinationItem(directoryNames[i]);
                ++i;
            }
            this.overwriteExistingFilesCheckbox.setSelection(settings.getBoolean(STORE_OVERWRITE_EXISTING_FILES_ID));
        }
    }

    protected void setDestinationValue(String value) {
        this.destinationNameField.setText(value);
    }

    protected boolean validateDestinationGroup() {
        String destinationValue = this.getDestinationValue();
        if (destinationValue.length() == 0) {
            this.setMessage(this.destinationEmptyMessage());
            return false;
        }
        String conflictingContainer = this.getConflictingContainerNameFor(destinationValue);
        if (conflictingContainer != null) {
            this.setErrorMessage(ObfuscatorExportMessages.format("FileExport.conflictingContainer", new Object[]{conflictingContainer}));
            this.giveFocusToDestination();
            return false;
        }
        this.setErrorMessage("");
        return true;
    }

    protected String destinationEmptyMessage() {
        return ObfuscatorExportMessages.getString("FileExport.destinationEmpty");
    }

    protected String getConflictingContainerNameFor(String targetDirectory) {
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        Path testPath = new Path(targetDirectory);
        if (root.getLocation().isPrefixOf((IPath)testPath)) {
            return ObfuscatorExportMessages.getString("FileExport.rootName");
        }
        IProject[] projects = root.getProjects();
        int i = 0;
        while (i < projects.length) {
            if (projects[i].getLocation().isPrefixOf((IPath)testPath)) {
                return projects[i].getName();
            }
            ++i;
        }
        return null;
    }
}

