/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.phpeclipse.phpeditor;

import net.sourceforge.phpdt.core.ICompilationUnit;
import net.sourceforge.phpdt.core.IJavaElement;
import net.sourceforge.phpdt.core.IJavaProject;
import net.sourceforge.phpdt.core.IMember;
import net.sourceforge.phpdt.core.IWorkingCopy;
import net.sourceforge.phpdt.core.JavaCore;
import net.sourceforge.phpdt.core.JavaModelException;
import net.sourceforge.phpdt.internal.corext.util.JavaModelUtil;
import net.sourceforge.phpdt.ui.JavaUI;
import net.sourceforge.phpeclipse.PHPeclipsePlugin;
import net.sourceforge.phpeclipse.phpeditor.PHPEditor;
import net.sourceforge.phpeclipse.phpeditor.PHPEditorMessages;
import net.sourceforge.phpeclipse.phpeditor.TogglePresentationAction;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.action.Action;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorRegistry;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.texteditor.ITextEditor;

public class EditorUtility {
    static /* synthetic */ Class class$0;

    public static boolean isEditorInput(Object element, IEditorPart editor) {
        if (editor != null) {
            try {
                return editor.getEditorInput().equals(EditorUtility.getEditorInput(element));
            }
            catch (JavaModelException x) {
                PHPeclipsePlugin.log(x.getStatus());
            }
        }
        return false;
    }

    public static IEditorPart isOpenInEditor(Object inputElement) {
        IWorkbenchPage p;
        IEditorInput input = null;
        try {
            input = EditorUtility.getEditorInput(inputElement);
        }
        catch (JavaModelException x) {
            PHPeclipsePlugin.log(x.getStatus());
        }
        if (input != null && (p = PHPeclipsePlugin.getActivePage()) != null) {
            return p.findEditor(input);
        }
        return null;
    }

    public static IEditorPart openInEditor(Object inputElement) throws JavaModelException, PartInitException {
        return EditorUtility.openInEditor(inputElement, true);
    }

    public static IEditorPart openInEditor(Object inputElement, boolean activate) throws JavaModelException, PartInitException {
        if (inputElement instanceof IFile) {
            return EditorUtility.openInEditor((IFile)inputElement, activate);
        }
        IEditorInput input = EditorUtility.getEditorInput(inputElement);
        if (input instanceof IFileEditorInput) {
            IFileEditorInput fileInput = (IFileEditorInput)input;
            return EditorUtility.openInEditor(fileInput.getFile(), activate);
        }
        if (input != null) {
            return EditorUtility.openInEditor(input, EditorUtility.getEditorID(input, inputElement), activate);
        }
        return null;
    }

    public static void revealInEditor(IEditorPart part, IJavaElement element) {
        if (element != null && part instanceof PHPEditor) {
            ((PHPEditor)part).setSelection(element);
        }
    }

    private static IEditorPart openInEditor(IFile file, boolean activate) throws PartInitException {
        IWorkbenchPage p;
        if (file != null && (p = PHPeclipsePlugin.getActivePage()) != null) {
            IEditorPart editorPart = IDE.openEditor((IWorkbenchPage)p, (IFile)file, (boolean)activate);
            EditorUtility.initializeHighlightRange(editorPart);
            return editorPart;
        }
        return null;
    }

    private static IEditorPart openInEditor(IEditorInput input, String editorID, boolean activate) throws PartInitException {
        IWorkbenchPage p;
        if (input != null && (p = PHPeclipsePlugin.getActivePage()) != null) {
            IEditorPart editorPart = p.openEditor(input, editorID, activate);
            EditorUtility.initializeHighlightRange(editorPart);
            return editorPart;
        }
        return null;
    }

    private static void initializeHighlightRange(IEditorPart editorPart) {
        if (editorPart instanceof ITextEditor) {
            TogglePresentationAction toggleAction = new TogglePresentationAction();
            toggleAction.setEditor((ITextEditor)editorPart);
            toggleAction.setEditor(null);
        }
    }

    public static String getEditorID(IEditorInput input, Object inputObject) {
        IEditorRegistry registry = PlatformUI.getWorkbench().getEditorRegistry();
        IEditorDescriptor descriptor = registry.getDefaultEditor(input.getName());
        if (descriptor != null) {
            return descriptor.getId();
        }
        return null;
    }

    private static IEditorInput getEditorInput(IJavaElement element) throws JavaModelException {
        while (element != null) {
            ICompilationUnit unit;
            IResource resource;
            if (element instanceof IWorkingCopy && ((IWorkingCopy)((Object)element)).isWorkingCopy()) {
                element = ((IWorkingCopy)((Object)element)).getOriginalElement();
            }
            if (element instanceof ICompilationUnit && (resource = (unit = (ICompilationUnit)element).getResource()) instanceof IFile) {
                return new FileEditorInput((IFile)resource);
            }
            element = element.getParent();
        }
        return null;
    }

    public static IEditorInput getEditorInput(Object input) throws JavaModelException {
        if (input instanceof IJavaElement) {
            return EditorUtility.getEditorInput((IJavaElement)input);
        }
        if (input instanceof IFile) {
            return new FileEditorInput((IFile)input);
        }
        return null;
    }

    public static IJavaElement getActiveEditorJavaInput() {
        IEditorInput editorInput;
        IEditorPart part;
        IWorkbenchPage page = PHPeclipsePlugin.getActivePage();
        if (page != null && (part = page.getActiveEditor()) != null && (editorInput = part.getEditorInput()) != null) {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("net.sourceforge.phpdt.core.IJavaElement");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            return (IJavaElement)editorInput.getAdapter((Class)clazz);
        }
        return null;
    }

    public static ICompilationUnit getWorkingCopy(ICompilationUnit cu) {
        if (cu == null) {
            return null;
        }
        if (cu.isWorkingCopy()) {
            return cu;
        }
        return (ICompilationUnit)cu.findSharedWorkingCopy(JavaUI.getBufferFactory());
    }

    public static IMember getWorkingCopy(IMember member) throws JavaModelException {
        ICompilationUnit workingCopy;
        ICompilationUnit cu = member.getCompilationUnit();
        if (cu != null && (workingCopy = EditorUtility.getWorkingCopy(cu)) != null) {
            return JavaModelUtil.findMemberInCompilationUnit(workingCopy, member);
        }
        return null;
    }

    private static ICompilationUnit getCompilationUnit(IJavaElement element) {
        if (element == null) {
            return null;
        }
        if (element instanceof IMember) {
            return ((IMember)element).getCompilationUnit();
        }
        int type = element.getElementType();
        if (5 == type) {
            return (ICompilationUnit)element;
        }
        if (6 == type) {
            return null;
        }
        return EditorUtility.getCompilationUnit(element.getParent());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static IJavaElement getWorkingCopy(IJavaElement element, boolean reconcile) throws JavaModelException {
        ICompilationUnit unit = EditorUtility.getCompilationUnit(element);
        if (unit == null) {
            return null;
        }
        if (unit.isWorkingCopy()) {
            return element;
        }
        ICompilationUnit workingCopy = EditorUtility.getWorkingCopy(unit);
        if (workingCopy != null) {
            if (reconcile) {
                ICompilationUnit iCompilationUnit = workingCopy;
                synchronized (iCompilationUnit) {
                    workingCopy.reconcile();
                    return JavaModelUtil.findInCompilationUnit(workingCopy, element);
                }
            }
            return JavaModelUtil.findInCompilationUnit(workingCopy, element);
        }
        return null;
    }

    public static int findLocalizedModifier(String token) {
        if (token == null) {
            return 0;
        }
        if (token.equalsIgnoreCase(Action.findModifierString((int)262144))) {
            return 262144;
        }
        if (token.equalsIgnoreCase(Action.findModifierString((int)131072))) {
            return 131072;
        }
        if (token.equalsIgnoreCase(Action.findModifierString((int)65536))) {
            return 65536;
        }
        if (token.equalsIgnoreCase(Action.findModifierString((int)0x400000))) {
            return 0x400000;
        }
        return 0;
    }

    public static String getModifierString(int stateMask) {
        String modifierString = "";
        if ((stateMask & 0x40000) == 262144) {
            modifierString = EditorUtility.appendModifierString(modifierString, 262144);
        }
        if ((stateMask & 0x10000) == 65536) {
            modifierString = EditorUtility.appendModifierString(modifierString, 65536);
        }
        if ((stateMask & 0x20000) == 131072) {
            modifierString = EditorUtility.appendModifierString(modifierString, 131072);
        }
        if ((stateMask & 0x400000) == 0x400000) {
            modifierString = EditorUtility.appendModifierString(modifierString, 0x400000);
        }
        return modifierString;
    }

    private static String appendModifierString(String modifierString, int modifier) {
        if (modifierString == null) {
            modifierString = "";
        }
        String newModifierString = Action.findModifierString((int)modifier);
        if (modifierString.length() == 0) {
            return newModifierString;
        }
        return PHPEditorMessages.getFormattedString("EditorUtility.concatModifierStrings", new String[]{modifierString, newModifierString});
    }

    public static IJavaProject getJavaProject(IEditorInput input) {
        IProject project;
        IJavaProject jProject = null;
        if (input instanceof IFileEditorInput && (project = ((IFileEditorInput)input).getFile().getProject()) != null && !(jProject = JavaCore.create(project)).exists()) {
            jProject = null;
        }
        return jProject;
    }
}

