/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.phpeclipse.phpeditor;

import net.sourceforge.phpdt.core.IJavaElement;
import net.sourceforge.phpdt.internal.ui.viewsupport.IProblemChangedListener;
import net.sourceforge.phpdt.internal.ui.viewsupport.JavaUILabelProvider;
import net.sourceforge.phpdt.ui.ProblemsLabelDecorator;
import net.sourceforge.phpeclipse.PHPeclipsePlugin;
import net.sourceforge.phpeclipse.phpeditor.PHPEditor;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.text.Assert;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;

public class JavaEditorErrorTickUpdater
implements IProblemChangedListener {
    private PHPEditor fJavaEditor;
    private JavaUILabelProvider fLabelProvider;
    static /* synthetic */ Class class$0;

    public JavaEditorErrorTickUpdater(PHPEditor editor) {
        Assert.isNotNull((Object)editor);
        this.fJavaEditor = editor;
        this.fLabelProvider = new JavaUILabelProvider(0, 2);
        this.fLabelProvider.addLabelDecorator(new ProblemsLabelDecorator(null));
        PHPeclipsePlugin.getDefault().getProblemMarkerManager().addListener(this);
    }

    public void problemsChanged(IResource[] changedResources, boolean isMarkerChange) {
        if (isMarkerChange) {
            return;
        }
        IEditorInput input = this.fJavaEditor.getEditorInput();
        if (input != null) {
            IJavaElement jelement;
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("net.sourceforge.phpdt.core.IJavaElement");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if ((jelement = (IJavaElement)input.getAdapter((Class)clazz)) != null) {
                IResource resource = jelement.getResource();
                int i = 0;
                while (i < changedResources.length) {
                    if (changedResources[i].equals((Object)resource)) {
                        this.updateEditorImage(jelement);
                    }
                    ++i;
                }
            }
        }
    }

    public void updateEditorImage(IJavaElement jelement) {
        Image titleImage = this.fJavaEditor.getTitleImage();
        if (titleImage == null) {
            return;
        }
        Image newImage = this.fLabelProvider.getImage(jelement);
        if (titleImage != newImage) {
            this.postImageChange(newImage);
        }
    }

    private void postImageChange(final Image newImage) {
        Shell shell = this.fJavaEditor.getEditorSite().getShell();
        if (shell != null && !shell.isDisposed()) {
            shell.getDisplay().syncExec(new Runnable(){

                public void run() {
                    JavaEditorErrorTickUpdater.this.fJavaEditor.updatedTitleImage(newImage);
                }
            });
        }
    }

    public void dispose() {
        this.fLabelProvider.dispose();
        PHPeclipsePlugin.getDefault().getProblemMarkerManager().removeListener(this);
    }
}

