/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.phpeclipse.phpeditor;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IMarker;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.IAnnotationHover;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.ui.texteditor.MarkerAnnotation;

public class PHPAnnotationHover
implements IAnnotationHover {
    static final int MAX_INFO_LENGTH = 80;

    public String getHoverInfo(ISourceViewer viewer, int line) {
        String info = null;
        List markers = this.getMarkersForLine(viewer, line);
        if (markers != null) {
            info = "";
            int i = 0;
            while (i < markers.size()) {
                IMarker marker = (IMarker)markers.get(i);
                String message = marker.getAttribute("message", null);
                if (message != null && message.trim().length() > 0) {
                    if (message.length() > 80) {
                        message = this.splitMessage(message);
                    }
                    info = String.valueOf(info) + message;
                    if (i != markers.size() - 1) {
                        info = String.valueOf(info) + "\n";
                    }
                }
                ++i;
            }
        }
        return info;
    }

    private String splitMessage(String message) {
        String result = "";
        if (message.length() <= 80) {
            return message;
        }
        String tmpStr = new String(message);
        while (tmpStr.length() > 80) {
            int spacepos = tmpStr.indexOf(" ", 80);
            if (spacepos != -1) {
                result = String.valueOf(result) + tmpStr.substring(0, spacepos) + "\n";
                tmpStr = tmpStr.substring(spacepos);
                continue;
            }
            result = String.valueOf(result) + tmpStr.substring(0, 80) + "\n";
            tmpStr = tmpStr.substring(80);
        }
        result = String.valueOf(result) + tmpStr;
        return result;
    }

    protected List getMarkersForLine(ISourceViewer aViewer, int aLine) {
        ArrayList<IMarker> markers = new ArrayList<IMarker>();
        IAnnotationModel model = aViewer.getAnnotationModel();
        if (model != null) {
            Iterator e = model.getAnnotationIterator();
            while (e.hasNext()) {
                MarkerAnnotation a;
                Object o = e.next();
                if (!(o instanceof MarkerAnnotation) || this.compareRulerLine(model.getPosition((Annotation)(a = (MarkerAnnotation)o)), aViewer.getDocument(), aLine) == 0) continue;
                markers.add(a.getMarker());
            }
        }
        return markers;
    }

    protected IMarker getMarkerForLine(ISourceViewer aViewer, int aLine) {
        IMarker marker = null;
        IAnnotationModel model = aViewer.getAnnotationModel();
        if (model != null) {
            Iterator e = model.getAnnotationIterator();
            while (e.hasNext()) {
                MarkerAnnotation a;
                Object o = e.next();
                if (!(o instanceof MarkerAnnotation) || this.compareRulerLine(model.getPosition((Annotation)(a = (MarkerAnnotation)o)), aViewer.getDocument(), aLine) == 0) continue;
                marker = a.getMarker();
            }
        }
        return marker;
    }

    protected int compareRulerLine(Position aPosition, IDocument aDocument, int aLine) {
        int distance = 0;
        if (aPosition.getOffset() > -1 && aPosition.getLength() > -1) {
            try {
                int markerLine = aDocument.getLineOfOffset(aPosition.getOffset());
                if (aLine == markerLine) {
                    distance = 1;
                } else if (markerLine <= aLine && aLine <= aDocument.getLineOfOffset(aPosition.getOffset() + aPosition.getLength())) {
                    distance = 2;
                }
            }
            catch (BadLocationException badLocationException) {}
        }
        return distance;
    }
}

