/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.phpeclipse.phpeditor.actions;

import org.eclipse.jface.action.IAction;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.TextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.ui.IEditorActionDelegate;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.texteditor.ITextEditor;

public class RTrimAction
implements IEditorActionDelegate {
    ITextEditor editor = null;

    public void setActiveEditor(IAction action, IEditorPart targetEditor) {
        if (targetEditor instanceof ITextEditor) {
            this.editor = (ITextEditor)targetEditor;
        }
    }

    public void run(IAction action) {
        int originalSelectionLength;
        int originalCursorOffset;
        IDocument doc = this.editor.getDocumentProvider().getDocument((Object)this.editor.getEditorInput());
        ITextSelection sel = (ITextSelection)this.editor.getSelectionProvider().getSelection();
        int currentLine = 0;
        int cursorOffset = originalCursorOffset = sel.getOffset();
        int selectionLength = originalSelectionLength = sel.getLength();
        try {
            while (currentLine < doc.getNumberOfLines()) {
                int offset = doc.getLineOffset(currentLine);
                int length = doc.getLineLength(currentLine);
                String oldText = doc.get(offset, length);
                int lineEnd = oldText.length();
                while (lineEnd > 0) {
                    if (oldText.charAt(lineEnd - 1) != '\t' && oldText.charAt(lineEnd - 1) != ' ') break;
                    --lineEnd;
                }
                if (lineEnd != oldText.length()) {
                    String newText = oldText.substring(0, lineEnd);
                    doc.replace(offset, length, newText);
                    if (offset + length <= cursorOffset) {
                        if (oldText.length() != newText.length()) {
                            cursorOffset -= oldText.length() - newText.length();
                        }
                    } else if (offset <= cursorOffset + selectionLength && selectionLength > 0) {
                        selectionLength -= oldText.length() - newText.length();
                    } else if (offset + length == cursorOffset + 2) {
                        cursorOffset -= 2;
                    }
                }
                ++currentLine;
            }
            TextSelection selection = new TextSelection(doc, cursorOffset, selectionLength);
            this.editor.getSelectionProvider().setSelection((ISelection)selection);
        }
        catch (Exception blx) {
            blx.printStackTrace();
        }
    }

    public void selectionChanged(IAction action, ISelection selection) {
    }
}

