/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.phpeclipse.phpeditor.php;

import java.util.ArrayList;
import java.util.List;
import net.sourceforge.phpdt.internal.ui.text.AbstractJavaScanner;
import net.sourceforge.phpdt.ui.text.IColorManager;
import net.sourceforge.phpeclipse.phpeditor.util.HTMLWordDetector;
import net.sourceforge.phpeclipse.phpeditor.util.PHPColorProvider;
import net.sourceforge.phpeclipse.phpeditor.util.PHPWhitespaceDetector;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.TextAttribute;
import org.eclipse.jface.text.rules.ICharacterScanner;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.IWhitespaceDetector;
import org.eclipse.jface.text.rules.IWordDetector;
import org.eclipse.jface.text.rules.SingleLineRule;
import org.eclipse.jface.text.rules.Token;
import org.eclipse.jface.text.rules.WhitespaceRule;
import org.eclipse.jface.text.rules.WordRule;

public class HTMLCodeScanner
extends AbstractJavaScanner {
    private static String[] fgTokenProperties = new String[]{"_php_multilineComment", "_php_singlelineComment", "_php_tag", "_php_keyword", "_php_functionname", "_php_variable", "_php_variable_dollar", "_php_string", "_php_string_sq", "_php_type", "_php_constant", "_php_default", "__php_operator", "__php_brace_operator", "__php_keyword_return"};
    private TextAttribute fComment;
    private TextAttribute fKeyword;
    private TextAttribute fType;
    private TextAttribute fString;
    private PHPColorProvider fColorProvider;

    protected String[] getTokenProperties() {
        return fgTokenProperties;
    }

    public HTMLCodeScanner(IColorManager manager, IPreferenceStore store) {
        super(manager, store);
        this.initialize();
    }

    protected List createRules() {
        ArrayList<Object> rules = new ArrayList<Object>();
        rules.add(new SingleLineRule("\"", "\"", (IToken)this.getToken("_php_string")));
        rules.add(new WhitespaceRule((IWhitespaceDetector)new PHPWhitespaceDetector()));
        HTMLWordRule wordRule = new HTMLWordRule(new HTMLWordDetector(), (IToken)this.getToken("_php_default"));
        rules.add((Object)wordRule);
        this.setDefaultReturnToken((IToken)this.getToken("_php_default"));
        return rules;
    }

    private class HTMLWordRule
    extends WordRule {
        private StringBuffer fBuffer = new StringBuffer();

        public HTMLWordRule(IWordDetector detector) {
            super(detector, Token.UNDEFINED);
        }

        public HTMLWordRule(IWordDetector detector, IToken defaultToken) {
            super(detector, defaultToken);
        }

        public IToken evaluate(ICharacterScanner scanner) {
            int c = scanner.read();
            boolean tagBegin = false;
            if (this.fDetector.isWordStart((char)c)) {
                if (c == 60) {
                    tagBegin = true;
                }
                if (this.fColumn == -1 || this.fColumn == scanner.getColumn() - 1) {
                    this.fBuffer.setLength(0);
                    do {
                        this.fBuffer.append((char)c);
                        c = scanner.read();
                        if (c != 62) continue;
                        this.fBuffer.append((char)c);
                        c = scanner.read();
                        break;
                    } while ((c != 47 || this.fBuffer.length() <= 2) && c != -1 && this.fDetector.isWordPart((char)c));
                    scanner.unread();
                    if (tagBegin) {
                        return HTMLCodeScanner.this.getToken("_php_keyword");
                    }
                    IToken token = (IToken)this.fWords.get(this.fBuffer.toString());
                    if (token != null) {
                        return token;
                    }
                    if (this.fDefaultToken.isUndefined()) {
                        this.unreadBuffer(scanner);
                    }
                    return this.fDefaultToken;
                }
            }
            scanner.unread();
            return Token.UNDEFINED;
        }
    }
}

