/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.phpeclipse.phpeditor.php;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.jface.text.Assert;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITypedRegion;
import org.eclipse.jface.text.rules.IPartitionTokenScanner;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.Token;

public class HTMLPartitionScanner
implements IPartitionTokenScanner {
    private static final boolean DEBUG = false;
    private boolean fInString = false;
    private boolean fInDoubString = false;
    private IDocument fDocument = null;
    private int fOffset = -1;
    private String fContentType = "__html";
    private String fPrevContentType = "__html";
    private boolean partitionBorder = false;
    private int fTokenOffset;
    private int fEnd = -1;
    private int fLength;
    private int fCurrentLength;
    private int fFileType;
    private Map tokens = new HashMap();

    public HTMLPartitionScanner() {
        this(1);
    }

    public HTMLPartitionScanner(int fileType) {
        this.tokens.put("__html", new Token((Object)"__html"));
        this.tokens.put("__html_multiline_comment", new Token((Object)"__html_multiline_comment"));
        this.tokens.put("__smarty", new Token((Object)"__smarty"));
        this.tokens.put("__smarty_multiline_comment", new Token((Object)"__smarty_multiline_comment"));
        this.tokens.put("__dftl_partition_content_type", new Token((Object)"__dftl_partition_content_type"));
        this.fFileType = fileType;
    }

    private IToken getToken(String type) {
        this.fLength = this.fCurrentLength;
        Assert.isTrue((this.fLength > 0 ? 1 : 0) != 0, (String)"Partition length <= 0!");
        this.fCurrentLength = 0;
        this.fInString = false;
        this.fInDoubString = false;
        IToken token = (IToken)this.tokens.get(type);
        Assert.isNotNull((Object)token, (String)("Token for type \"" + type + "\" not found!"));
        return token;
    }

    public void setPartialRange(IDocument document, int offset, int length, String contentType, int partitionOffset) {
        try {
            if (partitionOffset > -1) {
                this.partitionBorder = false;
                this.setRange(document, partitionOffset, offset - partitionOffset + length);
                this.fContentType = this.fDocument.getContentType(partitionOffset);
            } else {
                this.setRange(document, offset, length);
            }
        }
        catch (BadLocationException badLocationException) {
            this.setRange(document, 0, this.fDocument.getLength());
        }
    }

    public int getTokenLength() {
        return this.fLength;
    }

    public int getTokenOffset() {
        return this.fTokenOffset;
    }

    public IToken nextToken() {
        int c = this.read();
        if (c == -1) {
            this.partitionBorder = false;
            return Token.EOF;
        }
        this.unread();
        if (this.partitionBorder) {
            this.fTokenOffset = this.fOffset;
            this.partitionBorder = false;
        }
        block9: while ((c = this.read()) != -1) {
            switch (c) {
                case 60: {
                    if (!this.checkPattern(new char[]{'!', '-', '-'})) break;
                    if (this.fContentType != "__html_multiline_comment" && this.fCurrentLength > 4) {
                        this.unread(4);
                        IToken token = this.getToken(this.fContentType);
                        this.fContentType = "__html_multiline_comment";
                        return token;
                    }
                    this.fContentType = "__html_multiline_comment";
                    this.fTokenOffset = this.fOffset - 4;
                    this.fCurrentLength = 4;
                    break;
                }
                case 45: {
                    if (this.fContentType != "__html_multiline_comment" || !this.checkPattern(new char[]{'-', '>'})) continue block9;
                    this.fContentType = "__html";
                    this.partitionBorder = true;
                    return this.getToken("__html_multiline_comment");
                }
                case 123: {
                    if (this.fFileType != 4) break;
                    c = this.read();
                    if (c == 42) {
                        if (this.fContentType != "__smarty_multiline_comment" && this.fCurrentLength > 2) {
                            this.unread(2);
                            IToken token = this.getToken(this.fContentType);
                            this.fContentType = "__smarty_multiline_comment";
                            return token;
                        }
                        this.fContentType = "__smarty_multiline_comment";
                        this.fTokenOffset = this.fOffset - 2;
                        this.fCurrentLength = 2;
                        break;
                    }
                    if (c != -1) {
                        this.unread();
                    }
                    if (this.fContentType != "__smarty" && this.fCurrentLength > 1) {
                        this.unread(1);
                        IToken token = this.getToken(this.fContentType);
                        this.fContentType = "__smarty";
                        return token;
                    }
                    this.fContentType = "__smarty";
                    this.fTokenOffset = this.fOffset - 1;
                    this.fCurrentLength = 1;
                    break;
                }
                case 125: {
                    if (this.fFileType != 4 || this.fContentType != "__smarty") continue block9;
                    this.fContentType = "__html";
                    this.partitionBorder = true;
                    return this.getToken("__smarty");
                }
                case 42: {
                    if (this.fFileType != 4 || (c = this.read()) != 125 || this.fContentType != "__smarty_multiline_comment") continue block9;
                    this.fContentType = "__html";
                    this.partitionBorder = true;
                    return this.getToken("__smarty_multiline_comment");
                }
                case 39: {
                    if (this.fInDoubString) break;
                    this.fInString = !this.fInString;
                    break;
                }
                case 34: {
                    if (this.fInString) break;
                    boolean bl = this.fInDoubString = !this.fInDoubString;
                }
            }
        }
        return this.getToken(this.fContentType);
    }

    public void setRange(IDocument document, int offset, int length) {
        this.fDocument = document;
        this.fOffset = offset;
        this.fTokenOffset = offset;
        this.fCurrentLength = 0;
        this.fLength = 0;
        this.fEnd = this.fOffset + length;
        this.fInString = false;
        this.fInDoubString = false;
        this.fContentType = "__html";
    }

    private int read() {
        try {
            if (this.fOffset < this.fEnd) {
                ++this.fCurrentLength;
                return this.fDocument.getChar(this.fOffset++);
            }
            return -1;
        }
        catch (BadLocationException badLocationException) {
            this.fOffset = this.fEnd;
            return -1;
        }
    }

    private void unread() {
        --this.fOffset;
        --this.fCurrentLength;
    }

    private void unread(int num) {
        this.fOffset -= num;
        this.fCurrentLength -= num;
    }

    private boolean checkPattern(char[] pattern) {
        return this.checkPattern(pattern, false);
    }

    private boolean checkPattern(char[] pattern, boolean ignoreCase) {
        int prevOffset = this.fOffset;
        int prevLength = this.fCurrentLength;
        int i = 0;
        while (i < pattern.length) {
            int c = this.read();
            if (c == -1 || !this.letterEquals(c, pattern[i], ignoreCase)) {
                this.fOffset = prevOffset;
                this.fCurrentLength = prevLength;
                return false;
            }
            ++i;
        }
        return true;
    }

    private boolean letterEquals(int test, char letter, boolean ignoreCase) {
        if (test == letter) {
            return true;
        }
        if (ignoreCase && Character.isLowerCase(letter) && test == Character.toUpperCase(letter)) {
            return true;
        }
        return ignoreCase && Character.isUpperCase(letter) && test == Character.toLowerCase(letter);
    }

    private boolean isInString(String contentType) {
        if (this.fContentType == contentType) {
            return this.fInString || this.fInDoubString;
        }
        return false;
    }

    private String[] getPartitionStack(int offset) {
        ArrayList<String> types = new ArrayList<String>();
        int tmpOffset = 0;
        try {
            ITypedRegion region = this.fDocument.getPartition(offset);
            tmpOffset = region.getOffset();
            while (tmpOffset - 1 > 0) {
                region = this.fDocument.getPartition(tmpOffset - 1);
                tmpOffset = region.getOffset();
                types.add(0, region.getType());
            }
        }
        catch (BadLocationException badLocationException) {}
        String[] retVal = new String[types.size()];
        retVal = types.toArray(retVal);
        return retVal;
    }
}

