/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.phpeclipse.phpeditor.php;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.sourceforge.phpdt.internal.ui.text.AbstractJavaScanner;
import net.sourceforge.phpdt.ui.text.IColorManager;
import net.sourceforge.phpeclipse.phpeditor.PHPSyntaxRdr;
import net.sourceforge.phpeclipse.phpeditor.php.PHPConstant;
import net.sourceforge.phpeclipse.phpeditor.php.PHPElement;
import net.sourceforge.phpeclipse.phpeditor.php.PHPFunction;
import net.sourceforge.phpeclipse.phpeditor.php.PHPKeyword;
import net.sourceforge.phpeclipse.phpeditor.php.PHPType;
import net.sourceforge.phpeclipse.phpeditor.util.PHPWhitespaceDetector;
import net.sourceforge.phpeclipse.phpeditor.util.PHPWordDetector;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.Assert;
import org.eclipse.jface.text.rules.ICharacterScanner;
import org.eclipse.jface.text.rules.IRule;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.IWhitespaceDetector;
import org.eclipse.jface.text.rules.IWordDetector;
import org.eclipse.jface.text.rules.MultiLineRule;
import org.eclipse.jface.text.rules.Token;
import org.eclipse.jface.text.rules.WhitespaceRule;
import org.eclipse.jface.text.rules.WordRule;

public class PHPCodeScanner
extends AbstractJavaScanner {
    private static String[] fgTokenProperties = new String[]{"_php_multilineComment", "_php_singlelineComment", "_php_tag", "_php_keyword", "_php_functionname", "_php_variable", "_php_variable_dollar", "_php_string", "_php_string_sq", "_php_type", "_php_constant", "_php_default", "__php_operator", "__php_brace_operator", "__php_keyword_return"};

    public PHPCodeScanner(IColorManager manager, IPreferenceStore store) {
        super(manager, store);
        this.initialize();
    }

    protected String[] getTokenProperties() {
        return fgTokenProperties;
    }

    protected List createRules() {
        ArrayList<Object> rules = new ArrayList<Object>();
        Token token = this.getToken("_php_singlelineComment");
        rules.add(new AccentStringRule((IToken)token));
        token = this.getToken("_php_multilineComment");
        rules.add(new MultiLineRule("/*", "*/", (IToken)token));
        rules.add(new WhitespaceRule((IWhitespaceDetector)new PHPWhitespaceDetector()));
        token = this.getToken("_php_default");
        PHPWordRule wordRule = new PHPWordRule(new PHPWordDetector(), (IToken)token);
        Token keyword = this.getToken("_php_keyword");
        Token functionName = this.getToken("_php_functionname");
        Token type = this.getToken("_php_type");
        Token constant = this.getToken("_php_constant");
        ArrayList buffer = PHPSyntaxRdr.getSyntaxData();
        PHPElement elbuffer = null;
        int i = 0;
        while (i < buffer.size()) {
            elbuffer = (PHPElement)buffer.get(i);
            if (elbuffer instanceof PHPKeyword) {
                String name = ((PHPKeyword)elbuffer).getName();
                if (!name.equals("return")) {
                    wordRule.addWord(name, (IToken)keyword);
                }
            } else if (elbuffer instanceof PHPFunction) {
                wordRule.addWordIgnoreCase(((PHPFunction)elbuffer).getName(), (IToken)functionName);
            } else if (elbuffer instanceof PHPType) {
                wordRule.addWord(elbuffer.getName(), (IToken)type);
            } else if (elbuffer instanceof PHPConstant) {
                wordRule.addWord(elbuffer.getName(), (IToken)constant);
            }
            ++i;
        }
        token = this.getToken("__php_keyword_return");
        wordRule.addWord("return", (IToken)token);
        rules.add(new OperatorRule((IToken)this.getToken("__php_operator"), (IToken)this.getToken("__php_brace_operator"), (IToken)this.getToken("_php_string")));
        rules.add((Object)wordRule);
        this.setDefaultReturnToken((IToken)this.getToken("_php_default"));
        return rules;
    }

    protected class OperatorRule
    implements IRule {
        private final char[] PHP_OPERATORS = new char[]{';', '(', ')', '.', '=', '/', '\\', '+', '-', '*', '[', ']', '<', '>', ':', '?', '!', ',', '|', '&', '^', '%', '~', '@'};
        private final IToken fToken;
        private final IToken fTokenBraces;
        private final IToken fTokenHeredoc;

        public OperatorRule(IToken token, IToken tokenBraces, IToken tokenHeredoc) {
            this.fToken = token;
            this.fTokenBraces = tokenBraces;
            this.fTokenHeredoc = tokenHeredoc;
        }

        public boolean isOperator(char character) {
            int index = 0;
            while (index < this.PHP_OPERATORS.length) {
                if (this.PHP_OPERATORS[index] == character) {
                    return true;
                }
                ++index;
            }
            return false;
        }

        public IToken evaluate(ICharacterScanner scanner) {
            int character = scanner.read();
            if (character == 123 || character == 125) {
                return this.fTokenBraces;
            }
            if (this.isOperator((char)character)) {
                int lastCharacter = character;
                character = scanner.read();
                if (!this.isOperator((char)character)) {
                    scanner.unread();
                    return this.fToken;
                }
                if (this.checkPHPTag(scanner, lastCharacter, character)) {
                    return Token.UNDEFINED;
                }
                do {
                    if (this.checkPHPTag(scanner, lastCharacter = character, character = scanner.read())) {
                        return this.fToken;
                    }
                    if (character != -1) continue;
                    return this.fToken;
                } while (this.isOperator((char)character));
                scanner.unread();
                return this.fToken;
            }
            scanner.unread();
            return Token.UNDEFINED;
        }

        private boolean checkPHPTag(ICharacterScanner scanner, int lastCharacter, int character) {
            if (lastCharacter == 60 && character == 63) {
                scanner.unread();
                scanner.unread();
                return true;
            }
            if (lastCharacter == 63 && character == 62) {
                scanner.unread();
                scanner.unread();
                return true;
            }
            return false;
        }
    }

    protected class AccentStringRule
    implements IRule {
        private final IToken fToken;

        public AccentStringRule(IToken token) {
            this.fToken = token;
        }

        public IToken evaluate(ICharacterScanner scanner) {
            int character = scanner.read();
            if (character == 96) {
                while (character != -1) {
                    character = scanner.read();
                    if (character == 92) {
                        character = scanner.read();
                        continue;
                    }
                    if (character != 96) continue;
                    return this.fToken;
                }
                scanner.unread();
                return Token.UNDEFINED;
            }
            scanner.unread();
            return Token.UNDEFINED;
        }
    }

    private class PHPWordRule
    extends WordRule {
        private StringBuffer fBuffer = new StringBuffer();
        protected Map fWordsIgnoreCase = new HashMap();

        public PHPWordRule(IWordDetector detector) {
            super(detector, Token.UNDEFINED);
        }

        public PHPWordRule(IWordDetector detector, IToken defaultToken) {
            super(detector, defaultToken);
        }

        public void addWordIgnoreCase(String word, IToken token) {
            Assert.isNotNull((Object)word);
            Assert.isNotNull((Object)token);
            this.fWordsIgnoreCase.put(word, token);
        }

        public IToken evaluate(ICharacterScanner scanner) {
            int c = scanner.read();
            boolean isVariable = false;
            boolean isUnderscore = false;
            if (c == 60) {
                c = scanner.read();
                if (c != 63) {
                    scanner.unread();
                    scanner.unread();
                    return Token.UNDEFINED;
                }
                c = scanner.read();
                if (c == 61) {
                    return PHPCodeScanner.this.getToken("_php_tag");
                }
                if (c != 112 && c != 80) {
                    scanner.unread();
                    return PHPCodeScanner.this.getToken("_php_tag");
                }
                c = scanner.read();
                if (c != 104 && c != 72) {
                    scanner.unread();
                    scanner.unread();
                    return PHPCodeScanner.this.getToken("_php_tag");
                }
                c = scanner.read();
                if (c != 112 && c != 80) {
                    scanner.unread();
                    scanner.unread();
                    scanner.unread();
                    return PHPCodeScanner.this.getToken("_php_tag");
                }
                return PHPCodeScanner.this.getToken("_php_tag");
            }
            if (c == 63) {
                c = scanner.read();
                if (c == 62) {
                    return PHPCodeScanner.this.getToken("_php_tag");
                }
                scanner.unread();
                scanner.unread();
                return Token.UNDEFINED;
            }
            if (this.fDetector.isWordStart((char)c)) {
                if (c == 36) {
                    isVariable = true;
                }
                if (this.fColumn == -1 || this.fColumn == scanner.getColumn() - 1) {
                    this.fBuffer.setLength(0);
                    this.fBuffer.append((char)c);
                    c = scanner.read();
                    if (c == 95) {
                        isUnderscore = true;
                    }
                    while (c != -1 && this.fDetector.isWordPart((char)c)) {
                        this.fBuffer.append((char)c);
                        c = scanner.read();
                    }
                    scanner.unread();
                    if (isVariable) {
                        if (isUnderscore) {
                            return PHPCodeScanner.this.getToken("_php_variable_dollar");
                        }
                        return PHPCodeScanner.this.getToken("_php_variable");
                    }
                    String word = this.fBuffer.toString();
                    IToken token = (IToken)this.fWords.get(word);
                    if (token != null) {
                        return token;
                    }
                    token = (IToken)this.fWordsIgnoreCase.get(word.toLowerCase());
                    if (token != null) {
                        return token;
                    }
                    if (this.fDefaultToken.isUndefined()) {
                        this.unreadBuffer(scanner);
                    }
                    return this.fDefaultToken;
                }
            }
            scanner.unread();
            return Token.UNDEFINED;
        }
    }
}

