/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.phpeclipse.phpeditor.php;

import java.util.HashMap;
import java.util.Map;
import net.sourceforge.phpdt.internal.compiler.parser.Scanner;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.rules.IPartitionTokenScanner;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.Token;

public class PHPPartitionScanner
implements IPartitionTokenScanner {
    public static final String PHP_SCRIPTING_AREA = "__php_scripting_area ";
    public static final int STATE_DEFAULT = 0;
    private IDocument document;
    private int end;
    private int offset;
    private int length;
    private int position;
    private Map tokens = new HashMap();

    public IToken nextToken() {
        this.offset += this.length;
        switch (this.read()) {
            case -1: {
                return this.getToken(null);
            }
            case 60: {
                switch (this.read()) {
                    case -1: {
                        return this.getToken(null);
                    }
                    case 63: {
                        return this.scanUntilPHPEndToken(PHP_SCRIPTING_AREA);
                    }
                }
                this.unread();
            }
        }
        while (true) {
            block8 : switch (this.read()) {
                case -1: {
                    return this.getToken(null);
                }
                case 60: {
                    switch (this.read()) {
                        case -1: {
                            return this.getToken(null);
                        }
                        case 63: {
                            this.unread();
                            break;
                        }
                        case 60: {
                            this.unread();
                        }
                        default: {
                            break block8;
                        }
                    }
                    this.unread();
                    return this.getToken(null);
                }
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private IToken scanUntilPHPEndToken(String token) {
        int ch = this.read();
        block26: while (true) {
            block0 : switch (ch) {
                case -1: {
                    return this.getToken(token);
                }
                case 34: {
                    if (this.readUntilEscapedDQ()) break;
                    return this.getToken(token);
                }
                case 60: {
                    ch = this.read();
                    switch (ch) {
                        case -1: {
                            break;
                        }
                        case 60: {
                            ch = this.read();
                            switch (ch) {
                                case -1: {
                                    break;
                                }
                                case 60: {
                                    if (this.readUntilEscapedHEREDOC()) break;
                                    return this.getToken(token);
                                }
                            }
                            break;
                        }
                    }
                    break;
                }
                case 39: {
                    if (this.readUntilEscapedSQ()) break;
                    return this.getToken(token);
                }
                case 47: {
                    ch = this.read();
                    switch (ch) {
                        case -1: {
                            break block0;
                        }
                        case 47: {
                            if (this.readSingleLine()) break block0;
                            return this.getToken(token);
                        }
                        case 42: {
                            if (this.readMultiLineComment()) break block0;
                            return this.getToken(token);
                        }
                    }
                    continue block26;
                }
                case 35: {
                    if (this.readSingleLine()) break;
                    return this.getToken(token);
                }
                case 63: {
                    ch = this.read();
                    switch (ch) {
                        case -1: 
                        case 62: {
                            return this.getToken(token);
                        }
                        case 63: {
                            continue block26;
                        }
                    }
                    continue block26;
                }
            }
            ch = this.read();
        }
    }

    private IToken getToken(String type) {
        this.length = this.position - this.offset;
        if (this.length == 0) {
            return Token.EOF;
        }
        if (type == null) {
            return Token.UNDEFINED;
        }
        IToken token = (IToken)this.tokens.get(type);
        if (token == null) {
            token = new Token((Object)type);
            this.tokens.put(type, token);
        }
        return token;
    }

    private int read() {
        if (this.position >= this.end) {
            return -1;
        }
        try {
            return this.document.getChar(this.position++);
        }
        catch (BadLocationException badLocationException) {
            --this.position;
            return -1;
        }
    }

    private boolean readUntilEscapedDQ() {
        try {
            while (true) {
                char ch;
                if (this.position >= this.end) {
                    return false;
                }
                if ((ch = this.document.getChar(this.position++)) == '\\') {
                    if (this.position >= this.end) {
                        return false;
                    }
                    ch = this.document.getChar(this.position++);
                    continue;
                }
                if (ch == '\"') break;
            }
            return true;
        }
        catch (BadLocationException badLocationException) {
            --this.position;
            return false;
        }
    }

    private boolean readUntilEscapedSQ() {
        try {
            while (true) {
                char ch;
                if (this.position >= this.end) {
                    return false;
                }
                if ((ch = this.document.getChar(this.position++)) == '\\') {
                    if (this.position >= this.end) {
                        return false;
                    }
                    ch = this.document.getChar(this.position++);
                    continue;
                }
                if (ch == '\'') break;
            }
            return true;
        }
        catch (BadLocationException badLocationException) {
            --this.position;
            return false;
        }
    }

    /*
     * Unable to fully structure code
     */
    private boolean readUntilEscapedHEREDOC() {
        try {
            buf = new StringBuffer();
            if (this.position >= this.end) {
                return false;
            }
            if (Scanner.isPHPIdentifierStart(ch = this.document.getChar(this.position++))) ** GOTO lbl12
            return false;
lbl-1000:
            // 1 sources

            {
                buf.append(ch);
                if (this.position >= this.end) {
                    return false;
                }
                ch = this.document.getChar(this.position++);
lbl12:
                // 2 sources

                ** while (Scanner.isPHPIdentifierPart((char)ch))
            }
lbl13:
            // 1 sources

            heredocIdent = buf.toString().toCharArray();
            block3: while (true) {
                if (this.position >= this.end) {
                    return false;
                }
                if ((ch = this.document.getChar(this.position++)) != '\n') continue;
                pos = 0;
                while (true) {
                    if (this.position >= this.end) {
                        return false;
                    }
                    if (pos == heredocIdent.length) {
                        return true;
                    }
                    if ((ch = this.document.getChar(this.position++)) == heredocIdent[pos]) ** break;
                    continue block3;
                    ++pos;
                }
                break;
            }
        }
        catch (BadLocationException v0) {
            --this.position;
            return false;
        }
    }

    private boolean readSingleLine() {
        try {
            do {
                if (this.position < this.end) continue;
                return false;
            } while (this.document.getChar(this.position++) != '\n');
            return true;
        }
        catch (BadLocationException badLocationException) {
            --this.position;
            return false;
        }
    }

    private boolean readMultiLineComment() {
        try {
            while (true) {
                char ch;
                if (this.position >= this.end) {
                    return false;
                }
                if ((ch = this.document.getChar(this.position++)) != '*') continue;
                if (this.position >= this.end) {
                    return false;
                }
                if (this.document.getChar(this.position) == '/') break;
            }
            ++this.position;
            return true;
        }
        catch (BadLocationException badLocationException) {
            --this.position;
            return false;
        }
    }

    private void unread() {
        --this.position;
    }

    public int getTokenOffset() {
        return this.offset;
    }

    public int getTokenLength() {
        return this.length;
    }

    public void setRange(IDocument document, int offset, int length) {
        this.document = document;
        this.end = offset + length;
        this.offset = offset;
        this.position = offset;
        this.length = 0;
    }

    public void setPartialRange(IDocument document, int offset, int length, String contentType, int partitionOffset) {
        int delta;
        if (partitionOffset > -1 && (delta = offset - partitionOffset) > 0) {
            this.setRange(document, partitionOffset, length + delta);
            return;
        }
        this.setRange(document, partitionOffset, length);
    }
}

