/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.phpeclipse.wizards;

import java.lang.reflect.InvocationTargetException;
import net.sourceforge.phpdt.core.JavaCore;
import net.sourceforge.phpdt.ui.actions.OpenPHPPerspectiveAction;
import net.sourceforge.phpeclipse.PHPeclipsePlugin;
import net.sourceforge.phpeclipse.wizards.PHPWizardMessages;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExecutableExtension;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.actions.WorkspaceModifyDelegatingOperation;
import org.eclipse.ui.dialogs.WizardNewProjectCreationPage;
import org.eclipse.ui.wizards.newresource.BasicNewProjectResourceWizard;
import org.eclipse.ui.wizards.newresource.BasicNewResourceWizard;

public class NewProjectCreationWizard
extends BasicNewResourceWizard
implements INewWizard,
IExecutableExtension {
    protected WizardNewProjectCreationPage projectPage;
    protected IConfigurationElement configurationElement;
    protected IProject newProject;

    public NewProjectCreationWizard() {
        this.setWindowTitle(PHPWizardMessages.getString("NewProjectCreationWizard.windowTitle"));
    }

    public boolean performFinish() {
        WorkspaceModifyDelegatingOperation projectCreationOperation = new WorkspaceModifyDelegatingOperation(this.getProjectCreationRunnable());
        try {
            this.getContainer().run(false, true, (IRunnableWithProgress)projectCreationOperation);
        }
        catch (Exception e) {
            PHPeclipsePlugin.log(e);
            return false;
        }
        BasicNewProjectResourceWizard.updatePerspective((IConfigurationElement)this.configurationElement);
        this.selectAndReveal((IResource)this.newProject);
        new OpenPHPPerspectiveAction().run();
        return true;
    }

    protected IRunnableWithProgress getProjectCreationRunnable() {
        return new IRunnableWithProgress(){

            /*
             * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                int remainingWorkUnits = 10;
                monitor.beginTask(PHPWizardMessages.getString("NewProjectCreationWizard.projectCreationMessage"), remainingWorkUnits);
                IWorkspace workspace = PHPeclipsePlugin.getWorkspace();
                NewProjectCreationWizard.this.newProject = NewProjectCreationWizard.this.projectPage.getProjectHandle();
                IProjectDescription description = workspace.newProjectDescription(NewProjectCreationWizard.this.newProject.getName());
                IPath path = Platform.getLocation();
                IPath customPath = NewProjectCreationWizard.this.projectPage.getLocationPath();
                if (!path.equals((Object)customPath)) {
                    path = customPath;
                    description.setLocation(path);
                }
                try {
                    try {
                        if (!NewProjectCreationWizard.this.newProject.exists()) {
                            NewProjectCreationWizard.this.newProject.create(description, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                            --remainingWorkUnits;
                        }
                        if (!NewProjectCreationWizard.this.newProject.isOpen()) {
                            NewProjectCreationWizard.this.newProject.open((IProgressMonitor)new SubProgressMonitor(monitor, 1));
                            --remainingWorkUnits;
                        }
                        JavaCore.addPHPNature(NewProjectCreationWizard.this.newProject, (IProgressMonitor)new SubProgressMonitor(monitor, remainingWorkUnits));
                    }
                    catch (CoreException e) {
                        throw new InvocationTargetException(e);
                    }
                }
                catch (Throwable throwable) {
                    Object var8_9 = null;
                    monitor.done();
                    throw throwable;
                }
                {
                    Object var8_10 = null;
                }
                monitor.done();
            }
        };
    }

    public void addPages() {
        super.addPages();
        this.projectPage = new WizardNewProjectCreationPage(PHPWizardMessages.getString("WizardNewProjectCreationPage.pageName"));
        this.projectPage.setTitle(PHPWizardMessages.getString("WizardNewProjectCreationPage.pageTitle"));
        this.projectPage.setDescription(PHPWizardMessages.getString("WizardNewProjectCreationPage.pageDescription"));
        this.addPage((IWizardPage)this.projectPage);
    }

    public void setInitializationData(IConfigurationElement config, String propertyName, Object data) throws CoreException {
        this.configurationElement = config;
    }
}

