/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.phpeclipse.wizards.html;

import net.sourceforge.phpeclipse.wizards.html.EditElementWizard;
import net.sourceforge.phpeclipse.wizards.html.EditElementWizardPage;
import net.sourceforge.phpeclipse.wizards.html.UnknownElementWizardPage;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class NewElementWizardPage
extends EditElementWizardPage {
    Text elementName;
    EditElementWizardPage nextPage = null;

    public NewElementWizardPage() {
        super("NewElementPage");
        this.setTitle("Create HTML Element");
        this.setDescription("Specify new HTML tag (dl,ul,ol or table) and configure that tag.");
    }

    protected void createChildControl(Composite base) {
        base.setLayout((Layout)new GridLayout(1, false));
        new Label(base, 0).setText("&Element Name:");
        this.elementName = new Text(base, 2052);
        this.elementName.setLayoutData((Object)new GridData(768));
        this.elementName.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                String eName = NewElementWizardPage.this.elementName.getText();
                if (eName.indexOf(32) != -1) {
                    NewElementWizardPage.this.setErrorMessage("Don't contain blink in speicfied element name.");
                } else if (eName.length() == 0) {
                    NewElementWizardPage.this.setErrorMessage("Need to specify element name.");
                } else {
                    NewElementWizardPage.this.setErrorMessage(null);
                    NewElementWizardPage.this.nextPage = ((EditElementWizard)NewElementWizardPage.this.getWizard()).createElementEditPage(eName);
                    NewElementWizardPage.this.nextPage.setElementName(eName);
                    if (NewElementWizardPage.this.nextPage instanceof UnknownElementWizardPage) {
                        NewElementWizardPage.this.setMessage("This editor does not known element name.", 2);
                    } else {
                        NewElementWizardPage.this.setMessage(null, 0);
                    }
                }
                NewElementWizardPage.this.refreshPreview();
                NewElementWizardPage.this.getWizard().getContainer().updateButtons();
            }
        });
    }

    public String getPreviewText() {
        if (this.nextPage instanceof EditElementWizardPage) {
            return this.nextPage.getPreviewText();
        }
        return null;
    }

    public void setErrorMessage(String newMessage) {
        super.setErrorMessage(newMessage);
        if (newMessage != null) {
            this.nextPage = null;
        }
    }

    public IWizardPage getNextPage() {
        return this.nextPage;
    }
}

