/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.phpeclipse.ui;

import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.ColorDialog;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;

public class ColorEditor {
    private Point extent;
    Button button;
    Image image;
    RGB rgb;
    Color color;

    public ColorEditor(Composite parent) {
        this.button = new Button(parent, 8);
        this.extent = this.computeImageSize((Control)parent);
        this.image = new Image((Device)parent.getDisplay(), this.extent.x, this.extent.y);
        GC gc = new GC((Drawable)this.image);
        gc.setBackground(this.button.getBackground());
        gc.fillRectangle(0, 0, this.extent.x, this.extent.y);
        gc.dispose();
        this.button.setImage(this.image);
        this.button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                ColorDialog colorDialog = new ColorDialog(ColorEditor.this.button.getShell());
                colorDialog.setRGB(ColorEditor.this.rgb);
                RGB newColor = colorDialog.open();
                if (newColor != null) {
                    ColorEditor.this.rgb = newColor;
                    ColorEditor.this.updateColorImage();
                }
            }
        });
        this.button.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent event) {
                if (ColorEditor.this.image != null) {
                    ColorEditor.this.image.dispose();
                    ColorEditor.this.image = null;
                }
                if (ColorEditor.this.color != null) {
                    ColorEditor.this.color.dispose();
                    ColorEditor.this.color = null;
                }
            }
        });
    }

    public RGB getColorValue() {
        return this.rgb;
    }

    public void setColorValue(RGB rgb) {
        this.rgb = rgb;
        this.updateColorImage();
    }

    public Button getButton() {
        return this.button;
    }

    protected void updateColorImage() {
        Display display = this.button.getDisplay();
        GC gc = new GC((Drawable)this.image);
        gc.setForeground(display.getSystemColor(2));
        gc.drawRectangle(0, 2, this.extent.x - 1, this.extent.y - 4);
        if (this.color != null) {
            this.color.dispose();
        }
        this.color = new Color((Device)display, this.rgb);
        gc.setBackground(this.color);
        gc.fillRectangle(1, 3, this.extent.x - 2, this.extent.y - 5);
        gc.dispose();
        this.button.setImage(this.image);
    }

    protected Point computeImageSize(Control control) {
        Font f = JFaceResources.getFontRegistry().get("org.eclipse.jface.defaultfont");
        GC gc = new GC((Drawable)control);
        gc.setFont(f);
        int height = gc.getFontMetrics().getHeight();
        gc.dispose();
        return new Point(height * 3 - 6, height);
    }
}

