/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.phpeclipse.ui.editor;

import net.sourceforge.phpeclipse.ui.WebUI;
import net.sourceforge.phpeclipse.ui.editor.ShowExternalPreviewAction;
import net.sourceforge.phpeclipse.ui.overlaypages.ProjectPrefUtil;
import net.sourceforge.phpeclipse.webbrowser.views.ShowInContextBrowser;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IViewReference;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.internal.Perspective;
import org.eclipse.ui.internal.WorkbenchPage;
import org.eclipse.ui.part.IShowInTarget;
import org.eclipse.ui.part.ShowInContext;

public class BrowserUtil {
    static /* synthetic */ Class class$0;

    public static ShowInContextBrowser getShowInContext(IFile previewFile, boolean forceDBGPreview, String postFix) {
        String localhostURL;
        String extension = previewFile.getFileExtension().toLowerCase();
        if (!forceDBGPreview) {
            boolean bl = "html".equals(extension) || "htm".equals(extension) || "xhtml".equals(extension);
            boolean bl2 = "xml".equals(extension) || "xsd".equals(extension) || "dtd".equals(extension);
        }
        if ((localhostURL = ShowExternalPreviewAction.getLocalhostURL(null, previewFile)) == null) {
            return new ShowInContextBrowser((Object)previewFile, null, null);
        }
        localhostURL = String.valueOf(localhostURL) + postFix;
        return new ShowInContextBrowser((Object)previewFile, null, localhostURL);
    }

    private static IShowInTarget getShowInTarget(IWorkbenchPart targetPart) {
        Object o;
        if (targetPart instanceof IShowInTarget) {
            return (IShowInTarget)targetPart;
        }
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.ui.part.IShowInTarget");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((o = targetPart.getAdapter((Class)clazz)) instanceof IShowInTarget) {
            return (IShowInTarget)o;
        }
        return null;
    }

    public static void showPreview(IFile previewFile, boolean forceDBGPreview, String postFix) {
        if (previewFile == null) {
            return;
        }
        IWorkbenchPage page = WebUI.getActivePage();
        if (page != null && page.isEditorAreaVisible()) {
            boolean autoPreview = forceDBGPreview;
            if (!forceDBGPreview) {
                autoPreview = ProjectPrefUtil.getPreviewBooleanValue((IResource)previewFile, "_auto_preview");
            }
            if (autoPreview) {
                ShowInContextBrowser context = BrowserUtil.getShowInContext(previewFile, forceDBGPreview, postFix);
                IWorkbenchPart sourcePart = page.getActivePart();
                if (sourcePart == null && context != null) {
                    return;
                }
                Perspective persp = ((WorkbenchPage)page).getActivePerspective();
                if (persp != null) {
                    IViewReference ref = persp.findView("net.sourceforge.phpeclipse.webbrowser.views", null);
                    IViewPart view = null;
                    if (ref != null) {
                        view = ref.getView(true);
                    }
                    if (view != null) {
                        IShowInTarget target = BrowserUtil.getShowInTarget((IWorkbenchPart)view);
                        if (target != null) {
                            target.show((ShowInContext)context);
                        }
                        ((WorkbenchPage)page).performedShowIn("net.sourceforge.phpeclipse.webbrowser.views");
                    }
                }
            }
        }
    }
}

