/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.phpeclipse.ui.editor;

import net.sourceforge.phpeclipse.ui.WebUI;
import net.sourceforge.phpeclipse.ui.editor.BrowserUtil;
import net.sourceforge.phpeclipse.ui.editor.EditorMessages;
import net.sourceforge.phpeclipse.ui.overlaypages.ProjectPrefUtil;
import net.sourceforge.phpeclipse.webbrowser.views.BrowserView;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.ui.texteditor.TextEditorAction;

public class ShowExternalPreviewAction
extends TextEditorAction {
    public static final int XML_TYPE = 1;
    public static final int HTML_TYPE = 2;
    public static final int SMARTY_TYPE = 3;
    public static final int PHP_TYPE = 4;
    private static ShowExternalPreviewAction instance = new ShowExternalPreviewAction();

    private ShowExternalPreviewAction() {
        super(EditorMessages.getResourceBundle(), "ParserAction.", null);
        this.update();
    }

    public static ShowExternalPreviewAction getInstance() {
        return instance;
    }

    public void run() {
        this.doRun(4);
    }

    public void doRun(int type) {
        IFile previewFile = this.getFile();
        BrowserUtil.showPreview(previewFile, false, "");
    }

    public void refresh(int type) {
        IFile fileToParse = this.getFile();
        if (fileToParse == null) {
            return;
        }
        boolean autoPreview = ProjectPrefUtil.getPreviewBooleanValue((IResource)fileToParse, "_auto_preview");
        boolean bringToTopPreview = ProjectPrefUtil.getPreviewBooleanValue((IResource)fileToParse, "_bring_to_top_preview");
        if (autoPreview) {
            IWorkbenchPage page = WebUI.getActivePage();
            try {
                IViewPart part = page.findView("net.sourceforge.phpeclipse.webbrowser.views");
                if (part == null) {
                    part = page.showView("net.sourceforge.phpeclipse.webbrowser.views");
                } else if (bringToTopPreview) {
                    page.bringToTop((IWorkbenchPart)part);
                }
                if (part != null) {
                    ((BrowserView)part).refresh();
                }
            }
            catch (Exception exception) {}
        }
    }

    protected IFile getFile() {
        ITextEditor editor = this.getTextEditor();
        IEditorInput editorInput = null;
        if (editor != null) {
            editorInput = editor.getEditorInput();
        }
        if (editorInput instanceof IFileEditorInput) {
            return ((IFileEditorInput)editorInput).getFile();
        }
        return null;
    }

    public static String getLocalhostURL(IPreferenceStore store, IFile file) {
        if (file != null) {
            IPath documentRootPath;
            String documentRoot;
            String localhostURL;
            String lowerCaseFileName;
            if (store == null) {
                store = WebUI.getDefault().getPreferenceStore();
            }
            if (!(lowerCaseFileName = (localhostURL = file.getLocation().toString()).toLowerCase()).startsWith(documentRoot = (documentRootPath = ProjectPrefUtil.getDocumentRoot((IResource)file.getProject())).toString().toLowerCase())) {
                return null;
            }
            localhostURL = localhostURL.substring(documentRoot.length());
            return String.valueOf(ProjectPrefUtil.getMiscProjectsPreferenceValue((IResource)file.getProject(), "_php_localhost")) + localhostURL;
        }
        return "http://localhost";
    }
}

