/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.phpeclipse.ui.text.rules;

import net.sourceforge.phpeclipse.ui.text.rules.IDocumentView;
import net.sourceforge.phpeclipse.ui.text.rules.ViewNode;
import org.eclipse.jface.text.AbstractDocument;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.DefaultLineTracker;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ILineTracker;
import org.eclipse.jface.text.ITextStore;

public class InnerDocumentView
extends AbstractDocument
implements IDocumentView {
    IDocument parent;
    ViewNode range;

    public InnerDocumentView(IDocument parent, ViewNode range) {
        this.parent = parent;
        this.range = range;
        this.setTextStore(new TextStore());
        this.setLineTracker((ILineTracker)new DefaultLineTracker());
        this.getTracker().set(this.getStore().get(0, this.getLength()));
        this.completeInitialization();
    }

    public IDocument getParentDocument() {
        return this.parent;
    }

    protected void fireDocumentAboutToBeChanged(DocumentEvent event) {
        super.fireDocumentAboutToBeChanged(event);
    }

    protected void fireDocumentChanged(DocumentEvent event) {
        try {
            this.getTracker().replace(event.getOffset(), event.getLength(), event.getText());
        }
        catch (BadLocationException badLocationException) {}
        super.fireDocumentChanged(event);
    }

    public int getParentOffset(int localOffset) {
        return localOffset + this.range.offset;
    }

    public int getLocalOffset(int parentOffset) {
        return parentOffset - this.range.offset;
    }

    class TextStore
    implements ITextStore {
        TextStore() {
        }

        public void set(String txt) {
            try {
                InnerDocumentView.this.parent.replace(InnerDocumentView.this.range.offset, InnerDocumentView.this.range.length, txt);
            }
            catch (BadLocationException badLocationException) {}
        }

        public void replace(int offset, int length, String txt) {
            try {
                InnerDocumentView.this.parent.replace(InnerDocumentView.this.range.offset + offset, length, txt);
            }
            catch (BadLocationException badLocationException) {}
        }

        public int getLength() {
            return InnerDocumentView.this.range.length;
        }

        public String get(int offset, int length) {
            try {
                return InnerDocumentView.this.parent.get(InnerDocumentView.this.range.offset + offset, length);
            }
            catch (BadLocationException badLocationException) {
                return null;
            }
        }

        public char get(int offset) {
            try {
                return InnerDocumentView.this.parent.getChar(InnerDocumentView.this.range.offset + offset);
            }
            catch (BadLocationException badLocationException) {
                return '\u0000';
            }
        }
    }
}

