/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.phpeclipse.webbrowser;

import java.net.URL;
import java.util.List;
import net.sourceforge.phpeclipse.webbrowser.IExternalWebBrowserWorkingCopy;
import net.sourceforge.phpeclipse.webbrowser.IInternalWebBrowser;
import net.sourceforge.phpeclipse.webbrowser.IWebBrowser;
import net.sourceforge.phpeclipse.webbrowser.IWebBrowserEditorInput;
import net.sourceforge.phpeclipse.webbrowser.internal.BrowserManager;
import net.sourceforge.phpeclipse.webbrowser.internal.ExternalWebBrowserWorkingCopy;
import net.sourceforge.phpeclipse.webbrowser.internal.Trace;
import net.sourceforge.phpeclipse.webbrowser.internal.WebBrowserEditor;
import net.sourceforge.phpeclipse.webbrowser.internal.WebBrowserUIPlugin;
import net.sourceforge.phpeclipse.webbrowser.internal.WebBrowserUtil;
import org.eclipse.swt.widgets.Display;

public class WebBrowser {
    private WebBrowser() {
    }

    public static boolean isUsingInternalBrowser() {
        return WebBrowser.getCurrentWebBrowser() instanceof IInternalWebBrowser;
    }

    public static void openURL(final IWebBrowserEditorInput input) {
        Trace.trace(Trace.FINEST, "openURL() " + input);
        if (input == null) {
            return;
        }
        Display.getDefault().asyncExec(new Runnable(){

            public void run() {
                if (!WebBrowser.isUsingInternalBrowser()) {
                    IWebBrowser browser = WebBrowser.getCurrentWebBrowser();
                    browser.openURL(input.getURL());
                } else {
                    WebBrowserEditor.open(input);
                }
            }
        });
    }

    public static List getWebBrowsers() {
        return BrowserManager.getInstance().getWebBrowsers();
    }

    public static IWebBrowser getCurrentWebBrowser() {
        return BrowserManager.getInstance().getCurrentWebBrowser();
    }

    public static void getCurrentWebBrowser(IWebBrowser browser) {
        BrowserManager.getInstance().setCurrentWebBrowser(browser);
    }

    public static IExternalWebBrowserWorkingCopy createExternalWebBrowser() {
        return new ExternalWebBrowserWorkingCopy();
    }

    public static void openURL(URL url) {
        IWebBrowser browser = WebBrowser.getCurrentWebBrowser();
        if (browser != null) {
            browser.openURL(url);
        } else {
            Display.getDefault().asyncExec(new Runnable(){

                public void run() {
                    WebBrowserUtil.openError(WebBrowserUIPlugin.getResource("%errorNoBrowser"));
                }
            });
        }
    }
}

