/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.phpeclipse.webbrowser.internal;

import net.sourceforge.phpeclipse.webbrowser.IInternalWebBrowserWorkingCopy;
import net.sourceforge.phpeclipse.webbrowser.internal.SWTUtil;
import net.sourceforge.phpeclipse.webbrowser.internal.WebBrowserUIPlugin;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

public class InternalBrowserDialog
extends Dialog {
    protected IInternalWebBrowserWorkingCopy browser;
    protected boolean isEdit;
    protected Button newPageCheckbox;
    protected Button clearURLHistoryCheckbox;

    public InternalBrowserDialog(Shell parentShell, IInternalWebBrowserWorkingCopy browser) {
        super(parentShell);
        this.browser = browser;
        this.isEdit = true;
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        if (this.isEdit) {
            shell.setText(WebBrowserUIPlugin.getResource("%editInternalBrowser"));
        }
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        ((GridLayout)composite.getLayout()).numColumns = 1;
        Composite comp = new Composite(composite, 0);
        GridLayout layout = new GridLayout(1, true);
        layout.marginHeight = 10;
        layout.marginWidth = 10;
        comp.setLayout((Layout)layout);
        comp.setLayoutData((Object)new GridData(1808));
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)composite, "net.sourceforge.phpeclipse.webbrowser.wbpr0002");
        this.newPageCheckbox = SWTUtil.createCheckbox(comp, WebBrowserUIPlugin.getResource("%prefBrowserNewPage"), false);
        this.clearURLHistoryCheckbox = SWTUtil.createCheckbox(comp, WebBrowserUIPlugin.getResource("%clearURLHistory"), true);
        this.newPageCheckbox.setSelection(this.browser.getUseNewPage());
        this.clearURLHistoryCheckbox.setSelection(this.browser.getClearHistoryOnExit());
        return composite;
    }

    protected void okPressed() {
        this.browser.setUseNewPage(this.newPageCheckbox.getSelection());
        this.browser.setClearHistoryOnExit(this.clearURLHistoryCheckbox.getSelection());
        this.browser.save();
        super.okPressed();
    }
}

