/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.phpeclipse.webbrowser.internal;

import java.net.URL;
import java.util.Iterator;
import net.sourceforge.phpeclipse.webbrowser.WebBrowser;
import net.sourceforge.phpeclipse.webbrowser.WebBrowserEditorInput;
import net.sourceforge.phpeclipse.webbrowser.internal.Trace;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IActionDelegate;

public class OpenWithBrowserActionDelegate
implements IActionDelegate {
    private IResource resource;

    public void run(IAction action) {
        URL url = null;
        try {
            url = new URL("file://" + this.resource.getLocation());
            WebBrowser.openURL(new WebBrowserEditorInput(url, 14));
        }
        catch (Exception e) {
            Trace.trace(Trace.SEVERE, "Error opening browser on file", e);
        }
    }

    public void selectionChanged(IAction action, ISelection sel) {
        if (sel.isEmpty() || !(sel instanceof IStructuredSelection)) {
            action.setEnabled(false);
            return;
        }
        IStructuredSelection select = (IStructuredSelection)sel;
        Iterator iterator = select.iterator();
        Object selection = iterator.next();
        if (iterator.hasNext()) {
            action.setEnabled(false);
            return;
        }
        if (!(selection instanceof IResource)) {
            action.setEnabled(false);
            return;
        }
        this.resource = (IResource)selection;
        action.setEnabled(true);
    }
}

