/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.phpeclipse.webbrowser.internal;

import java.util.List;
import net.sourceforge.phpeclipse.webbrowser.internal.Favorite;
import net.sourceforge.phpeclipse.webbrowser.internal.ImageResource;
import net.sourceforge.phpeclipse.webbrowser.internal.SWTUtil;
import net.sourceforge.phpeclipse.webbrowser.internal.WebBrowserPreference;
import net.sourceforge.phpeclipse.webbrowser.internal.WebBrowserUIPlugin;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;

public class OrganizeFavoritesDialog
extends Dialog {
    protected List favorites = WebBrowserPreference.getInternalWebBrowserFavorites();

    public OrganizeFavoritesDialog(Shell parentShell) {
        super(parentShell);
        this.setBlockOnOpen(true);
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(WebBrowserUIPlugin.getResource("%dialogOrganizeFavoritesTitle"));
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginHeight = this.convertVerticalDLUsToPixels(7);
        layout.marginWidth = this.convertHorizontalDLUsToPixels(7);
        layout.verticalSpacing = this.convertVerticalDLUsToPixels(4);
        layout.horizontalSpacing = this.convertHorizontalDLUsToPixels(4);
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(1808));
        composite.setFont(parent.getFont());
        Label label = new Label(composite, 0);
        label.setText(WebBrowserUIPlugin.getResource("%dialogOrganizeFavoritesMessage"));
        GridData data = new GridData();
        data.horizontalSpan = 2;
        label.setLayoutData((Object)data);
        final Table table = new Table(composite, 68356);
        data = new GridData(1808);
        data.widthHint = 300;
        data.heightHint = 150;
        table.setLayoutData((Object)data);
        table.setLinesVisible(true);
        TableLayout tableLayout = new TableLayout();
        table.setLayout((Layout)tableLayout);
        table.setHeaderVisible(true);
        tableLayout.addColumnData((ColumnLayoutData)new ColumnWeightData(5, 50, true));
        TableColumn col = new TableColumn(table, 0);
        col.setText(WebBrowserUIPlugin.getResource("%dialogOrganizeFavoritesName"));
        tableLayout.addColumnData((ColumnLayoutData)new ColumnWeightData(6, 60, true));
        col = new TableColumn(table, 0);
        col.setText(WebBrowserUIPlugin.getResource("%dialogOrganizeFavoritesURL"));
        table.setLayout((Layout)tableLayout);
        final TableViewer tableViewer = new TableViewer(table);
        tableViewer.setContentProvider((IContentProvider)new FavoriteContentProvider());
        tableViewer.setLabelProvider((IBaseLabelProvider)new FavoriteLabelProvider());
        tableViewer.setInput((Object)"root");
        tableViewer.setColumnProperties(new String[]{"name", "url"});
        tableViewer.setCellEditors(new CellEditor[]{new TextCellEditor((Composite)table), new TextCellEditor((Composite)table)});
        ICellModifier cellModifier = new ICellModifier(){

            public Object getValue(Object element, String property) {
                Favorite f = (Favorite)element;
                if ("name".equals(property)) {
                    return f.getName();
                }
                return f.getURL();
            }

            public boolean canModify(Object element, String property) {
                return true;
            }

            public void modify(Object element, String property, Object value) {
                if (element instanceof Item) {
                    element = ((Item)element).getData();
                }
                try {
                    Favorite f = (Favorite)element;
                    String s = (String)value;
                    if ("name".equals(property)) {
                        f.setName(s);
                    } else {
                        f.setURL(s);
                    }
                    tableViewer.refresh((Object)f);
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        };
        tableViewer.setCellModifier(cellModifier);
        final Button remove = SWTUtil.createButton(composite, WebBrowserUIPlugin.getResource("%remove"));
        remove.setEnabled(false);
        tableViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                remove.setEnabled(!event.getSelection().isEmpty());
            }
        });
        remove.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                int index = table.getSelectionIndex();
                if (index < 0 || index >= OrganizeFavoritesDialog.this.favorites.size()) {
                    return;
                }
                tableViewer.remove(OrganizeFavoritesDialog.this.favorites.get(index));
                OrganizeFavoritesDialog.this.favorites.remove(index);
            }
        });
        Dialog.applyDialogFont((Control)composite);
        return composite;
    }

    protected void okPressed() {
        WebBrowserPreference.setInternalWebBrowserFavorites(this.favorites);
        super.okPressed();
    }

    public class FavoriteContentProvider
    implements IStructuredContentProvider {
        public void dispose() {
        }

        public Object[] getElements(Object inputElement) {
            return OrganizeFavoritesDialog.this.favorites.toArray();
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }

    public class FavoriteLabelProvider
    implements ITableLabelProvider {
        public void addListener(ILabelProviderListener listener) {
        }

        public void dispose() {
        }

        public Image getColumnImage(Object element, int columnIndex) {
            if (columnIndex == 0) {
                return ImageResource.getImage("favorite");
            }
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            Favorite favorite = (Favorite)element;
            if (columnIndex == 0) {
                return favorite.getName();
            }
            return favorite.getURL();
        }

        public boolean isLabelProperty(Object element, String property) {
            return false;
        }

        public void removeListener(ILabelProviderListener listener) {
        }
    }
}

