/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.phpeclipse.webbrowser.internal;

import java.util.Iterator;
import java.util.List;
import net.sourceforge.phpeclipse.webbrowser.IURLMap;
import net.sourceforge.phpeclipse.webbrowser.internal.BusyIndicator;
import net.sourceforge.phpeclipse.webbrowser.internal.Favorite;
import net.sourceforge.phpeclipse.webbrowser.internal.ImageResource;
import net.sourceforge.phpeclipse.webbrowser.internal.OrganizeFavoritesDialog;
import net.sourceforge.phpeclipse.webbrowser.internal.Trace;
import net.sourceforge.phpeclipse.webbrowser.internal.WebBrowserEditor;
import net.sourceforge.phpeclipse.webbrowser.internal.WebBrowserPreference;
import net.sourceforge.phpeclipse.webbrowser.internal.WebBrowserUIPlugin;
import net.sourceforge.phpeclipse.webbrowser.internal.WebBrowserUtil;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.browser.CloseWindowListener;
import org.eclipse.swt.browser.LocationEvent;
import org.eclipse.swt.browser.LocationListener;
import org.eclipse.swt.browser.OpenWindowListener;
import org.eclipse.swt.browser.ProgressEvent;
import org.eclipse.swt.browser.ProgressListener;
import org.eclipse.swt.browser.StatusTextEvent;
import org.eclipse.swt.browser.StatusTextListener;
import org.eclipse.swt.browser.TitleEvent;
import org.eclipse.swt.browser.TitleListener;
import org.eclipse.swt.browser.WindowEvent;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.ProgressBar;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.ui.PlatformUI;

public class WebBrowser
extends Composite {
    protected Composite toolbarComp;
    protected Composite statusComp;
    protected Combo combo;
    protected Clipboard clipboard;
    protected boolean showToolbar;
    protected ToolItem back;
    protected ToolItem forward;
    protected ToolItem stop;
    protected ToolItem favorites;
    protected ToolItem refresh;
    protected BusyIndicator busy;
    protected boolean showStatusbar;
    protected ProgressBar progress;
    protected Label status;
    private static int MAX_HISTORY = 50;
    protected static List history;
    protected Browser browser;
    protected Shell shell;
    protected WebBrowserEditor editor;
    protected String title;

    public WebBrowser(Composite parent, boolean showToolbar, boolean showStatusbar) {
        super(parent, 0);
        this.showToolbar = showToolbar;
        this.showStatusbar = showStatusbar;
        GridLayout layout = new GridLayout();
        layout.marginHeight = 3;
        layout.marginWidth = 3;
        layout.horizontalSpacing = 3;
        layout.verticalSpacing = 3;
        layout.numColumns = 1;
        this.setLayout((Layout)layout);
        this.setLayoutData(new GridData(1808));
        this.clipboard = new Clipboard(parent.getDisplay());
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this, "net.sourceforge.phpeclipse.webbrowser.sewb0000");
        if (showToolbar) {
            this.toolbarComp = new Composite((Composite)this, 0);
            GridLayout outerLayout = new GridLayout();
            outerLayout.numColumns = 2;
            outerLayout.marginWidth = 0;
            outerLayout.marginHeight = 0;
            this.toolbarComp.setLayout((Layout)outerLayout);
            this.toolbarComp.setLayoutData((Object)new GridData(770));
            Composite top = new Composite(this.toolbarComp, 0);
            GridLayout topLayout = new GridLayout();
            topLayout.numColumns = 2;
            topLayout.marginWidth = 0;
            topLayout.marginHeight = 0;
            top.setLayout((Layout)topLayout);
            top.setLayoutData((Object)new GridData(772));
            this.combo = new Combo(top, 4);
            this.updateHistory();
            this.combo.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent we) {
                    try {
                        if (WebBrowser.this.combo.getSelectionIndex() != -1) {
                            WebBrowser.this.setURL(WebBrowser.this.combo.getItem(WebBrowser.this.combo.getSelectionIndex()));
                        }
                    }
                    catch (Exception exception) {}
                }
            });
            this.combo.addListener(14, new Listener(){

                public void handleEvent(Event e) {
                    WebBrowser.this.setURL(WebBrowser.this.combo.getText());
                }
            });
            this.combo.setLayoutData((Object)new GridData(768));
            PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.combo, "net.sourceforge.phpeclipse.webbrowser.sewb0002");
            ToolBar toolbar = new ToolBar(top, 0x800000);
            this.fillToolBar(toolbar);
            new ToolItem(toolbar, 2);
            this.busy = new BusyIndicator(this.toolbarComp, 0);
            this.busy.setLayoutData(new GridData(128));
        }
        if (!WebBrowserUtil.isInternalBrowserOperational()) {
            WebBrowserUtil.openError(WebBrowserUIPlugin.getResource("%errorCouldNotLaunchInternalWebBrowser"));
            return;
        }
        this.browser = new Browser((Composite)this, 0);
        if (showToolbar) {
            this.back.setEnabled(this.browser.isBackEnabled());
            this.forward.setEnabled(this.browser.isForwardEnabled());
        }
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.browser, "net.sourceforge.phpeclipse.webbrowser.sewb0004");
        GridData data = new GridData();
        data.horizontalAlignment = 4;
        data.verticalAlignment = 4;
        data.horizontalSpan = 3;
        data.grabExcessHorizontalSpace = true;
        data.grabExcessVerticalSpace = true;
        this.browser.setLayoutData((Object)data);
        if (showStatusbar) {
            this.createStatusArea(this);
        }
        this.addBrowserListeners();
    }

    protected void addBrowserListeners() {
        if (this.showStatusbar) {
            this.browser.addStatusTextListener(new StatusTextListener(){

                public void changed(StatusTextEvent event) {
                    WebBrowser.this.status.setText(event.text);
                }
            });
        }
        this.browser.addOpenWindowListener(new OpenWindowListener(){

            public void open(WindowEvent event) {
                Shell shell2 = new Shell(WebBrowser.this.getDisplay());
                shell2.setLayout((Layout)new FillLayout());
                shell2.setText(WebBrowserUIPlugin.getResource("%viewWebBrowserTitle"));
                shell2.setImage(WebBrowser.this.getShell().getImage());
                WebBrowser browser2 = new WebBrowser((Composite)shell2, WebBrowser.this.showToolbar, WebBrowser.this.showStatusbar);
                browser2.shell = shell2;
                event.browser = browser2.browser;
                shell2.open();
            }
        });
        this.browser.addCloseWindowListener(new CloseWindowListener(){

            public void close(WindowEvent event) {
                if (WebBrowser.this.shell != null) {
                    WebBrowser.this.shell.dispose();
                } else {
                    WebBrowser.this.editor.closeEditor();
                }
            }
        });
        this.browser.addProgressListener(new ProgressListener(){

            public void changed(ProgressEvent event) {
                if (event.total == 0) {
                    return;
                }
                boolean done = event.current == event.total;
                int percentProgress = event.current * 100 / event.total;
                if (WebBrowser.this.showStatusbar) {
                    if (done) {
                        WebBrowser.this.progress.setSelection(0);
                    } else {
                        WebBrowser.this.progress.setSelection(percentProgress);
                    }
                }
                if (WebBrowser.this.showToolbar) {
                    if (!WebBrowser.this.busy.isBusy() && percentProgress > 0 && percentProgress < 100) {
                        WebBrowser.this.busy.setBusy(true);
                    } else if (WebBrowser.this.busy.isBusy() && done) {
                        WebBrowser.this.busy.setBusy(false);
                    }
                }
            }

            public void completed(ProgressEvent event) {
                if (WebBrowser.this.showStatusbar) {
                    WebBrowser.this.progress.setSelection(0);
                }
                if (WebBrowser.this.showToolbar) {
                    WebBrowser.this.busy.setBusy(false);
                    WebBrowser.this.back.setEnabled(WebBrowser.this.browser.isBackEnabled());
                    WebBrowser.this.forward.setEnabled(WebBrowser.this.browser.isForwardEnabled());
                }
            }
        });
        if (this.showToolbar) {
            this.browser.addLocationListener(new LocationListener(){

                public void changed(LocationEvent event) {
                    if (!event.top) {
                        return;
                    }
                    if (!WebBrowser.this.isHome()) {
                        WebBrowser.this.combo.setText(event.location);
                        WebBrowser.this.addToHistory(event.location);
                        WebBrowser.this.updateHistory();
                    } else {
                        WebBrowser.this.combo.setText("");
                    }
                }

                public void changing(LocationEvent event) {
                }
            });
        }
        this.browser.addTitleListener(new TitleListener(){

            public void changed(TitleEvent event) {
                WebBrowser.this.title = event.title;
            }
        });
    }

    public Browser getBrowser() {
        return this.browser;
    }

    protected void forward() {
        this.browser.forward();
    }

    protected void back() {
        this.browser.back();
    }

    protected void stop() {
        this.browser.stop();
    }

    protected void navigate(String url) {
        Trace.trace(Trace.FINER, "Navigate: " + url);
        if (url != null && url.equals(this.getURL())) {
            this.refresh();
            return;
        }
        this.browser.setUrl(url);
    }

    public void refresh() {
        this.browser.refresh();
    }

    protected void setURL(String url, boolean browse) {
        Trace.trace(Trace.FINEST, "setURL: " + url + " " + browse);
        if (url == null) {
            this.home();
            return;
        }
        if (url.endsWith(WebBrowserPreference.getHomePageURL().substring(9))) {
            return;
        }
        Iterator iterator = WebBrowserUtil.getURLMaps().iterator();
        String newURL = null;
        while (iterator.hasNext() && newURL == null) {
            try {
                IURLMap map = (IURLMap)iterator.next();
                newURL = map.getMappedURL(url);
            }
            catch (Exception exception) {}
        }
        if (newURL != null) {
            url = newURL;
        }
        if (browse) {
            this.navigate(url);
        }
        this.addToHistory(url);
        this.updateHistory();
    }

    protected void addToHistory(String url) {
        if (history == null) {
            history = WebBrowserPreference.getInternalWebBrowserHistory();
        }
        int found = -1;
        int size = history.size();
        int i = 0;
        while (i < size) {
            String s = (String)history.get(i);
            if (s.equals(url)) {
                found = i;
                break;
            }
            ++i;
        }
        if (found == -1) {
            if (size >= MAX_HISTORY) {
                history.remove(size - 1);
            }
            history.add(0, url);
            WebBrowserPreference.setInternalWebBrowserHistory(history);
        } else if (found != 0) {
            history.remove(found);
            history.add(0, url);
            WebBrowserPreference.setInternalWebBrowserHistory(history);
        }
    }

    public void setURL(String url) {
        this.setURL(url, true);
    }

    private void createStatusArea(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.horizontalSpacing = 4;
        layout.verticalSpacing = 0;
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(768));
        this.status = new Label(composite, 12);
        GridData gridData = new GridData(784);
        gridData.horizontalIndent = 2;
        this.status.setLayoutData((Object)gridData);
        this.progress = new ProgressBar(composite, 2048);
        gridData = new GridData(48);
        gridData.widthHint = 100;
        gridData.heightHint = 10;
        this.progress.setLayoutData((Object)gridData);
    }

    public void dispose() {
        super.dispose();
        this.showStatusbar = false;
        this.showToolbar = false;
        if (this.busy != null) {
            this.busy.dispose();
        }
        this.busy = null;
        this.browser = null;
    }

    private void fillToolBar(final ToolBar toolbar) {
        ToolItem go = new ToolItem(toolbar, 0);
        go.setImage(ImageResource.getImage("IMG_ELCL_NAV_GO"));
        go.setHotImage(ImageResource.getImage("IMG_CLCL_NAV_GO"));
        go.setDisabledImage(ImageResource.getImage("IMG_DLCL_NAV_GO"));
        go.setToolTipText(WebBrowserUIPlugin.getResource("%actionWebBrowserGo"));
        go.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                WebBrowser.this.setURL(WebBrowser.this.combo.getText());
            }
        });
        new ToolItem(toolbar, 2);
        this.favorites = new ToolItem(toolbar, 4);
        this.favorites.setImage(ImageResource.getImage("efavorites"));
        this.favorites.setHotImage(ImageResource.getImage("cfavorites"));
        this.favorites.setDisabledImage(ImageResource.getImage("dfavorites"));
        this.favorites.setToolTipText(WebBrowserUIPlugin.getResource("%actionWebBrowserFavorites"));
        this.favorites.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                if (event.detail == 4) {
                    Rectangle r = WebBrowser.this.favorites.getBounds();
                    WebBrowser.this.showFavorites((Control)toolbar, toolbar.toDisplay(r.x, r.y + r.height));
                } else {
                    WebBrowser.this.addFavorite();
                }
            }
        });
        this.back = new ToolItem(toolbar, 0);
        this.back.setImage(ImageResource.getImage("IMG_ELCL_NAV_BACKWARD"));
        this.back.setHotImage(ImageResource.getImage("IMG_CLCL_NAV_BACKWARD"));
        this.back.setDisabledImage(ImageResource.getImage("IMG_DLCL_NAV_BACKWARD"));
        this.back.setToolTipText(WebBrowserUIPlugin.getResource("%actionWebBrowserBack"));
        this.back.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                WebBrowser.this.back();
            }
        });
        this.forward = new ToolItem(toolbar, 0);
        this.forward.setImage(ImageResource.getImage("IMG_ELCL_NAV_FORWARD"));
        this.forward.setHotImage(ImageResource.getImage("IMG_CLCL_NAV_FORWARD"));
        this.forward.setDisabledImage(ImageResource.getImage("IMG_DLCL_NAV_FORWARD"));
        this.forward.setToolTipText(WebBrowserUIPlugin.getResource("%actionWebBrowserForward"));
        this.forward.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                WebBrowser.this.forward();
            }
        });
        this.stop = new ToolItem(toolbar, 0);
        this.stop.setImage(ImageResource.getImage("IMG_ELCL_NAV_STOP"));
        this.stop.setHotImage(ImageResource.getImage("IMG_CLCL_NAV_STOP"));
        this.stop.setDisabledImage(ImageResource.getImage("IMG_DLCL_NAV_STOP"));
        this.stop.setToolTipText(WebBrowserUIPlugin.getResource("%actionWebBrowserStop"));
        this.stop.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                WebBrowser.this.stop();
            }
        });
        this.refresh = new ToolItem(toolbar, 0);
        this.refresh.setImage(ImageResource.getImage("IMG_ELCL_NAV_REFRESH"));
        this.refresh.setHotImage(ImageResource.getImage("IMG_CLCL_NAV_REFRESH"));
        this.refresh.setDisabledImage(ImageResource.getImage("IMG_DLCL_NAV_REFRESH"));
        this.refresh.setToolTipText(WebBrowserUIPlugin.getResource("%actionWebBrowserRefresh"));
        this.refresh.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                WebBrowser.this.refresh();
            }
        });
    }

    protected void addFavorite() {
        Favorite f;
        List list = WebBrowserPreference.getInternalWebBrowserFavorites();
        if (!list.contains(f = new Favorite(this.title, this.browser.getUrl()))) {
            list.add(f);
            WebBrowserPreference.setInternalWebBrowserFavorites(list);
        }
    }

    protected void showFavorites(Control parent, Point p) {
        Menu perspectiveBarMenu = null;
        if (perspectiveBarMenu == null) {
            MenuItem item;
            MenuItem item2;
            Favorite f;
            Menu menu = new Menu(parent);
            Iterator iterator = WebBrowserUtil.getLockedFavorites().iterator();
            if (iterator.hasNext()) {
                while (iterator.hasNext()) {
                    f = (Favorite)iterator.next();
                    item2 = new MenuItem(menu, 0);
                    item2.setText(f.getName());
                    item2.setImage(ImageResource.getImage("favorite"));
                    item2.addSelectionListener((SelectionListener)new SelectionAdapter(){

                        public void widgetSelected(SelectionEvent event) {
                            WebBrowser.this.setURL(f.getURL());
                        }
                    });
                }
                new MenuItem(menu, 2);
            }
            if (!(iterator = WebBrowserPreference.getInternalWebBrowserFavorites().iterator()).hasNext()) {
                item = new MenuItem(menu, 0);
                item.setText(WebBrowserUIPlugin.getResource("%actionWebBrowserNoFavorites"));
            }
            while (iterator.hasNext()) {
                f = (Favorite)iterator.next();
                item2 = new MenuItem(menu, 0);
                item2.setText(f.getName());
                item2.setImage(ImageResource.getImage("favorite"));
                item2.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent event) {
                        WebBrowser.this.setURL(f.getURL());
                    }
                });
            }
            new MenuItem(menu, 2);
            item = new MenuItem(menu, 0);
            item.setText(WebBrowserUIPlugin.getResource("%actionWebBrowserOrganizeFavorites"));
            item.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent event) {
                    OrganizeFavoritesDialog dialog = new OrganizeFavoritesDialog(WebBrowser.this.shell);
                    dialog.open();
                }
            });
            perspectiveBarMenu = menu;
        }
        if (perspectiveBarMenu != null) {
            perspectiveBarMenu.setLocation(p.x, p.y);
            perspectiveBarMenu.setVisible(true);
        }
    }

    public void home() {
        this.navigate(WebBrowserPreference.getHomePageURL());
    }

    protected boolean isHome() {
        return this.getURL() != null && this.getURL().endsWith(WebBrowserPreference.getHomePageURL().substring(9));
    }

    protected String getURL() {
        return this.browser.getUrl();
    }

    protected void updateHistory() {
        if (this.combo == null) {
            return;
        }
        String temp = this.combo.getText();
        if (history == null) {
            history = WebBrowserPreference.getInternalWebBrowserHistory();
        }
        String[] historyList = new String[history.size()];
        history.toArray(historyList);
        this.combo.setItems(historyList);
        this.combo.setText(temp);
    }

    public void addProgressListener(ProgressListener listener) {
        this.browser.addProgressListener(listener);
    }

    public void addStatusTextListener(StatusTextListener listener) {
        this.browser.addStatusTextListener(listener);
    }

    public void addTitleListener(TitleListener listener) {
        this.browser.addTitleListener(listener);
    }
}

