/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.phpeclipse.webbrowser.internal;

import java.net.URL;
import net.sourceforge.phpeclipse.webbrowser.IWebBrowserEditorInput;
import net.sourceforge.phpeclipse.webbrowser.WebBrowserEditorInput;
import net.sourceforge.phpeclipse.webbrowser.internal.TextAction;
import net.sourceforge.phpeclipse.webbrowser.internal.Trace;
import net.sourceforge.phpeclipse.webbrowser.internal.WebBrowser;
import net.sourceforge.phpeclipse.webbrowser.internal.WebBrowserUIPlugin;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.part.EditorPart;

public class WebBrowserEditor
extends EditorPart {
    public static final String WEB_BROWSER_EDITOR_ID = "net.sourceforge.phpeclipse.webbrowser";
    protected WebBrowser webBrowser;
    protected String initialURL;
    protected Image image;
    protected TextAction cutAction;
    protected TextAction copyAction;
    protected TextAction pasteAction;
    protected IResourceChangeListener resourceListener;

    public void createPartControl(Composite parent) {
        IWebBrowserEditorInput input = this.getWebBrowserEditorInput();
        if (input == null || !input.isToolbarVisible()) {
            this.webBrowser = new WebBrowser(parent, false, input.isStatusbarVisible());
        } else {
            this.webBrowser = new WebBrowser(parent, true, input.isStatusbarVisible());
            this.cutAction = new TextAction(this.webBrowser, 0);
            this.copyAction = new TextAction(this.webBrowser, 1);
            this.pasteAction = new TextAction(this.webBrowser, 2);
        }
        this.webBrowser.setURL(this.initialURL);
        this.webBrowser.editor = this;
    }

    public void dispose() {
        if (this.image != null && !this.image.isDisposed()) {
            this.image.dispose();
        }
        this.image = null;
        if (this.resourceListener != null) {
            ResourcesPlugin.getWorkspace().removeResourceChangeListener(this.resourceListener);
        }
    }

    public void doSave(IProgressMonitor monitor) {
    }

    public void doSaveAs() {
    }

    public IAction getCopyAction() {
        return this.copyAction;
    }

    public IAction getCutAction() {
        return this.cutAction;
    }

    public IAction getPasteAction() {
        return this.pasteAction;
    }

    protected IWebBrowserEditorInput getWebBrowserEditorInput() {
        IEditorInput input = this.getEditorInput();
        if (input instanceof IWebBrowserEditorInput) {
            return (IWebBrowserEditorInput)input;
        }
        return null;
    }

    public void gotoMarker(IMarker marker) {
    }

    public void init(IEditorSite site, IEditorInput input) {
        Trace.trace(Trace.FINEST, "Opening browser: " + input);
        if (input instanceof IFileEditorInput) {
            IFileEditorInput fei = (IFileEditorInput)input;
            IFile file = fei.getFile();
            URL url = null;
            try {
                if (file != null && file.exists()) {
                    url = file.getLocation().toFile().toURL();
                }
            }
            catch (Exception exception) {
                Trace.trace(Trace.SEVERE, "Error getting URL to file");
            }
            this.addResourceListener((IResource)file);
            input = new WebBrowserEditorInput(url, 38);
        }
        if (input instanceof IWebBrowserEditorInput) {
            IWebBrowserEditorInput wbei = (IWebBrowserEditorInput)input;
            this.initialURL = null;
            if (wbei.getURL() != null) {
                this.initialURL = wbei.getURL().toExternalForm();
            }
            if (this.webBrowser != null) {
                this.webBrowser.setURL(this.initialURL);
                site.getWorkbenchWindow().getActivePage().bringToTop((IWorkbenchPart)this);
            }
            this.setPartName(wbei.getName());
            this.setTitleToolTip(wbei.getToolTipText());
            Image oldImage = this.image;
            ImageDescriptor id = wbei.getImageDescriptor();
            this.image = id.createImage();
            this.setTitleImage(this.image);
            if (oldImage != null && !oldImage.isDisposed()) {
                oldImage.dispose();
            }
        }
        this.setSite((IWorkbenchPartSite)site);
        this.setInput(input);
    }

    public boolean isDirty() {
        return false;
    }

    public boolean isSaveAsAllowed() {
        return false;
    }

    public boolean isToolbarVisible() {
        IWebBrowserEditorInput input = this.getWebBrowserEditorInput();
        return input == null || input.isToolbarVisible();
    }

    public static void open(IWebBrowserEditorInput input) {
        IWorkbenchWindow workbenchWindow = WebBrowserUIPlugin.getInstance().getWorkbench().getActiveWorkbenchWindow();
        IWorkbenchPage page = workbenchWindow.getActivePage();
        try {
            IEditorReference[] editors = page.getEditorReferences();
            int size = editors.length;
            int i = 0;
            while (i < size) {
                WebBrowserEditor webEditor;
                IEditorPart editor;
                if (WEB_BROWSER_EDITOR_ID.equals(editors[i].getId()) && (editor = editors[i].getEditor(true)) != null && editor instanceof WebBrowserEditor && input.canReplaceInput((webEditor = (WebBrowserEditor)editor).getWebBrowserEditorInput())) {
                    editor.init(editor.getEditorSite(), (IEditorInput)input);
                    return;
                }
                ++i;
            }
            page.openEditor((IEditorInput)input, WEB_BROWSER_EDITOR_ID);
        }
        catch (Exception e) {
            Trace.trace(Trace.SEVERE, "Error opening Web browser", e);
        }
    }

    public void setFocus() {
        if (this.webBrowser != null) {
            if (this.webBrowser.combo != null) {
                this.webBrowser.combo.setFocus();
            } else {
                this.webBrowser.browser.setFocus();
            }
            this.webBrowser.updateHistory();
        }
    }

    protected void updateActions() {
        if (this.cutAction != null) {
            this.cutAction.update();
        }
        if (this.copyAction != null) {
            this.copyAction.update();
        }
        if (this.pasteAction != null) {
            this.pasteAction.update();
        }
    }

    protected void closeEditor() {
        Display.getDefault().asyncExec(new Runnable(){

            public void run() {
                WebBrowserEditor.this.getEditorSite().getPage().closeEditor((IEditorPart)WebBrowserEditor.this, false);
            }
        });
    }

    protected void addResourceListener(final IResource resource) {
        if (resource == null) {
            return;
        }
        this.resourceListener = new IResourceChangeListener(){

            public void resourceChanged(IResourceChangeEvent event) {
                try {
                    event.getDelta().accept(new IResourceDeltaVisitor(){

                        public boolean visit(IResourceDelta delta) {
                            IResource res = delta.getResource();
                            if (res == null || !res.equals((Object)resource)) {
                                return true;
                            }
                            if (delta.getKind() != 2) {
                                return true;
                            }
                            Display.getDefault().asyncExec(new Runnable(this, resource){
                                final /* synthetic */ 1 this$2;
                                private final /* synthetic */ IResource val$resource;
                                {
                                    this.this$2 = var1_1;
                                    this.val$resource = iResource;
                                }

                                public void run() {
                                    String title = WebBrowserUIPlugin.getResource("%dialogResourceDeletedTitle");
                                    String message = WebBrowserUIPlugin.getResource("%dialogResourceDeletedMessage", this.val$resource.getName());
                                    String[] labels = new String[]{WebBrowserUIPlugin.getResource("%dialogResourceDeletedIgnore"), IDialogConstants.CLOSE_LABEL};
                                    MessageDialog dialog = new MessageDialog(2.access$0(1.access$0(this.this$2)).getEditorSite().getShell(), title, null, message, 2, labels, 0);
                                    if (dialog.open() != 0) {
                                        2.access$0(1.access$0(this.this$2)).closeEditor();
                                    }
                                }
                            });
                            return false;
                        }

                        static /* synthetic */ 2 access$0(1 var0) {
                            return var0.this;
                        }
                    });
                }
                catch (Exception e) {
                    Trace.trace(Trace.SEVERE, "Error listening for resource deletion", e);
                }
            }

            static /* synthetic */ WebBrowserEditor access$0(2 var0) {
                return var0.WebBrowserEditor.this;
            }
        };
        ResourcesPlugin.getWorkspace().addResourceChangeListener(this.resourceListener);
    }
}

