/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.phpeclipse.webbrowser.views;

import net.sourceforge.phpeclipse.webbrowser.internal.WebBrowser;
import net.sourceforge.phpeclipse.webbrowser.internal.WebBrowserUtil;
import net.sourceforge.phpeclipse.webbrowser.views.ShowInContextBrowser;
import org.eclipse.core.resources.IFile;
import org.eclipse.swt.browser.ProgressListener;
import org.eclipse.swt.browser.StatusTextListener;
import org.eclipse.swt.browser.TitleListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.part.IShowInTarget;
import org.eclipse.ui.part.ShowInContext;
import org.eclipse.ui.part.ViewPart;

public class BrowserView
extends ViewPart
implements IShowInTarget {
    public static final String ID_BROWSER = "net.sourceforge.phpeclipse.webbrowser.views";
    WebBrowser fInstance = null;
    String fUrl = null;

    public void createPartControl(Composite frame) {
        try {
            if (WebBrowserUtil.isInternalBrowserOperational()) {
                this.fInstance = new WebBrowser(frame, true, true);
            }
        }
        catch (Exception exception) {
            this.fInstance = null;
        }
    }

    public void setFocus() {
        if (this.fInstance != null) {
            this.fInstance.setFocus();
        }
    }

    public void dispose() {
        if (this.fInstance != null) {
            this.fInstance.dispose();
            this.fInstance = null;
        }
        super.dispose();
    }

    public void setUrl(String url) {
        if (this.fInstance != null) {
            this.fUrl = url;
            this.fInstance.setURL(url);
        }
    }

    public void refresh() {
        if (this.fInstance != null) {
            this.fInstance.refresh();
        }
    }

    public void refresh(String url) {
        if (this.fInstance != null) {
            if (this.fUrl == null || !this.fUrl.equals(url)) {
                this.setUrl(url);
            } else {
                this.refresh();
            }
        }
    }

    public void addProgressListener(ProgressListener listener) {
        if (this.fInstance != null) {
            this.fInstance.addProgressListener(listener);
        }
    }

    public void addStatusTextListener(StatusTextListener listener) {
        if (this.fInstance != null) {
            this.fInstance.addStatusTextListener(listener);
        }
    }

    public void addTitleListener(TitleListener listener) {
        if (this.fInstance != null) {
            this.fInstance.addTitleListener(listener);
        }
    }

    public boolean show(ShowInContext context) {
        ShowInContextBrowser contextBrowser;
        String localhostURL;
        if (context instanceof ShowInContextBrowser && (localhostURL = (contextBrowser = (ShowInContextBrowser)context).getLocalhostUrl()) != null) {
            this.setUrl(localhostURL);
            return true;
        }
        if (context.getInput() instanceof IFile) {
            IFile file = (IFile)context.getInput();
            localhostURL = "file:///" + file.getLocation().toString();
            this.setUrl(localhostURL);
            return true;
        }
        return false;
    }
}

