/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.phpdt.debug.core;

import java.util.HashMap;
import java.util.Map;
import net.sourceforge.phpdt.internal.debug.core.PHPDebugCorePlugin;
import net.sourceforge.phpdt.internal.debug.core.breakpoints.PHPLineBreakpoint;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IBreakpointManager;
import org.eclipse.debug.core.model.IBreakpoint;

public class PHPDebugModel {
    private PHPDebugModel() {
    }

    public static void createLineBreakpoint(IResource resource, int lineNumber, int charStart, int charEnd, int hitCount, boolean register, Map attributes) throws CoreException {
        if (attributes == null) {
            attributes = new HashMap(10);
        }
        new PHPLineBreakpoint(resource, lineNumber, charStart, charEnd, hitCount, true, attributes);
    }

    public static PHPLineBreakpoint createLineBreakpoint(IResource resource, int lineNumber, int hitCount, boolean register, Map attributes) throws CoreException {
        if (attributes == null) {
            attributes = new HashMap(10);
        }
        return new PHPLineBreakpoint(resource, lineNumber, hitCount, true, attributes);
    }

    public static PHPLineBreakpoint lineBreakpointExists(int lineNumber) throws CoreException {
        String modelId = "net.sourceforge.phpeclipse.debug.core";
        String markerType = PHPLineBreakpoint.getMarkerType();
        IBreakpointManager manager = DebugPlugin.getDefault().getBreakpointManager();
        IBreakpoint[] breakpoints = manager.getBreakpoints(modelId);
        int i = 0;
        while (i < breakpoints.length) {
            PHPLineBreakpoint breakpoint;
            if (breakpoints[i] instanceof PHPLineBreakpoint && (breakpoint = (PHPLineBreakpoint)breakpoints[i]).getMarker().getType().equals(markerType) && breakpoint.getLineNumber() == lineNumber) {
                return breakpoint;
            }
            ++i;
        }
        return null;
    }

    public static Preferences getPreferences() {
        PHPDebugCorePlugin deflt = PHPDebugCorePlugin.getDefault();
        if (deflt != null) {
            return deflt.getPluginPreferences();
        }
        return null;
    }

    public static void savePreferences() {
        PHPDebugCorePlugin.getDefault().savePluginPreferences();
    }
}

