/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.phpdt.internal.debug.core;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Vector;
import net.sourceforge.phpdt.internal.debug.core.PHPDBGBase;
import net.sourceforge.phpdt.internal.debug.core.PHPDBGFrame;

public class PHPDBGPacket {
    private static final int PACKET_HEADER_SIZE = 16;
    private char[] packetHeader = new char[16];
    private int packetSize;
    private Vector frames = new Vector();

    public PHPDBGPacket(char[] packetType) {
        PHPDBGBase.copyChars(this.packetHeader, PHPDBGBase.DBGSYNC, 4);
        PHPDBGBase.copyCharsTo(this.packetHeader, packetType, 4, 4);
    }

    public void addFrame(PHPDBGFrame frame) {
        this.frames.add(frame);
        this.packetSize += frame.getSize();
    }

    public void sendPacket(OutputStream out) throws IOException {
        PHPDBGBase.copyCharsTo(this.packetHeader, PHPDBGBase.IntToChar4(this.packetSize), 4, 12);
        try {
            out.write(PHPDBGBase.CharArrayToByteArray(this.packetHeader));
            out.flush();
            int i = 0;
            while (i < this.frames.size()) {
                PHPDBGFrame frame = (PHPDBGFrame)this.frames.get(i);
                out.write(PHPDBGBase.CharArrayToByteArray(frame.getHeader()));
                out.flush();
                if (frame.getSizeOfData() > 0) {
                    out.write(PHPDBGBase.CharArrayToByteArray(frame.getFrameData()));
                    out.flush();
                }
                ++i;
            }
        }
        catch (Exception exception) {}
    }
}

