/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.phpdt.internal.debug.core.model;

import java.util.Vector;
import net.sourceforge.phpdt.internal.debug.core.PHPDebugCorePlugin;
import net.sourceforge.phpdt.internal.debug.core.model.PHPStackFrame;
import net.sourceforge.phpdt.internal.debug.core.model.PHPValue;
import net.sourceforge.phpdt.internal.debug.core.model.PHPVariable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugException;

public class PHPDBGEvalString {
    String workStr;
    private PHPStackFrame fStackFrame;

    public PHPDBGEvalString(PHPStackFrame stack, String dataStr) {
        this.fStackFrame = stack;
        this.workStr = dataStr;
    }

    String ExtractSubStr(char chstart, char chend, int startIdx) throws DebugException {
        int idx = startIdx;
        if (idx >= this.workStr.length() - 1 || this.workStr.charAt(idx) != chstart) {
            Status status = new Status(4, PHPDebugCorePlugin.getUniqueIdentifier(), 0, "worng startIdx!", null);
            throw new DebugException((IStatus)status);
        }
        int i = ++idx;
        if ((i = this.workStr.indexOf(chend, i)) == -1) {
            Status status = new Status(4, PHPDebugCorePlugin.getUniqueIdentifier(), 0, "endchar not found!", null);
            throw new DebugException((IStatus)status);
        }
        String rslt = this.workStr.substring(idx, i);
        this.workStr = this.workStr.substring(i + 1);
        return rslt;
    }

    String ExtractQuotedSubStr(int slen, int startIdx) throws DebugException {
        int idx = startIdx;
        if (idx + slen + 1 >= this.workStr.length() || this.workStr.charAt(idx) != '\"' || this.workStr.charAt(idx + slen + 1) != '\"') {
            Status status = new Status(4, PHPDebugCorePlugin.getUniqueIdentifier(), 0, "no quoted substring found!", null);
            throw new DebugException((IStatus)status);
        }
        String rslt = this.workStr.substring(idx + 1, idx + 1 + slen);
        this.workStr = this.workStr.substring(idx + 2 + slen);
        return rslt;
    }

    int ExtractInt(char chstart, char chend, int startIdx) throws DebugException {
        String subs = this.ExtractSubStr(chstart, chend, startIdx);
        return Integer.parseInt(subs);
    }

    /*
     * Unable to fully structure code
     */
    PHPVariable ParseEvalArray(String name, PHPVariable parent, Vector list, Vector var_list, String classname, int atype) throws DebugException {
        block4: {
            subitems = null;
            arritems = this.ExtractInt(':', ':', 0);
            if (this.workStr.length() > 0 && this.workStr.charAt(0) != '{') {
                status = new Status(4, PHPDebugCorePlugin.getUniqueIdentifier(), 0, "no array startcharacter!", null);
                throw new DebugException((IStatus)status);
            }
            this.workStr = this.workStr.substring(1);
            item = new PHPVariable(this.fStackFrame, name, parent, classname, atype, null);
            list.add(item);
            if (var_list != null) {
                var_list.add(item);
            }
            if (arritems <= 0L) break block4;
            subitems = new Vector<E>();
            ** GOTO lbl28
        }
        if (this.workStr.charAt(0) == '}') ** GOTO lbl28
        status = new Status(4, PHPDebugCorePlugin.getUniqueIdentifier(), 0, "no array endcharacter!", null);
        throw new DebugException((IStatus)status);
lbl-1000:
        // 1 sources

        {
            tmplst = new Vector<E>();
            this.parse("", null, tmplst, null, false, 0);
            if (tmplst.size() != 1) {
                status = new Status(4, PHPDebugCorePlugin.getUniqueIdentifier(), 0, "no name found!", null);
                throw new DebugException((IStatus)status);
            }
            this.parse(((PHPVariable)tmplst.elementAt(0)).getValue().getValueString(), item, subitems, var_list, true, 0);
lbl28:
            // 3 sources

            ** while (this.workStr.length() > 0 && this.workStr.charAt((int)0) != '}')
        }
lbl29:
        // 1 sources

        ((PHPValue)item.getValue()).addVariable(subitems);
        this.workStr = this.workStr.substring(1);
        return item;
    }

    void ParseEvalNULL(String name, PHPVariable parent, Vector list, Vector var_list, int startIdx) throws DebugException {
        int idx = startIdx;
        if (idx >= this.workStr.length() || this.workStr.charAt(idx) != ';') {
            Status status = new Status(4, PHPDebugCorePlugin.getUniqueIdentifier(), 0, "NULL not found!", null);
            throw new DebugException((IStatus)status);
        }
        this.workStr = this.workStr.substring(1);
        PHPVariable item = new PHPVariable(this.fStackFrame, name, parent, "NULL", 0, null);
        list.add(item);
        if (var_list != null) {
            var_list.add(item);
        }
    }

    boolean ParseEvalInt(String name, PHPVariable parent, Vector list, Vector var_list, int startIdx) throws DebugException {
        String subs = this.ExtractSubStr(':', ';', startIdx);
        PHPVariable item = new PHPVariable(this.fStackFrame, name, parent, subs, 1, null);
        list.add(item);
        if (var_list != null) {
            var_list.add(item);
        }
        return true;
    }

    boolean ParseEvalDouble(String name, PHPVariable parent, Vector list, Vector var_list, int startIdx) throws DebugException {
        String subs = this.ExtractSubStr(':', ';', startIdx);
        PHPVariable item = new PHPVariable(this.fStackFrame, name, parent, subs, 2, null);
        list.add(item);
        if (var_list != null) {
            var_list.add(item);
        }
        return true;
    }

    boolean ParseEvalString(String name, PHPVariable parent, Vector list, Vector var_list, boolean MakePhpStr, int startIdx) throws DebugException {
        int slen = this.ExtractInt(':', ':', startIdx);
        if (this.workStr.length() <= slen || this.workStr.charAt(0) != '\"') {
            Status status = new Status(4, PHPDebugCorePlugin.getUniqueIdentifier(), 0, "no String startcharecter!", null);
            throw new DebugException((IStatus)status);
        }
        this.workStr = this.workStr.substring(1);
        String subs = this.workStr.substring(0, slen);
        subs = subs.replaceAll("\\\\\\\\", "\\\\");
        if (this.workStr.charAt(slen) != '\"') {
            Status status = new Status(4, PHPDebugCorePlugin.getUniqueIdentifier(), 0, "no String endcharecter!", null);
            throw new DebugException((IStatus)status);
        }
        this.workStr = this.workStr.substring(slen + 2);
        PHPVariable item = new PHPVariable(this.fStackFrame, name, parent, subs, 3, null);
        list.add(item);
        if (var_list != null) {
            var_list.add(item);
        }
        return true;
    }

    boolean ParseEvalBool(String name, PHPVariable parent, Vector list, Vector var_list, int startIdx) throws DebugException {
        long v = this.ExtractInt(':', ';', startIdx);
        PHPVariable item = new PHPVariable(this.fStackFrame, name, parent, v == 0L ? "FALSE" : "TRUE", 6, null);
        list.add(item);
        if (var_list != null) {
            var_list.add(item);
        }
        return true;
    }

    boolean ParseEvalObject(String name, PHPVariable parent, Vector list, Vector var_list, int startIdx) throws DebugException {
        int slen = this.ExtractInt(':', ':', startIdx);
        String classname = this.ExtractQuotedSubStr(slen, startIdx);
        if (classname.length() != slen) {
            return false;
        }
        this.ParseEvalArray(name, parent, list, var_list, classname, 5);
        return true;
    }

    boolean ParseEvalResource(String name, PHPVariable parent, Vector list, Vector var_list, int startIdx) throws DebugException {
        int slen = this.ExtractInt(':', ':', startIdx);
        String restype = this.ExtractQuotedSubStr(slen, startIdx);
        String val = this.ExtractSubStr(':', ';', startIdx);
        PHPVariable item = new PHPVariable(this.fStackFrame, name, parent, String.valueOf(restype) + ":" + val, 7, null);
        list.add(item);
        if (var_list != null) {
            var_list.add(item);
        }
        return true;
    }

    boolean ParseEvalRef(String name, PHPVariable parent, Vector list, Vector var_list, boolean isSoftRef, int startIdx) throws DebugException {
        int v = this.ExtractInt(':', ';', startIdx);
        PHPVariable item = new PHPVariable(this.fStackFrame, name, parent, "", isSoftRef ? 9 : 8, null);
        if (var_list == null || --v < 0 || v >= var_list.size()) {
            return true;
        }
        PHPVariable var_item = (PHPVariable)var_list.get(v);
        try {
            item.setValue(var_item.getValue());
            item.setReferenceType(var_item.getReferenceType());
            ((PHPValue)item.getValue()).setParent(item);
        }
        catch (DebugException e) {
            e.printStackTrace();
        }
        list.add(item);
        return true;
    }

    public PHPVariable[] getVars() {
        Vector list = new Vector();
        Vector var_list = new Vector();
        this.parse("", null, list, var_list, false, 0);
        return list.toArray(new PHPVariable[list.size()]);
    }

    public Vector getVariables() {
        Vector list = new Vector();
        Vector var_list = new Vector();
        this.parse("", null, list, var_list, false, 0);
        return list;
    }

    boolean parse(String name, PHPVariable parent, Vector list, Vector var_list, boolean MakePhpStr, int startIdx) {
        boolean ret_val = false;
        if (startIdx >= this.workStr.length()) {
            return false;
        }
        char ch = this.workStr.charAt(startIdx);
        this.workStr = this.workStr.substring(1);
        try {
            switch (ch) {
                case 'N': {
                    this.ParseEvalNULL(name, parent, list, var_list, startIdx);
                    break;
                }
                case 'i': {
                    this.ParseEvalInt(name, parent, list, var_list, startIdx);
                    break;
                }
                case 'd': {
                    this.ParseEvalDouble(name, parent, list, var_list, startIdx);
                    break;
                }
                case 's': {
                    this.ParseEvalString(name, parent, list, var_list, MakePhpStr, startIdx);
                    break;
                }
                case 'a': {
                    this.ParseEvalArray(name, parent, list, var_list, "", 4);
                    break;
                }
                case 'O': {
                    this.ParseEvalObject(name, parent, list, var_list, startIdx);
                    break;
                }
                case 'b': {
                    this.ParseEvalBool(name, parent, list, var_list, startIdx);
                    break;
                }
                case 'z': {
                    this.ParseEvalResource(name, parent, list, var_list, startIdx);
                    break;
                }
                case 'R': {
                    this.ParseEvalRef(name, parent, list, var_list, false, startIdx);
                    break;
                }
                case 'r': {
                    this.ParseEvalRef(name, parent, list, var_list, true, startIdx);
                }
            }
        }
        catch (DebugException e) {
            e.printStackTrace();
        }
        return ret_val;
    }
}

