/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.phpdt.internal.debug.core.model;

import net.sourceforge.phpdt.internal.debug.core.PHPDBGProxy;
import net.sourceforge.phpdt.internal.debug.core.breakpoints.PHPLineBreakpoint;
import net.sourceforge.phpdt.internal.debug.core.model.IPHPDebugTarget;
import net.sourceforge.phpdt.internal.debug.core.model.PHPDebugElement;
import net.sourceforge.phpdt.internal.debug.core.model.PHPThread;
import net.sourceforge.phpeclipse.PHPeclipsePlugin;
import org.eclipse.core.resources.IMarkerDelta;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.DebugEvent;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IBreakpointListener;
import org.eclipse.debug.core.IBreakpointManager;
import org.eclipse.debug.core.IDebugEventSetListener;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchListener;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.core.model.IMemoryBlock;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.debug.core.model.IThread;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.model.IWorkbenchAdapter;

public class PHPDebugTarget
extends PHPDebugElement
implements IPHPDebugTarget,
ILaunchListener,
IDebugEventSetListener {
    private IProcess process;
    private ILaunch launch;
    private PHPThread[] threads = new PHPThread[0];
    private PHPDBGProxy phpDBGProxy;
    private final State state = new State();
    static /* synthetic */ Class class$0;

    public PHPDebugTarget(ILaunch launch, IProcess process) {
        super(null);
        if (launch == null && process == null) {
            throw new IllegalArgumentException();
        }
        this.launch = launch;
        this.process = process;
        IBreakpointManager manager = DebugPlugin.getDefault().getBreakpointManager();
        manager.addBreakpointListener((IBreakpointListener)this);
        DebugPlugin.getDefault().addDebugEventListener((IDebugEventSetListener)this);
        this.initialize();
    }

    protected synchronized void initialize() {
        DebugEvent ev = new DebugEvent((Object)this, 4);
        DebugPlugin.getDefault().fireDebugEventSet(new DebugEvent[]{ev});
    }

    public void addThread(PHPThread phpThread) {
        PHPThread[] updatedThreads = new PHPThread[this.threads.length + 1];
        int i = 0;
        while (i < this.threads.length) {
            updatedThreads[i] = this.threads[i];
            ++i;
        }
        updatedThreads[i] = phpThread;
        this.threads = updatedThreads;
        this.fireChangeEvent();
        this.fireThreadCreateEvent(phpThread);
    }

    private void fireChangeEvent() {
        DebugEvent ev = new DebugEvent((Object)this, 16);
        DebugPlugin.getDefault().fireDebugEventSet(new DebugEvent[]{ev});
    }

    private void fireThreadCreateEvent(PHPThread phpThread) {
        DebugEvent ev = new DebugEvent((Object)phpThread, 4);
        DebugPlugin.getDefault().fireDebugEventSet(new DebugEvent[]{ev});
    }

    protected PHPThread getThreadById(int id) {
        int i = 0;
        while (i < this.threads.length) {
            if (this.threads[i].getId() == id) {
                return this.threads[i];
            }
            ++i;
        }
        return null;
    }

    public IThread[] getThreads() {
        return this.threads;
    }

    public boolean hasThreads() throws DebugException {
        return this.threads.length > 0;
    }

    public String getName() throws DebugException {
        return "PHP Debugger at localhost:" + this.getPHPDBGProxy().getPort();
    }

    public boolean supportsBreakpoint(IBreakpoint arg0) {
        return arg0.getModelIdentifier().equals("net.sourceforge.phpeclipse.debug.core");
    }

    public String getModelIdentifier() {
        return "net.sourceforge.phpeclipse.debug.core";
    }

    public IDebugTarget getDebugTarget() {
        return this;
    }

    public ILaunch getLaunch() {
        return this.launch;
    }

    public synchronized boolean canTerminate() {
        return !this.isTerminated();
    }

    public synchronized boolean isTerminated() {
        return this.state.isTerminated();
    }

    public synchronized void terminate() {
        if (this.isTerminated()) {
            return;
        }
        this.state.setTerminated(true);
        this.phpDBGProxy.stop();
        this.threads = new PHPThread[0];
        this.fireChangeEvent();
        IBreakpointManager manager = DebugPlugin.getDefault().getBreakpointManager();
        manager.removeBreakpointListener((IBreakpointListener)this);
        DebugPlugin.getDefault().removeDebugEventListener((IDebugEventSetListener)this);
    }

    public synchronized boolean canResume() {
        if (this.isTerminated()) {
            return false;
        }
        return this.isSuspended();
    }

    public synchronized boolean canSuspend() {
        if (this.isTerminated()) {
            return false;
        }
        return !this.isSuspended();
    }

    public synchronized boolean isSuspended() {
        return this.state.isSuspended();
    }

    public synchronized void resume() throws DebugException {
        if (!this.isSuspended()) {
            return;
        }
        this.state.setSuspended(false);
        this.getPHPDBGProxy().resume();
        IThread[] threads = this.getThreads();
        int i = 0;
        while (i < threads.length) {
            threads[i].resume();
            ++i;
        }
    }

    public synchronized void suspend() throws DebugException {
        if (this.isSuspended()) {
            return;
        }
        this.getPHPDBGProxy().pause();
        this.state.setSuspended(true);
        IThread[] threads = this.getThreads();
        int i = 0;
        while (i < threads.length) {
            threads[i].suspend();
            ++i;
        }
    }

    public void breakpointAdded(IBreakpoint breakpoint) {
        this.getPHPDBGProxy().addBreakpoint(breakpoint);
    }

    public void breakpointRemoved(IBreakpoint breakpoint, IMarkerDelta arg1) {
        this.getPHPDBGProxy().removeBreakpoint(breakpoint);
    }

    public void breakpointChanged(IBreakpoint breakpoint, IMarkerDelta arg1) {
        PHPLineBreakpoint bp = (PHPLineBreakpoint)breakpoint;
        try {
            if (breakpoint.isEnabled() && !arg1.getAttribute("org.eclipse.debug.core.enabled", false)) {
                this.getPHPDBGProxy().addBreakpoint(breakpoint);
            } else if (!breakpoint.isEnabled() && arg1.getAttribute("org.eclipse.debug.core.enabled", true)) {
                this.getPHPDBGProxy().removeBreakpoint(breakpoint);
            } else if (bp.getChangeID() != arg1.getAttribute("net.sourceforge.phpeclipse.debug.changeID", 0)) {
                if (breakpoint.isEnabled()) {
                    this.getPHPDBGProxy().removeBreakpoint(breakpoint);
                    this.getPHPDBGProxy().addBreakpoint(breakpoint);
                } else {
                    this.getPHPDBGProxy().removeBreakpoint(breakpoint);
                }
            } else {
                this.terminate();
            }
        }
        catch (CoreException coreException) {}
    }

    public boolean canDisconnect() {
        return false;
    }

    public void disconnect() throws DebugException {
    }

    public boolean isDisconnected() {
        return false;
    }

    public boolean supportsStorageRetrieval() {
        return false;
    }

    public IMemoryBlock getMemoryBlock(long arg0, long arg1) throws DebugException {
        return null;
    }

    public Object getAdapter(Class arg0) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.ui.model.IWorkbenchAdapter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (clazz.equals(arg0)) {
            return new IWorkbenchAdapter(){

                public Object[] getChildren(Object o) {
                    Object[] children = null;
                    IThread[] threads = PHPDebugTarget.this.getThreads();
                    if (threads != null) {
                        children = new Object[threads.length];
                        int i = 0;
                        while (i < threads.length) {
                            children[i] = threads[i];
                            ++i;
                        }
                    }
                    return children;
                }

                public ImageDescriptor getImageDescriptor(Object object) {
                    return null;
                }

                public String getLabel(Object o) {
                    String label = "(Unable to look up name... check error log)";
                    try {
                        label = PHPDebugTarget.this.getName();
                    }
                    catch (DebugException x) {
                        PHPeclipsePlugin.log((String)label, (Throwable)x);
                    }
                    return label;
                }

                public Object getParent(Object o) {
                    return PHPDebugTarget.this.getLaunch();
                }
            };
        }
        return null;
    }

    public IProcess getProcess() {
        return this.process;
    }

    public void setProcess(IProcess process) {
        this.process = process;
    }

    public PHPDBGProxy getPHPDBGProxy() {
        return this.phpDBGProxy;
    }

    public void setPHPDBGProxy(PHPDBGProxy phpDBGProxy) {
        this.phpDBGProxy = phpDBGProxy;
    }

    public void launchRemoved(ILaunch launch) {
        if (!this.isTerminated()) {
            return;
        }
        if (launch.equals(this.getLaunch())) {
            this.terminate();
        }
    }

    public void launchAdded(ILaunch launch) {
    }

    public void launchChanged(ILaunch launch) {
    }

    public void handleDebugEvents(DebugEvent[] events) {
        int i = 0;
        while (i < events.length) {
            DebugEvent event = events[i];
            if (event.getKind() == 8) {
                Object source = event.getSource();
                if (source instanceof PHPDebugTarget || source instanceof IDebugTarget) {
                    this.getPHPDBGProxy().stop();
                } else if (source instanceof IProcess && this.getDebugTarget().getProcess() == (IProcess)source) {
                    this.getPHPDBGProxy().stop();
                }
            } else if (event.getKind() == 2) {
                this.getPHPDBGProxy().pause();
            }
            ++i;
        }
    }

    private class State {
        private boolean isTerminated = false;
        private boolean isSuspended = false;

        State() {
        }

        boolean isTerminated() {
            return this.isTerminated;
        }

        boolean isSuspended() {
            return this.isSuspended;
        }

        void setTerminated(boolean terminated) {
            this.isTerminated = terminated;
        }

        void setSuspended(boolean suspended) {
            if (this.isTerminated()) {
                throw new IllegalStateException();
            }
            this.isSuspended = suspended;
        }
    }
}

