/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.phpdt.internal.debug.core.model;

import java.util.Vector;
import net.sourceforge.phpdt.internal.debug.core.model.PHPStackFrame;
import net.sourceforge.phpdt.internal.debug.core.model.PHPValue;
import org.eclipse.core.runtime.Platform;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.core.model.IValue;
import org.eclipse.debug.core.model.IVariable;

public class PHPVariable
implements IVariable {
    private PHPValue fValue;
    private String fName;
    private PHPStackFrame fStackFrame;
    private PHPVariable fParent;
    private String fLongName;

    PHPVariable() {
        this(null, "", null, "", 0, null);
    }

    PHPVariable(PHPStackFrame frame, String name, PHPVariable parent, String value, int valueType, Vector subitems) {
        this.fStackFrame = frame;
        this.fValue = new PHPValue(frame, value, valueType, subitems);
        this.fParent = parent;
        this.setName(name);
    }

    public void setName(String name) {
        if (this.fParent == null || this.fParent.getName() == "") {
            this.fLongName = name;
            this.fName = name;
            return;
        }
        switch (this.fParent.getReferenceType()) {
            case 4: {
                this.fName = "['" + name + "']";
                this.fLongName = String.valueOf(this.fParent.getLongName()) + this.fName;
                break;
            }
            case 5: {
                this.fName = name;
                this.fLongName = String.valueOf(this.fParent.getLongName()) + "." + this.fName;
                break;
            }
            default: {
                this.fName = name;
                this.fLongName = name;
            }
        }
    }

    public IValue getValue() {
        return this.fValue;
    }

    public String getName() {
        return this.fName;
    }

    public PHPVariable getParent() {
        return this.fParent;
    }

    public void setParent(PHPVariable parent) {
        this.fParent = parent;
        this.fLongName = String.valueOf(parent.getLongName()) + this.fName;
    }

    public String getLongName() {
        return this.fLongName;
    }

    public String getReferenceTypeName() {
        return this.fValue.getReferenceTypeName();
    }

    public int getReferenceType() {
        return this.fValue.getReferenceType();
    }

    public int setReferenceType(int type) {
        return ((PHPValue)this.getValue()).setReferenceType(type);
    }

    public boolean hasValueChanged() throws DebugException {
        return this.fValue.hasValueChanged();
    }

    public void setValueChanged(boolean changed) {
        this.fValue.setValueChanged(changed);
    }

    public String getModelIdentifier() {
        return this.getDebugTarget().getModelIdentifier();
    }

    public IDebugTarget getDebugTarget() {
        return this.fStackFrame.getDebugTarget();
    }

    public ILaunch getLaunch() {
        return this.getDebugTarget().getLaunch();
    }

    public void setValue(String expression) throws DebugException {
        String evalString = this.fValue.getReferenceType() == 3 ? String.valueOf(this.fLongName) + "=\"" + expression + "\"" : String.valueOf(this.fLongName) + "=" + expression;
        PHPVariable[] vars = this.fStackFrame.getPHPDBGProxy().eval(this.fStackFrame, evalString);
        this.setValue(vars[0].fValue);
    }

    public void setValue(IValue value) throws DebugException {
        this.fValue = (PHPValue)value;
    }

    public boolean supportsValueModification() {
        return true;
    }

    public boolean verifyValue(String expression) throws DebugException {
        return true;
    }

    public boolean verifyValue(IValue value) throws DebugException {
        return false;
    }

    public Object getAdapter(Class adapter) {
        return Platform.getAdapterManager().getAdapter((Object)this, adapter);
    }

    public String toString() {
        String str = "";
        block0 : switch (this.getReferenceType()) {
            case 4: {
                int elements = this.fValue.getVariables().length;
                switch (elements) {
                    case 0: {
                        str = String.valueOf(this.getName()) + " [no elements]";
                        break block0;
                    }
                    case 1: {
                        str = String.valueOf(this.getName()) + " [1 element]";
                        break block0;
                    }
                }
                str = String.valueOf(this.getName()) + " [" + elements + " elements]";
                break;
            }
            case 5: {
                str = String.valueOf(this.getName()) + " [class: " + this.fValue.getValueString() + "]";
                break;
            }
            case 3: {
                str = String.valueOf(this.getName()) + " = \"" + this.fValue.getValueString() + "\"";
                break;
            }
            default: {
                str = String.valueOf(this.getName()) + " = " + this.fValue.getValueString();
            }
        }
        return str;
    }
}

