#!/usr/local/bin/perl

# RIPE DB location
$ripedb = "ftp://ftp.ripe.net/ripe/local-ir/allocations";
$ripefile = "allocations";

# get RIPE data
open(DATA, "/usr/bin/fetch -a -o - -p -q $ripedb 2>/dev/null |") or die "can't execute fetch: $!\n";

# open(DATA, $ripefile) or die;

# loop
while (<DATA>) {

  # russian LIRs
  if ($_ =~ /^ru/) {

    # LIR's name
#    printf "%s", split;

    # LIR's allocations
    while (<DATA>) {

      # next LIR?
      last if ($_ =~ /^$/);

      # extract block
      s/^\t\S*\t(\S*)\t.*\n$/$1/;

      # parse and expand
      @fields = split(/\//); @addr = (split(/\./, $fields[0]), (0) x 4);

      # results
      printf "%s.%s.%s.%s /%s\n",
        $addr[0], $addr[1], $addr[2], $addr[3], $fields[1];

    }
#    printf "\n";
  }
}

