#!usr/bin/perl -w
# $NetAMS$ 

use Socket;

#------------------------------------------------------------------------------------------------
sub netams_login {
	my ($host, $port, $user, $passwd)=@_;
	#$user="weblogin" if !defined $user;
	#$passwd="WEB" if !defined $passwd;

	socket(NETAMS_SOCKET, PF_INET, SOCK_STREAM, getprotobyname('tcp'));
	my $sin = sockaddr_in($port,inet_aton($host));
	$! = 0;
	connect(NETAMS_SOCKET, $sin);
	my $old_fh = select(NETAMS_SOCKET); 
	$| = 1; 		        # don't buffer output
	select($old_fh);

	if ($!) { return "Error connecting to server at $host:$port\n"; }
	else {
		netams_read();# skip 1st line and auth prompt
		netams_send($user);# send username
		netams_read();# skip 1st line and auth prompt
		netams_send($passwd);# send pass
		$welcome=netams_read();# skip "Welcome"
		}

	if (index($welcome, "Welcome")==-1) { return "Authentication failed!"; } else { return "$welcome"; }
	}

#------------------------------------------------------------------------------------------------
sub netams_send { 
	my ($what) = @_; 
#	print "---S: $what\n";
	print NETAMS_SOCKET "$what\x0D\x0A"; 
	}

#------------------------------------------------------------------------------------------------
sub netams_read {
	my ($visible) = @_;
	my $byte = "";
	my $prev_byte = "";
	my $out_string = "";
	my $count = 0;
	while (($byte ne ">") && ($byte ne "#")) {
#	while ($byte ne ">" ||$prev_byte ne "\n") {
		$out_string .= $byte;
		$prev_byte = $byte;
		$count = sysread(NETAMS_SOCKET, $byte, 1);
		if (!defined $count) { sleep(1); next; }
		if ($count == 0) { last; }
		}
#	print "---R: $out_string\n";
	return $out_string;
	}

#------------------------------------------------------------------------------------------------
sub netams_readline {
	my ($visible) = @_;
	my $byte = "";
	my $prev_byte = "";
	my $out_string = "";
	my $count = 0;
	while ($byte ne ">" ||$prev_byte ne "\n") {
		$out_string .= $byte;
		$prev_byte = $byte;
		$count = sysread(NETAMS_SOCKET, $byte, 1);
		if (!defined $count) { sleep(1); next; }
		if ($count == 0) { last; }
		}
#	print "---R: $out_string\n";
	return $out_string;
	}

#------------------------------------------------------------------------------------------------
sub netams_logout {
	netams_send("");
	netams_send("exit");
	netams_read();
	close(NETAMS_SOCKET);
	}

#------------------------------------------------------------------------------------------------
#------------------------------------------------------------------------------------------------
#------------------------------------------------------------------------------------------------

1;
