/*************************************************************************
***     Authentication, authorization, accounting + firewalling package
***     (c) 1998-2003 Anton Vinokurov <anton@netams.com>
***		(c) 2003 NeTAMS Development Team
***		All rights reserved. See 'Copying' file included in distribution
***		For latest version and more info, visit this project web page
***		located at http://www.netams.com
***		 					
*************************************************************************/
/* $Id: messages_fifo.c,v 1.6.2.3 2004/05/06 10:35:03 jura Exp $ */

#include "netams.h"

//////////////////////////////////////////////////////////////////////////
// Message class

Message::Message(){
	type=MSG_UNKNOWN;
	next=NULL;
	pdata=NULL;
	data.in=data.out=data.from=data.to=0;
	ap=netunit=id=ts=0;
	stat=NULL;
	lock=(pthread_mutex_t*)aMalloc(sizeof(pthread_mutex_t));
        pthread_mutex_init(lock, NULL);
	active=0;
}

Message::~Message(){
//	aLog(D_INFO,"this=%p, %d\n",this,active);
	if (stat) aFree(stat);
	pthread_mutex_destroy(lock);
        aFree(lock);
}

void Message::Push(){
	pthread_mutex_lock(lock);
	active++;
//	printf("Message Push: active=%d lock=%p this=%p\n",active,lock,this);
	pthread_mutex_unlock(lock);
}

void Message::Pop(){
        pthread_mutex_lock(lock);
        active--;
//	printf("Message Pop: active=%d lock=%p this=%p\n",active,lock,this);
        pthread_mutex_unlock(lock);
}

unsigned Message::Active(){
        return active;
}

//////////////////////////////////////////////////////////////////////////
// FIFO class

FIFO::FIFO(unsigned max){
	root=last=NULL;
	num_items=total_items=0;
	max_items=max;
	lock=(pthread_mutex_t*)aMalloc(sizeof(pthread_mutex_t));
	pthread_mutex_init(lock, NULL);
}

FIFO::~FIFO(){
	pthread_mutex_destroy(lock);
	aFree(lock);
}

unsigned FIFO::Push(Message *msg){
//	printf("FIFO push: %p lock:%p\n", msg, lock);
	pthread_mutex_lock(lock);
	if (root==NULL) root=msg;
	else last->next=msg;
	last=msg;
	msg->next=NULL; 
	num_items++;
	total_items++;
	msg->Push();
	if (num_items>max_items) {
                aLog(D_WARN, "FIFO %p overloaded, discarding message %p\n",this,root);
		msg=root;
                root=root->next;
		msg->Pop();
                if(!msg->Active()) delete msg;
		num_items--;
        }
	pthread_mutex_unlock(lock);
//	printf("FIFO push: %p\n", msg);
	return num_items;
//	printf("FIFO push:  %p lock:%p\n", msg,lock);
}

Message* FIFO::Pop(){
//	printf("FIFO pop:  lock:%p\n", lock);
	pthread_mutex_lock(lock);
	Message *m;
	m=root;
	if (root) {
		root->Pop();
		root=root->next;
		num_items--;
	}
	pthread_mutex_unlock(lock);
//	printf("FIFO pop:  %p lock:%p\n", m,lock);
	return m;
}

Message* FIFO::TryPop(){
        return root;
}
//////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////

