/*************************************************************************
***     Authentication, authorization, accounting + firewalling package
***     (c) 1998-2003 Anton Vinokurov <anton@netams.com>
***		(c) 2003 NeTAMS Development Team
***		All rights reserved. See 'Copying' file included in distribution
***		For latest version and more info, visit this project web page
***		located at http://www.netams.com
***		 					
*************************************************************************/
/* $Id: messages_fifo.h,v 1.5.2.2 2004/05/06 10:35:03 jura Exp $ */


//////////////////////////////////////////////////////////////////////////
// Message class
enum message_type { SOURCE, STORE, READ, STAT, ALERT, COMMAND, MSG_UNKNOWN=1000 };

typedef struct stat_data {
	unsigned num_policies;
	unsigned num_points;
	unsigned long long *in;
	unsigned long long *out;
	} stat_data;

class Message {
	private:
		pthread_mutex_t *lock;
	public:
		message_type type;
		Message *next;
		alert *al;
		oid netunit;
		oid ap;
		policy_data *pdata;
		pstat data;
		oid id;
		char prefix; // T, M, W, D, H, F
		time_t ts;
		pthread_cond_t *unblock; // do we really need this?
		stat_data *stat;
		Message();
		~Message();
		unsigned active;
		void Push();
		void Pop();
		unsigned Active();
};
//////////////////////////////////////////////////////////////////////////
// FIFO class
class FIFO {
	private:
		pthread_mutex_t *lock;
	public:
		Message *root;
		Message *last;
		unsigned num_items;
		unsigned max_items;
		unsigned total_items;
		FIFO(unsigned max);
		~FIFO();
		unsigned Push(Message *msg);
		Message *TryPop();
		Message *Pop();
};
//////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////

