/*************************************************************************
***     Authentication, authorization, accounting + firewalling package
***     (c) 1998-2003 Anton Vinokurov <anton@netams.com>
***		(c) 2003 NeTAMS Development Team
***		All rights reserved. See 'Copying' file included in distribution
***		For latest version and more info, visit this project web page
***		located at http://www.netams.com
***		 					
*************************************************************************/
/* $Id: p_prefix.c,v 1.13.2.3 2004/07/12 07:54:26 jura Exp $ */

#include "netams.h"

/////////////////////////////////////////////////////////////////////////////////////////////
PrefixFile::PrefixFile(){
	list=NULL;
	filename=NULL;
	num_prefixes=0;
	descriptor=NULL;
	ptree=new PrefixTree;
	rwlock=(pthread_rwlock_t*)aMalloc(sizeof (pthread_rwlock_t));
	pthread_rwlock_init(rwlock, NULL);
	//	printf("PrefixFile constructor: this=%p\n", this);
}
/////////////////////////////////////////////////////////////////////////////////////////////
PrefixFile::~PrefixFile(){
	if(list) this->Unload();
        delete ptree;
	pthread_rwlock_destroy(rwlock);
	aFree(rwlock);
	aFree(filename);
}
/////////////////////////////////////////////////////////////////////////////////////////////
int PrefixFile::Load(char *f){
	char *tmp=set_string(f);
	if (filename) aFree(filename);
	filename=tmp;
	descriptor=fopen(filename, "r");
	if (!descriptor) { aLog(D_WARN, "unable to open prefix file: %s\n", strerror(errno)); return -1; }

	char addr[64];
	unsigned mask;
	struct in_addr ia;
	unsigned i=0;

	pthread_rwlock_wrlock(rwlock);
	
	while (!feof(descriptor)){
		fscanf(descriptor, "%s /%u\n", addr, &mask);
		num_prefixes++;
	}
	rewind(descriptor);
	
	list=(prefix*)aMalloc(sizeof(prefix)*(num_prefixes));

	while (!feof(descriptor) && i<num_prefixes){
		fscanf(descriptor, "%s /%u\n", addr, &mask);
		inet_aton(addr, &ia);
		list[i].network=ia.s_addr;
		list[i].mask=(u_char)mask;
		list[i].match=0;
                ptree->prefix2tree(&list[i]);
//		printf("i=%4lu addr=%s mask=%u flag=%u match=%llu\n", i, addr, mask, flag, match);
		i++;	
	}
	pthread_rwlock_unlock(rwlock);
	aLog(D_INFO, "%u prefixes from %s read ok, starting %p\n", num_prefixes, filename, list); 
	aLog(D_INFO, "PrefixTree: %lu nodes [%u] + %lu dynamic links [%u] allocated, %lu bytes used\n",ptree->nodes,sizeof(IPTree_node),ptree->dlink,256*sizeof(IPTree_node*),ptree->nodes*sizeof(IPTree_node)+ptree->dlink*256*sizeof(IPTree_node*));
	fclose(descriptor);
	descriptor=NULL;
	return 0;
}
/////////////////////////////////////////////////////////////////////////////////////////////
void PrefixFile::Unload(){

	aLog(D_INFO, "%u prefixes from %s closed\n", num_prefixes, filename); 
	pthread_rwlock_wrlock(rwlock);
	ptree->freetree(ptree->root);
	aFree(list);
	list=NULL;
	pthread_rwlock_unlock(rwlock);
	num_prefixes=0;
}
/////////////////////////////////////////////////////////////////////////////////////////////
u_char PrefixFile::Check(unsigned addr){
	u_char mf=0;

	if(!ptree->root) return 0;
	pthread_rwlock_rdlock(rwlock);
	if(ptree->checktree(addr))  mf=1;
	pthread_rwlock_unlock(rwlock);
	return mf;
}
/////////////////////////////////////////////////////////////////////////////////////////////
void PrefixFile::Dump(Connection *c){
	struct in_addr i1;
	prefix *p;

	aParse(c, "prefix file %s, total %u entries\n", filename, num_prefixes);

	pthread_rwlock_rdlock(rwlock);
	for (unsigned i=0; i<num_prefixes; i++) {
		p=&list[i];
		i1.s_addr=p->network; 
		aParse(c, "prefix %04u %s/%u %llu\n", i, inet_ntoa(i1), p->mask, p->match);
	}
	pthread_rwlock_unlock(rwlock);
}
/////////////////////////////////////////////////////////////////////////////////////////////
void PrefixFile::Do(Connection *conn, char *action, char *action2){
	if (!strcasecmp(action, "reload")) { 
		Unload(); 
		Load(filename); 
	}
	else if (!strcasecmp(action, "save")) Save(conn);
	else if (!strcasecmp(action, "dump")) Dump(conn); 
	else if (!strcasecmp(action, "unload")) Unload(); 
	else if (!strcasecmp(action, "zeromatch")) {
		pthread_rwlock_wrlock(rwlock);
		for (unsigned i=0; i<num_prefixes; i++) list[i].match=0;
		pthread_rwlock_unlock(rwlock);
		aParse(conn, "all prefixes match set to zero\n");
	}
	else aParse(conn, "unknown 'do' action requested: '%s'\n", action);
}
/////////////////////////////////////////////////////////////////////////////////////////////
void PrefixFile::Save(Connection *conn){
	if(!ptree->root) {aParse(conn, "nothing to save: ip tree is empty\n"); return;}
	descriptor=fopen(filename, "w");
	if (!descriptor) {
		aLog(D_WARN, "unable to open prefix file %s: %s!\n",filename,strerror(errno)); 
		return;
	}
	rewind(descriptor);
	prefix *p;
	struct in_addr ia;

	pthread_rwlock_rdlock(rwlock);
	for (unsigned i=0; i<num_prefixes; i++){
		p=&list[i];
		ia.s_addr=p->network;
		fprintf(descriptor, "%s /%u\n", inet_ntoa(ia), p->mask);
	}

	pthread_rwlock_unlock(rwlock);
	fflush(descriptor);
	fclose(descriptor);
	aParse(conn, "%u prefixes saved to %s(%p)\n", num_prefixes, filename, descriptor);
}
/////////////////////////////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////////////////////////////
