/*************************************************************************
***     Authentication, authorization, accounting + firewalling package
***     (c) 1998-2003 Anton Vinokurov <anton@netams.com>
***		(c) 2003 NeTAMS Development Team
***		All rights reserved. See 'Copying' file included in distribution
***		For latest version and more info, visit this project web page
***		located at http://www.netams.com
***		 					
*************************************************************************/
/* $Id: policy_prefix.h,v 1.8.2.2 2004/07/12 07:54:26 jura Exp $ */

typedef struct prefix {
	in_addr_t network;
	u_char mask;
	unsigned long long match;
} prefix;

class PrefixTree;

class PrefixFile {
	public:
		prefix *list;
		PrefixTree *ptree;
		char *filename;
		FILE *descriptor;
		unsigned num_prefixes;
		pthread_rwlock_t *rwlock;
		PrefixFile();
		~PrefixFile();
		int Load(char *filename); // *
		void Unload(); // *
		void Do(Connection *conn, char *action, char *action2=NULL);
		u_char Check(unsigned addr);  // we will check if adr match prefix
		void Dump(Connection *conn);
		void Save(Connection *conn);
};
/////////////////////////////////////////////////////////////////////////////////////////////
