/*************************************************************************
***     Authentication, authorization, accounting + firewalling package
***     (c) 1998-2003 Anton Vinokurov <anton@netams.com>
***		(c) 2003 NeTAMS Development Team
***		All rights reserved. See 'Copying' file included in distribution
***		For latest version and more info, visit this project web page
***		located at http://www.netams.com
***		 					
*************************************************************************/
/* $Id: s_monitor.c,v 1.18.2.7 2004/05/06 10:35:04 jura Exp $ */

#include "netams.h"


//////////////////////////////////////////////////////////////////////////////////////////
void sMonitorInit(Service *s){
	s->cfg = (Monitor_cfg*)aMalloc(sizeof(Monitor_cfg));
	Monitor_cfg *cfg=(Monitor_cfg*)s->cfg;
    	
	cfg->name=NULL;
    	cfg->items=0;
    	cfg->to=MON_NONE;
	cfg->st=NULL;
    	cfg->storage_no=0;
	cfg->query=(char*)aMalloc(255);
	cfg->fd=NULL;
	cfg->commit=0;
    }
//////////////////////////////////////////////////////////////////////////////////////////
void sMonitorProcessCfg(char *param[32], Connection *conn, unsigned no_flag){
	Monitor_cfg *cfg=(Monitor_cfg*)conn->service->cfg;

	if (!strcasecmp(param[0], "monitor"))
	if (!strcasecmp(param[1], "?")) { cHelp(conn, no_flag, "monitor"); return; }
	
	if (!strcasecmp(param[1], "to")) {
		if (!strcasecmp(param[2], "storage")) {
			if (cfg->fd) {
                                if (cfg->to==MON_FILE) fclose((FILE*)cfg->fd);
                                if (cfg->to==MON_STORAGE && cfg->st) stCloseSql(cfg->st, cfg->fd);
                        }
                        cfg->fd=NULL;

			if (no_flag) { 
				aParse(conn, "switch monitoring off\n");
				cfg->to=MON_NONE;
				cfg->st=NULL;
				return;
			}	
            		cfg->to=MON_STORAGE;
        		cfg->storage_no=atoi(param[3]);
			Service *storage_s = Services.getService("storage", cfg->storage_no);
			cfg->st=storage_s;
			if(storage_s) aParse(conn, "monitoring to storage %u (%p)\n", cfg->storage_no, storage_s);
			else aParse(conn, "no such service storage:%u\n",cfg->storage_no);
		} else if (!strcasecmp(param[2], "file")) {
                       	if (cfg->fd) {
                                if (cfg->to==MON_FILE) fclose((FILE*)cfg->fd);
                                if (cfg->to==MON_STORAGE && cfg->st) stCloseSql(cfg->st, cfg->fd);
                        }
                        cfg->fd=NULL;

                        if (no_flag) {
				aParse(conn, "switch monitoring off\n");
                                cfg->to=MON_NONE;
				aFree(cfg->name);
                                return;
                        }

            		cfg->to=MON_FILE;
            		int i=strlen(param[3]);
            		if (i) { 
                		if (cfg->fd) fclose((FILE*)cfg->fd);
                		cfg->name=set_string(param[3]);
                		cfg->fd=(void*)fopen(cfg->name, "at");
                		if (cfg->fd) {
                    			setlinebuf((FILE*)cfg->fd);
        				aParse(conn, "monitoring to file %s\n", cfg->name);
                		} else { 
                    			aParse(conn, "unable to open monitor output file %s\n", cfg->name);
                    			cfg->to=MON_NONE;
                    			cfg->fd=NULL;
                    			aFree(cfg->name);
                    		}
                	}
            		else 
				aParse(conn, "monitor output file name unknown\n");
		} else 
			aParse(conn, "unknown monitor output method\n");
	} else if (!strcasecmp(param[1], "unit")) {
        	NetUnit *u;
        	unsigned oid=strtol(param[2], NULL, 16);
        	if (oid) { 
			u=Units.getUnitById(oid);
            		if (!u) u=Units.getUnit(param[2]); 
		}
        	else u=Units.getUnit(param[2]);

        	if (u) { 
            		if (!no_flag) { 
                		int i=Units.setMon(cfg, u->id, NULL); 
                		if (i) aParse(conn, "monitoring unit %s (%06X)\n", u->name?u->name:"<\?\?>", u->id);
                		else aParse(conn, "set monitoring unit %06X failed!\n", u->id);
            		} else {
                		int i=Units.setMon(NULL, u->id, NULL); 
                		if (i) aParse(conn, "not monitoring unit %s (%06X)\n", u->name?u->name:"<\?\?>", u->id);
                		else aParse(conn, "unset monitoring unit %06X failed!\n", u->id);
                	}
        	} else {
            		if (no_flag) {
                		Units.setMon(NULL, 0, NULL);
                		aParse(conn, "disable monitoring for all units\n");
            		} else aParse(conn, "cannot monitor this: unit unknown\n");
       		}
    	}

	else aParse(conn, "unknown monitor command\n");

   }	

//////////////////////////////////////////////////////////////////////////////////////////
void cShowMonitor(Connection *conn){
	Service *s=NULL;
        
	while((s=Services.getServiceByName("monitor",s))) {
        	Monitor_cfg *cfg=(Monitor_cfg*)s->cfg;

		fprintf(conn->stream_w, "service monitor %u\n",s->instance);
    		switch (cfg->to){
        		case MON_NONE:  
				fprintf(conn->stream_w, "Monitoring is off\n");
                    	break;
        	case MON_FILE:  
				fprintf(conn->stream_w, "Monitoring to file: %s\n", cfg->name);
                    		break;
        	case MON_STORAGE:   
				fprintf(conn->stream_w, "Monitoring to storage: %u\n", cfg->storage_no);
                        	break;
        	}
    		if (cfg->to!=MON_NONE) { 
        		fprintf(conn->stream_w, "Units: ");
        		Units.showMon(conn->stream_w, (void*)cfg, 1);
        		fprintf(conn->stream_w, "\n");
        	}
		fprintf(conn->stream_w, "Packets monitored: %u\n",cfg->items);
	}
    }

//////////////////////////////////////////////////////////////////////////////////////////
void sMonitorListCfg(Service *s, FILE *out){
        Monitor_cfg *cfg=(Monitor_cfg*)s->cfg;
    	
	fprintf(out, "service monitor %d\n", s->instance);	
	switch (cfg->to){
        	case MON_NONE:  return;
        	case MON_FILE:  {
                    	fprintf(out, "monitor to file %s\n", cfg->name);
                    	break;
                    	}
        	case MON_STORAGE:   {
                    	fprintf(out, "monitor to storage %u\n", cfg->storage_no);
                    	break;
                    	}
        	}
   		if (cfg->to!=MON_NONE) Units.showMon(out, (void*)cfg, 0);
    	
	fprintf(out, "\n");

}

//////////////////////////////////////////////////////////////////////////////////////////
void aMonitor(NetUnit *u, struct ip *ip, struct timeval *tv, unsigned long len){
        Monitor_cfg *cfg=(Monitor_cfg*)u->monitor;
        time_t t=tv->tv_sec;

        if (cfg->to==MON_FILE) {
                char *t_T;

                t_T=(char *)aMalloc(30); timeU2T(t, t_T);
                char buf1[32], buf2[32];
                strcpy(buf1, inet_ntoa(ip->ip_src)); strcpy(buf2, inet_ntoa(ip->ip_dst));
                fprintf((FILE*)cfg->fd, "%s.%04u %s %06X ", t_T, (unsigned)((double)tv->tv_usec/100), u->name?u->name:"<\?\?>",u->id);
                if (ip->ip_p==IPPROTO_TCP || ip->ip_p==IPPROTO_UDP) {
                        struct tcphdr *th;
                        th=(struct tcphdr *)((unsigned char *)ip + ip->ip_hl*4);
                        fprintf((FILE*)cfg->fd, "%02d s:%s:%u d:%s:%u %lu\n", ip->ip_p, buf1, ntohs(th->th_sport), buf2, ntohs(th->th_dport), len);
                } else
                        fprintf((FILE*)cfg->fd, "%02d s:%s d:%s %lu\n", ip->ip_p, buf1, buf2, len);
                aFree(t_T);
        } else if (cfg->to==MON_STORAGE) {
		if(!cfg->fd) {
                        Service *storage_s = Services.getService("storage", cfg->storage_no);
                        if(storage_s) {
                                cfg->st=storage_s;
                                cfg->fd=stOpenSql(storage_s,ST_CONN_MONITOR);
                                if(!cfg->fd) return;
                        }
                        else return;
                }
                stMonitorToSql(cfg, t, (unsigned)((double)tv->tv_usec/100), u, ip, len);
        }
        cfg->items++;
}
//////////////////////////////////////////////////////////////////////////////////////////
void sMonitorCancel(void *v){
        Service *s = (Service*)v;
        Monitor_cfg *cfg=(Monitor_cfg*)s->cfg;
	
	aLog(D_INFO, "cancelling service monitor:%u\n", s->instance);
	if(cfg->to==MON_FILE && cfg->fd) { 
		fclose((FILE*)cfg->fd);
		aFree(cfg->name);
	}
	if(cfg->to==MON_STORAGE && cfg->fd) {
		Service *storage_s = Services.getService("storage", cfg->storage_no);
                if(storage_s) stCloseSql(storage_s, cfg->fd);
        }
	aFree(cfg->query);
	aFree(cfg);
}

//////////////////////////////////////////////////////////////////////////////////////////
