/*************************************************************************
***     Authentication, authorization, accounting + firewalling package
***     (c) 1998-2003 Anton Vinokurov <anton@netams.com>
***		(c) 2003 NeTAMS Development Team
***		All rights reserved. See 'Copying' file included in distribution
***		For latest version and more info, visit this project web page
***		located at http://www.netams.com
***		 					
*************************************************************************/
/* $Id: s_pvmgate.c,v 1.6.2.2 2004/05/06 10:35:05 jura Exp $ */

#include "netams.h"

void sPVMCancel(void *v);

//////////////////////////////////////////////////////////////////////////
void sPVMInit(Service *s){
	PVM_cfg *cfg=(PVM_cfg*)aMalloc(sizeof(PVM_cfg));
#ifndef PVM
	aLog(D_CRIT, "PVM gateway service is not compiled in!\n");
#endif
	s->cfg = cfg;;
	pthread_create(&(s->t_id), NULL, &sPVM, s);
	}

//////////////////////////////////////////////////////////////////////////
void sPVMProcessCfg(char *param[32], Connection *conn, unsigned no_flag){
#ifndef PVM
	aLog(D_CRIT, "PVM gateway service is not compiled in!\n");
#endif

	}
//////////////////////////////////////////////////////////////////////////
void *sPVM(void *ss){

#ifndef PVM
	aLog(D_CRIT, "PVM gateway service is not compiled in!\n");
#else
	Service *s=(Service*)ss; 

	aLog(D_INFO, "service PVMgateway thread started\n");
	
	pthread_cleanup_push(sPVMCancel, s);
	pthread_setcanceltype(PTHREAD_CANCEL_ASYNCHRONOUS, NULL);
	s->t_id=pthread_self();

	int t_id=pvm_mytid();
	int gr_id=pvm_joingroup("netams32");
	if (gr_id<0) aLog(D_INFO, "failed to join group\n");

	int buf_id, p;
	while(1){
		buf_id=pvm_recv(-1, -1);
		if (buf_id>0) {
			pvm_upkint(&p,1,1);
			aLog(D_INFO, "[%d:%d] got message from %d\n", t_id, gr_id, p);
			}
		}

	pthread_cleanup_pop(0);
#endif
	return NULL;
	}
//////////////////////////////////////////////////////////////////////////
void sPVMCancel(void *v){
#ifndef PVM
	aLog(D_CRIT, "PVM gateway service is not compiled in!\n");
#endif
	Service *s = (Service*)v;
	aFree(s->cfg);
	aLog(D_INFO, "cancelling service PVMgateway:%d\n", s->instance);
}

//////////////////////////////////////////////////////////////////////////
void sPVMListCfg(Service *s, FILE *f){
#ifndef PVM
	aLog(D_CRIT, "PVM gateway service is not compiled in!\n");
#endif
	fprintf(f, "\n");
	}
//////////////////////////////////////////////////////////////////////////
