/*************************************************************************
***     Authentication, authorization, accounting + firewalling package
***     (c) 1998-2003 Anton Vinokurov <anton@netams.com>
***		(c) 2003 NeTAMS Development Team
***		All rights reserved. See 'Copying' file included in distribution
***		For latest version and more info, visit this project web page
***		located at http://www.netams.com
***		 					
*************************************************************************/
/* $Id: s_scheduler.c,v 1.11.2.3 2004/05/06 10:35:05 jura Exp $ */

#include "netams.h"

//////////////////////////////////////////////////////////////////////////
Task::Task(){
	action=str_interval=NULL;
	when=0;
	next=NULL;
	visible=1;
	id=newOid(OID_TASK);
	}

Task::~Task(){
	aFree(action);
	aFree(str_interval);
	}

//////////////////////////////////////////////////////////////////////////
ScheduleList::ScheduleList(){
	root=last=NULL;
	num_tasks=0;
	lock=(pthread_mutex_t*)aMalloc(sizeof (pthread_mutex_t));
	pthread_mutex_init(lock, NULL);
	}

ScheduleList::~ScheduleList(){
	pthread_mutex_destroy(lock);
	aFree(lock);
	}

void ScheduleList::Insert(Task *s){
	pthread_mutex_lock(lock);
	Task *d;
	for(d=root; d!=NULL; d=d->next)
		if (d==s) { 
			pthread_mutex_unlock(lock);
			return;
			}
	if (root==NULL) root=s;
	else last->next=s;
	last=s; 
	num_tasks++;
	pthread_mutex_unlock(lock);
	}	

void ScheduleList::Delete(oid id){
		Task *s = getTaskById(id);
		if (!s) Delete(s);
		}

void ScheduleList::Delete(Task *s){
	pthread_mutex_lock(lock);
	Task *d, *p;
	for(d=root; d!=NULL; d=d->next)	{
		if (d==s) {
			if (s==root && s==last ) root=last=NULL;
			else if (s==root) root=s->next;
			else if (s==last) { last=p; last->next=NULL; }
			else p->next=s->next;

			delete s;
			s=NULL;
			num_tasks--;
			break;
			}
		p=d; 
	 	}
	pthread_mutex_unlock(lock);
	}

Task *ScheduleList::getTask(char *action){
	pthread_mutex_lock(lock);
	Task *d;
	for(d=root; d!=NULL; d=d->next)
		if (!strcmp(d->action, action)) { pthread_mutex_unlock(lock); return d; }
	pthread_mutex_unlock(lock);
	return NULL;
	}

Task *ScheduleList::getTaskById(oid id){
	pthread_mutex_lock(lock);
	Task *d;
	for(d=root; d!=NULL; d=d->next)
		if (d->id == id) { pthread_mutex_unlock(lock); return d; }
	pthread_mutex_unlock(lock);
	return NULL;
	}

void ScheduleList::listTasks(Connection *conn){
	pthread_mutex_lock(lock);
	Task *t;
	fprintf(conn->stream_w, "%6s | %-10s | %7s | %-40s\n", "OID", "INTERVAL", "LEFT", "ACTION");
	for(t=root; t!=NULL; t=t->next){
		if (t->visible) {
			fprintf(conn->stream_w, "%06X | %-10s | %7d | %-40s\n", t->id, t->str_interval, (int)(t->when-time(NULL)), t->action);
			}
		}
	pthread_mutex_unlock(lock);
	}

void ScheduleList::listTasksCfg(FILE *f){
	pthread_mutex_lock(lock);
	Task *t;
	for(t=root; t!=NULL; t=t->next){
		if (t->visible) {
			fprintf(f, "schedule oid %06X", t->id);
			if (t->str_interval) fprintf(f, " time %s", t->str_interval);
			if (t->action) fprintf(f, " action \"%s\"", t->action);
			fprintf(f, "\n");
			}
		}
	pthread_mutex_unlock(lock);
	}

//////////////////////////////////////////////////////////////////////////
unsigned cTask(Connection *conn, char *param[], int no_flag){
	Task *u=NULL;
	
	if (!strcasecmp(param[1], "?")) { cHelp(conn, no_flag, "schedule"); return PARSE_OK; }
	
	else if (!strcmp(param[1], "oid")) u=Sched.getTaskById(strtol(param[2], NULL, 16));
	else if (!strcmp(param[1], "action")) ;
	else if (!strcmp(param[1], "time")) ;
	else { aParse(conn, "schedule command unknown\n"); return PARSE_OK; }
 	
	aDebug(DEBUG_SCHED, "getTaskByOid return: %p, p2=%s\n", u, param[2]);

	if (u && no_flag){
		aParse(conn, "task %06X deleted\n", u->id);
		Sched.Delete(u);
		}

	else if (!u && !no_flag) { 
		u = new Task(); 
		aParse(conn, "task %06X created\n", u->id); 

		int i=1;
		time_t interval=-1;
		while (param[i]!=empty) {
	 		if (strcasecmp(param[i], "action")==0) { 
				u->action=set_string(param[i+1]);
				aParse(conn, "task %06X action set: %s\n", u->id, u->action);

			} else if (strcasecmp(param[i], "oid")==0) {
				oid nu=strtol(param[i+1], NULL, 16);
				aParse(conn, "task %06X oid set: %06X\n", u->id, nu);
				u->id=nu;

			} else if (strcasecmp(param[i], "time")==0) {
				interval=getInterval(param[i+1]); 
				if (interval==-1) aParse(conn, "time interval specified invalid\n");
				else {
					u->str_interval=set_string(param[i+1]);
					u->when=time(NULL)+interval; 
					aParse(conn, "task %06X time set: %s, exec in %ld sec\n", u->id, u->str_interval, interval);
				}
			} else if (strcasecmp(param[i], "invisible")==0) {
				aParse(conn, "task %06X set as invisible\n", u->id);
				u->visible=0;
			}
			else aParse(conn, "schedule %06X command unknown\n", u->id); 

			i=i+2;
		}

		if (interval!=-1) {
			Sched.Insert(u);
			char buff[32]; timeU2T(u->when, buff);
			aLog(D_INFO, "scheduled to: %s\n", buff);
		}
		else aLog(D_INFO, "scheduling failed!\n");
	}
	else if (!u && no_flag) aParse(conn, "task is not exist\n");
				   
	sSched->Wakeup(); // we should re-calculate the scheduling table!

	return PARSE_OK;
}
//////////////////////////////////////////////////////////////////////////
unsigned cShowScheduleList(Connection *conn){
	Sched.listTasks(conn);
	return PARSE_OK;
	}

//////////////////////////////////////////////////////////////////////////
time_t getInterval(char *s_o){

	time_t retval=-1;
	struct tm t1;
	struct tm t2;
	time_t	ti1;
	char s[255], *s1, *s2;
	int h, m, p=0, plus=0;
	char z[32];

	bzero(z, 31);
	bzero(s, 255); strncpy(s, s_o, strlen(s_o));
	s1=&s[strlen(s)-1];
	if (s1[0]=='+') { plus= 10; s1[0]=0; }
	if (s1[0]=='-') { plus=-10; s1[0]=0; }
	sscanf(s, "%d%s", &p, z); 
	
	aDebug(DEBUG_SCHED, " arg \"%s\" prefix %d string %s\n", s, p, z); 
	
	if (p!=0) {	  
		if (strcasecmp("sec", z)==0) retval=p; 
		else if (strcasecmp("min", z)==0) retval=p*60; 
		else if (strcasecmp("hour", z)==0) retval=p*60*60; 
		else if (strcasecmp("day", z)==0) retval=p*60*60*24;
		else if (strcasecmp("week", z)==0) retval=p*60*60*24*7; 
		else if (strcasecmp("month", z)==0) {
			if (p<1 || p>12) return retval; 
			ti1=time(NULL);
			localtime_r(&ti1, &t1); localtime_r(&ti1, &t2);
			t1.tm_mon+=p; t1.tm_isdst=-1; t2.tm_isdst=-1;
			if (t1.tm_mon>11) { t1.tm_year++; t1.tm_mon-=12; }
			//	debug(D_MAIN, D_INFO, "flextime/month: p=%d, t1=%ld, t2=%ld, interval=%d\n", p, mktime(t1), mktime(t2), (int)difftime(mktime(t1), mktime(t2)));
			retval=(time_t)difftime(mktime(&t1), mktime(&t2));
			}
		return retval;
		}
			 
	if (strcasecmp("hourly", s)==0) {
		ti1=time(NULL);
		localtime_r(&ti1, &t1); localtime_r(&ti1, &t2);
		t1.tm_sec=0; t1.tm_min=0; t1.tm_isdst=-1;
		//	debug(D_MAIN, D_INFO, "flextime/month: p=%d, t1=%ld, t2=%ld, interval=%d\n", p, mktime(t1)+24*60*60, mktime(t2), (int)difftime(mktime(t1)+24*60*60, mktime(t2)));
		retval=(time_t)difftime(mktime(&t1)+60*60, mktime(&t2))+plus;
		if (retval<=0) retval+=60*60;
		}
	
	else if (strcasecmp("daily", s)==0) {
		ti1=time(NULL);
		localtime_r(&ti1, &t1); localtime_r(&ti1, &t2);
		t1.tm_sec=0; t1.tm_min=0; t1.tm_hour=0; t1.tm_isdst=-1;
		//	debug(D_MAIN, D_INFO, "flextime/month: p=%d, t1=%ld, t2=%ld, interval=%d\n", p, mktime(t1)+24*60*60, mktime(t2), (int)difftime(mktime(t1)+24*60*60, mktime(t2)));
		retval=(time_t)difftime(mktime(&t1)+60*60*24, mktime(&t2))+plus;
		if (retval<=0) retval+=60*60*24;
		}

	else if (strcasecmp("weekly", s)==0) {
		ti1=time(NULL);
		localtime_r(&ti1, &t1); localtime_r(&ti1, &t2);
		if (t1.tm_wday==0) t1.tm_wday=7;
		t1.tm_sec=0; t1.tm_min=0; t1.tm_hour=0; t1.tm_mday+=(8-t1.tm_wday); t1.tm_isdst=-1;
		//	debug(D_MAIN, D_INFO, "flextime/month: p=%d, t1=%ld, t2=%ld, interval=%d\n", p, mktime(t1)+24*60*60, mktime(t2), (int)difftime(mktime(t1)+24*60*60, mktime(t2)));
		retval=(time_t)difftime(mktime(&t1), mktime(&t2))+plus;
		if (retval<=0) retval+=60*60*7*24;
		}

	else if (strcasecmp("monthly", s)==0) {
		ti1=time(NULL);
		localtime_r(&ti1, &t1); localtime_r(&ti1, &t2);
		t1.tm_sec=0; t1.tm_min=0; t1.tm_hour=0; t1.tm_mday=1; t1.tm_isdst=-1;
		t1.tm_mon+=1; if (t1.tm_mon>11) { t1.tm_year++; t1.tm_mon-=12; }
		//	debug(D_MAIN, D_INFO, "flextime/month: p=%d, t1=%ld, t2=%ld, interval=%d\n", p, mktime(t1)+24*60*60, mktime(t2), (int)difftime(mktime(t1)+24*60*60, mktime(t2)));
		retval=(time_t)difftime(mktime(&t1), mktime(&t2))+plus;
		if (retval<=0) retval+=60*60*24; //shit!!!
		}

	else if (strstr(s, "at-")==s) { //looks like at-XXXXX
		s1=strchr(s+1, '.'); if (s1==NULL) s1=strchr(s+1, ':');
		//	debug(D_MAIN, D_INFO, "s=%s(%p), s1=%p\n", s, s, s1);
		if (s1==NULL) return retval; // no time definition at 'at'
		s2=strchr(s1+1, '-');
		sscanf(s+3, "%d", &h); sscanf(s+6, "%d", &m);
		if (h<0 || h>24 || m<0 || m>59) return retval;
	
		ti1=time(NULL);
		localtime_r(&ti1, &t1); localtime_r(&ti1, &t2);
		//sprintf(s3, "%d", t1->tm_wday);
		//if (strchr(s2+1, s3[0])!=NULL) { *i=0xffff; return 1; }
	
		t1.tm_sec=0; t1.tm_min=m; t1.tm_hour=h; t1.tm_isdst=-1;
		retval=(time_t)difftime(mktime(&t1), mktime(&t2));
		if (retval<=0) retval=retval+24*60*60;
		// debug(DEBUG_SCHED, "getInterval: %d \n", retval);
		}

	return retval;
	}

//////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////
// service thread definition
void sSchedulerInit(Service *s){
	pthread_create(&(s->t_id), NULL, &sScheduler, s);
	return;
	}

void *sScheduler(void *ss){
	Service *s=(Service*)ss;
	Task *t;
	time_t now, min;
	pthread_t task;

	s->t_id=pthread_self();
	aLog(D_INFO, "service scheduler:%u thread started\n", s->instance);
	pthread_cleanup_push(sSchedulerCancel, s);
	pthread_setcanceltype(PTHREAD_CANCEL_ASYNCHRONOUS, NULL);

	// now we should sleep before starting Scheduler service exec
	s->Sleep();

	aLog(D_INFO, "service scheduler:%u processing queue\n", s->instance);
	while (1) {
		aDebug(DEBUG_SCHED, "scheduler loop processed...\n");

		time(&now); min=SCHED_MIN_SLEEP_TIME;

		for (t=Sched.root; t!=NULL; t=t->next){
			if (t->when<=now) { 
				aLog(D_INFO, "time to exec task %06X \"%s\"\n", t->id, t->action); 
				
				// actual exec
				pthread_create(&task, NULL, &sSchedulerTask, t->action);

				t->when=now+getInterval(t->str_interval);
				}
			aDebug(DEBUG_SCHED, " current task %06X now %ld when %ld min %d\n", t->id, now, t->when, min);
			if (min > (t->when-now)) min=(t->when-now);
			}

		aDebug(DEBUG_SCHED, "scheduler sleeping for %d seconds\n", min);
		s->Sleep(min*1000);
		}

	pthread_cleanup_pop(0);
	return NULL;
	}

void sSchedulerCancel(void *v){
	Service *s = (Service*)v;
	aLog(D_INFO, "cancelling service scheduler:%u\n", s->instance);
}

//////////////////////////////////////////////////////////////////////////
void *sSchedulerTask(void *ss){
	pthread_setcanceltype(PTHREAD_CANCEL_ASYNCHRONOUS, NULL);
	pthread_detach(pthread_self());

	int i=aCommand(cInternal, (char*)ss);
	if (i==PARSE_KILL || i==PARSE_SHUTDOWN || i==PARSE_RELOAD) { global_return_code=i; termination(0); }
	
	return NULL;
	}

