/*************************************************************************
***     Authentication, authorization, accounting + firewalling package
***     (c) 1998-2003 Anton Vinokurov <anton@netams.com>
***		(c) 2003 NeTAMS Development Team
***		All rights reserved. See 'Copying' file included in distribution
***		For latest version and more info, visit this project web page
***		located at http://www.netams.com
***		 					
*************************************************************************/
/* $Id: s_storage.c,v 1.18.2.7 2004/05/06 10:35:05 jura Exp $ */

#include "netams.h"

void *sStorage(void *s);
void sStorageCancel(void *);

//////////////////////////////////////////////////////////////////////////
void sStorageInit(Service *s){
	s->cfg = (ServiceStorage_cfg*)aMalloc(sizeof(ServiceStorage_cfg));

	ServiceStorage_cfg *cfg=(ServiceStorage_cfg*)s->cfg;
	cfg->type=UNKNOWN;
	cfg->hostname=cfg->username=cfg->password=cfg->dbname=cfg->socket=NULL;
	cfg->port=0;
	cfg->in=new FIFO(5000);
	cfg->out=new FIFO(5000);
	cfg->fd1=cfg->fd2=NULL;
	cfg->query=(char*)aMalloc(256);

	pthread_create(&(s->t_id), NULL, &sStorage, s);
}
//////////////////////////////////////////////////////////////////////////
void sStorageProcessCfg(char *param[32], Connection *conn, unsigned no_flag){
	ServiceStorage_cfg *cfg=(ServiceStorage_cfg*)conn->service->cfg;

	if (!strcasecmp(param[0], "type")) {
		if (!strcasecmp(param[1], "hash")) {
			aParse(conn, "storage type is set to HASH\n");
			cfg->type=HASH;
		}
		else if (!strcasecmp(param[1], "mysql")) {
			aParse(conn, "storage type is set to MySQL\n");
			cfg->type=MY_SQL;
		}
		else if (!strcasecmp(param[1], "postgres")) {
			aParse(conn, "storage type is set to Postgres\n");
			cfg->type=POSTGRES;
		}
		else {
			aParse(conn, "storage type is unknown\n");
			cfg->type=UNKNOWN;
		}
	}		
	else if (!strcasecmp(param[0], "user")) {
		if (param[1]!=empty && (cfg->type==MY_SQL || cfg->type==POSTGRES) ) {
			aFree(cfg->username);
			cfg->username=set_string(param[1]);
			aParse(conn, "username is set to %s\n", cfg->username);
		} 
		else aParse(conn, "cannot set username for this storage type\n");
	}
	else if (!strcasecmp(param[0], "path")) {
		if (param[1]!=empty && cfg->type==HASH ) {
			aFree(cfg->username);
			cfg->username=set_string(param[1]);
			aParse(conn, "path is set to %s\n", cfg->username);
		} 
		else aParse(conn, "cannot set path for this storage type\n");
	}
	else if (!strcasecmp(param[0], "password")) {
		if (param[1]!=empty && (cfg->type==MY_SQL || cfg->type==POSTGRES) ) {
			aFree(cfg->password);
			cfg->password=set_string(param[1]);
			aParse(conn, "password is set to %s\n", cfg->password);
		} 
		else aParse(conn, "cannot set password for this storage type\n");
	}
	else if (!strcasecmp(param[0], "host")) {
		if (param[1]!=empty && (cfg->type==MY_SQL || cfg->type==POSTGRES) ) {
			aFree(cfg->hostname);
			cfg->hostname=set_string(param[1]);
			aParse(conn, "hostname is set to %s\n", cfg->hostname);
		} 
		else aParse(conn, "cannot set hostname for this storage type\n");
	}
	else if (!strcasecmp(param[0], "dbname")) {
		if (param[1]!=empty && (cfg->type==MY_SQL || cfg->type==POSTGRES) ) {
			aFree(cfg->dbname);
			cfg->dbname=set_string(param[1]);
			aParse(conn, "dbname is set to %s\n", cfg->dbname);
		} 
		else aParse(conn, "cannot set dbname for this storage type\n");
	}
        else if (!strcasecmp(param[0], "socket")) {
                if (param[1]!=empty && (cfg->type==MY_SQL || cfg->type==POSTGRES) ) {
                        if(cfg->socket) aFree(cfg->socket);
                        cfg->socket=set_string(param[1]);
                        aParse(conn, "socket is set to %s\n", cfg->socket);
                }
                else aParse(conn, "cannot set socket for this storage type\n");
        }
         else if (!strcasecmp(param[0], "port")) {
                if (param[1]!=empty && (cfg->type==MY_SQL || cfg->type==POSTGRES) ) {
                        cfg->port=strtol(param[1], NULL, 16);
                        aParse(conn, "port is set to %u\n", cfg->port);
                }
                else aParse(conn, "cannot set port for this storage type\n");
        }
	else aParse(conn, "unknown storage command: %s\n", param[0]);
}
//////////////////////////////////////////////////////////////////////////
void *sStorage(void *ss){
	Service *s=(Service*)ss;
	Message *msg;

	aLog(D_INFO, "service storage:%u thread started (%p)\n", s->instance, s->cfg);
	pthread_cleanup_push(sStorageCancel, s);
	pthread_setcanceltype(PTHREAD_CANCEL_ASYNCHRONOUS, NULL);
	s->t_id=pthread_self();

	ServiceStorage_cfg *cfg=(ServiceStorage_cfg*)s->cfg;
	
	// now we should sleep before starting storage service exec
	s->Sleep();

	switch (cfg->type) {
		case HASH:
			#ifdef USE_HASH
				aLog(D_INFO, "storage:%d working with HASH\n", s->instance);
				stOpenHash(s);
				while (1) {
					while((msg=cfg->out->Pop())) {
                                                if (msg->type==READ) {
                                                        aDebug(DEBUG_STORAGE, "ST<-HASH rd st:%u unit:%06X acct:%06X\n", s->instance, msg->netunit, msg->ap);
                                                        stLoadHash(s, msg);
						}
						delete msg; //since only one storage process READ requests
                                        }
					while((msg=cfg->in->Pop())) {
						if (msg->type==STORE) {
							aDebug(DEBUG_STORAGE, "ST->HASH wr st:%u unit:%06X acct:%06X from:%ld to:%ld\n", s->instance, msg->netunit, msg->ap, msg->data.from, msg->data.to);
							stSaveHash(s, msg);
						}
						if(!msg->Active()) delete msg;
					}
					stSyncHash(s);
					s->Sleep();
				}
			#else 
				aLog(D_ERR, "storage type HASH is not compiled in!\n");
			#endif
				break;

		case POSTGRES:
		case MY_SQL:
			aLog(D_INFO, "storage:%d working with SQL\n", s->instance);
			
			while (1) {
				
				while((msg=cfg->out->TryPop())) {
					if (msg->type==READ) {
						aDebug(DEBUG_STORAGE, "ST<-SQL/%c rd st:%u unit:%06X acct:%06X\n", msg->prefix, s->instance, msg->netunit, msg->ap);
						if(!stLoadSql(s, msg)) goto CONN_ERROR;
						if (msg->unblock) { 
							int i=pthread_cond_signal(msg->unblock);
							aDebug(DEBUG_STORAGE, "signalling condition %p resulted: %d\n", msg->unblock, i);
						}
					} else {
						aDebug(DEBUG_STORAGE, "message type %d not READ - discarded\n",msg->type);
					}
					msg=cfg->out->Pop();
					delete msg; ////since only one storage process READ requests
				}
				while((msg=cfg->in->TryPop())) {
                                        if (msg->type==STORE) {
                                                aDebug(DEBUG_STORAGE, "ST->SQL/%c wr st:%u unit:%06X acct:%06X from:%ld to:%ld\n", msg->prefix, s->instance, msg->netunit, msg->ap, msg->data.from, msg->data.to);
                                                if(!stSaveSql(s, msg)) goto CONN_ERROR;
                                        } else {
						aDebug(DEBUG_STORAGE, "message type %d not STORE - discarded\n",msg->type);
					} 
					msg=cfg->in->Pop();
					if(!msg->Active()) delete msg;
                                }
CONN_ERROR:
				if(cfg->fd1) {stCloseSql(s,cfg->fd1); cfg->fd1=NULL;}
				if(cfg->fd2) {stCloseSql(s,cfg->fd2); cfg->fd2=NULL;}

				s->Sleep();
			}
			break;
		
		case UNKNOWN:
		default:
			aLog(D_INFO, "storage type undefined, service will be finished\n");					
			break;
		}

	pthread_cleanup_pop(0);
	return NULL;
	}

//////////////////////////////////////////////////////////////////////////
void sStorageCancel(void *v){
	Service *s = (Service*)v;
	ServiceStorage_cfg *cfg=(ServiceStorage_cfg*)s->cfg;
	//unregister storage in processor service
	for(st_unit *st=ProcessorCfg.st_root;st!=NULL;st=st->next) {
		if(st->id==s->instance) {
			aLog(D_INFO, "unregistering storage:%d\n", s->instance);
                        if(st==ProcessorCfg.st_root) {
                                ProcessorCfg.st_root=st->next;
                                if(ProcessorCfg.st_root) {
                                        aLog(D_INFO, "using storage:%u as source for READ and STAT requests\n",ProcessorCfg.st_root->id);
                                }
                        } else
                                st->prev->next=st->next;
                        if(st->next) st->next->prev=st->prev;
                        aFree(st);
			break;
		}
	}
	aLog(D_INFO, "cancelling service storage:%u\n", s->instance);
	switch (cfg->type) {
		case HASH:
				#ifdef USE_HASH
					stCloseHash(s);
				#endif
					break;
		case POSTGRES:
		case MY_SQL:
					if(cfg->fd1) {stCloseSql(s,cfg->fd1); cfg->fd1=NULL;}
					if(cfg->fd2) {stCloseSql(s,cfg->fd2); cfg->fd2=NULL;}
					break;
		default: break;
	}
	delete cfg->in;
	delete cfg->out;
	if(cfg->username) aFree(cfg->username);
	if(cfg->password) aFree(cfg->password);
	if(cfg->dbname)   aFree(cfg->dbname);
	if(cfg->hostname) aFree(cfg->hostname);
	if(cfg->socket)   aFree(cfg->socket);
	aFree(cfg->query);
	aFree(cfg);
}

//////////////////////////////////////////////////////////////////////////
void sStorageListCfg(Service *s, FILE *f){
	ServiceStorage_cfg *cfg=(ServiceStorage_cfg*)s->cfg;

	fprintf(f, "service storage %d\n", s->instance);

	switch (cfg->type) {
		case HASH: 
			fprintf(f, "type hash\n"); 
			if (cfg->username) fprintf(f, "path %s\n", cfg->username); 
			break;

		case MY_SQL: 
			fprintf(f, "type mysql\n"); 
			if (cfg->socket) fprintf(f, "socket %s\n", cfg->socket);
			if (cfg->port && cfg->port!=3306) fprintf(f, "port %u\n", cfg->port); 
			if (cfg->hostname) fprintf(f, "host %s\n", cfg->hostname); 
			if (cfg->username) fprintf(f, "user %s\n", cfg->username); 
			if (cfg->password) fprintf(f, "password %s\n", cfg->password); 
			if (cfg->dbname) fprintf(f, "dbname %s\n", cfg->dbname); 
			break;
		case POSTGRES: 
			fprintf(f, "type postgres\n"); 
			if (cfg->socket) fprintf(f, "socket %s\n", cfg->socket);
			if (cfg->port && cfg->port!=5432) fprintf(f, "port %u\n", cfg->port);  // change this to correct port number!!
			if (cfg->hostname) fprintf(f, "host %s\n", cfg->hostname); 
			if (cfg->username) fprintf(f, "user %s\n", cfg->username); 
			if (cfg->password) fprintf(f, "password %s\n", cfg->password);
			if (cfg->dbname) fprintf(f, "dbname %s\n", cfg->dbname); 
			break;
		default:	break;
		}

	fprintf(f, "\n");
}
//////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////
