/*************************************************************************
***     Authentication, authorization, accounting + firewalling package
***     (c) 1998-2003 Anton Vinokurov <anton@netams.com>
***		(c) 2003 NeTAMS Development Team
***		All rights reserved. See 'Copying' file included in distribution
***		For latest version and more info, visit this project web page
***		located at http://www.netams.com
***		 					
*************************************************************************/
/* $Id: s_weblogin.c,v 1.10.2.3 2004/05/06 10:35:06 jura Exp $ */

#include "netams.h"

//////////////////////////////////////////////////////////////////////////
void sWLInit(Service *s){
	Weblogin_cfg *cfg = (Weblogin_cfg*)aMalloc(sizeof(Weblogin_cfg));
	cfg->WLroot=NULL;
	cfg->delay=WEBLOGIN_DELAY; //activity will be checked every 110 seconds (default)
	s->cfg=cfg;
	pthread_create(&(s->t_id), NULL, &sWL, s);

	return;
	}

//////////////////////////////////////////////////////////////////////////
void sWLProcessCfg(char *param[32], Connection *conn, unsigned no_flag){
	Service *s=NULL;
	
        //this is quick workaround to support old weblogin way
	// we assume we have only one weblogin service
	if(!(s=Services.getServiceByName("weblogin",s))) return;

	Weblogin_cfg *cfg=(Weblogin_cfg*)s->cfg;
	User *u;
	WLdata *tmp;

	if (!strcasecmp(param[0], "user")) {
		u=Users.getUser(param[1]);
		if (!u) { aParse(conn, "weblogin unknown user: %s\n", param[1]); return; }

		tmp=(WLdata*)aMalloc(sizeof(WLdata));
		tmp->pol=SP_DENY_AUTH;
		tmp->user=u;
		tmp->totalunits=0;
		int i=2;
		while (param[i]!=empty) {
	 		if (!strcasecmp(param[i], "time")) {
				tmp->timeout=getInterval(param[i+1]);
				if (tmp->timeout>=0) { 
					tmp->timeout_s=set_string(param[i+1]);
					aParse(conn, "weblogin absolute timeout set: %s (%ld sec)\n", param[i+1], tmp->timeout);
					}
				else { 
					aParse(conn, "weblogin timeout invalid: %s\n", param[i+1]);
					aFree(tmp);
					return;
					}
				i++; 
				} 
	 		else if (!strcasecmp(param[i], "inact")) {
				tmp->inact=getInterval(param[i+1]);
				if (tmp->inact>=0) { 
					tmp->inact_s=set_string(param[i+1]);
					strcpy(tmp->inact_s, param[i+1]); 
					aParse(conn, "weblogin inactivity timeout set: %s (%ld sec)\n", param[i+1], tmp->inact);
					}
				else { 
					aParse(conn, "weblogin inactivity invalid: %s\n", param[i+1]);
					aFree(tmp);
					return;
					}
				i++; 
				} 
			else if (!strcasecmp(param[i], "multi")) {
				tmp->multi=1;
				aParse(conn, "weblogin multi-units-open flag is set\n");
				}
			else if (!strcasecmp(param[i], "set")) {
				NetUnit *ut = new NetUnit(NETUNIT_UNKNOWN);
				ut->id=0xFFFFFF;
				SetSysPolicy(param[i+1], ut, conn);
				tmp->pol=ut->sys_policy;
				tmp->pol_perm=ut->sys_policy_perm;
				if (ut->sys_policy_perm) aParse(conn, "weblogin set: sys-%06X-auth\n", ut->sys_policy_perm);
				else aParse(conn, "weblogin set: sys-deny-auth\n");
				delete ut;
				i++;
				}
			else if (!strcasecmp(param[i], "open")) {
				NetUnit *ut;
				oid id;
				int j=i+1;
				while (param[j]!=empty) {
					id=strtol(param[j], NULL, 16);
					ut=Units.getUnitById(id);
					if (!ut) ut=Units.getUnit(param[j]);
					if (ut) {
						for (int k=0; k<MAX_WL_UNITS; k++) {
							if (tmp->units[k]==ut) {
								aParse(conn, "unit %06X (%s) is already binded with this weblogin\n", ut->id, ut->name?ut->name:"<>");
								goto AGAIN_WL;
								}
							}				
						for (int k=0; k<MAX_WL_UNITS; k++) {
							if (no_flag) {
								if (tmp->units[k]==ut) {
									tmp->units[k]=NULL;
									aParse(conn, "unit %06X (%s) unbinded from this weblogin\n", ut->id, ut->name?ut->name:"<>");
									tmp->totalunits--;
									}
								break;
								}
							if (!tmp->units[k]) {
								tmp->units[k]=ut;
								aParse(conn, "unit %06X (%s) binded with this weblogin\n", ut->id, ut->name?ut->name:"<>");
								tmp->totalunits++;
								break;
								}
							}
						}
					else aParse(conn, "unit %06X unknown, cannot bind\n", id);
					AGAIN_WL:
					j++;
					}		
				i=j-1;
				}
			else aParse(conn, "unknown weblogin user command: %s\n", param[i]);
			i++;
			}
		// user build complete, should we put it into chain?
		WLdata *w, *wp=NULL; int inserted=0;
		for (w=cfg->WLroot; w!=NULL; w=w->next){
			if (w->user==tmp->user && w->pol==tmp->pol && w->timeout==tmp->timeout) {
				tmp->next=w->next;
				inserted=1;
				memcpy(w, tmp, sizeof(WLdata));
				}
			wp=w;
			}
		if (!inserted) {
			if (wp) wp->next=tmp;
			else cfg->WLroot=tmp;
			aParse(conn, "user %s insterted into weblogins table\n", param[1]);
			}
		}

	else if (!strcasecmp(param[0], "auth")) { // "auth user XX password YY [from NN [open MM]]"
		struct ip ipc; ipc.ip_src.s_addr=INADDR_ANY;
		User *u;
		NetUnit *n=NULL; 
		int auth;
		unsigned spec_open=0, spec_from=0;
		if (!strcasecmp(param[1], "user")) {
			u=Users.getUser(param[2]);
			if (!u) {
				aParse(conn, "user unknown\n");
				return;
				}
			}
		if (!strcasecmp(param[3], "password") && u) {
			auth=aAuth(u->name, param[4]);
			if (auth<UPERM_LOGIN_WEB) {
				aParse(conn, "user %s insufficient permissions or password incorrect\n", u->name);
				return;
				}
			}
		if (!strcasecmp(param[5], "from") && u) {
			spec_from=1;
			inet_aton(param[6], &ipc.ip_src);
			for (NetUnit *u=Units.root; u!=NULL; u=u->next) if (u->Check(&ipc) != MATCH_NONE) n=u;
			}
		if (!strcasecmp(param[5], "open") && u) {
			spec_open=1;
			n=Units.getUnit(param[6]);
			if (!n) n=Units.getUnitById(strtol(param[6], NULL, 16));
			}

		// auth process is here
		WLdata *w;
		for (w=cfg->WLroot; w!=NULL; w=w->next) if (w->user==u) {
			if (w->multi) { // we can open many, list them
				if (!spec_open)	{
					int j=0;
					for (int i=0; i<MAX_WL_UNITS; i++) if (w->units[i]) {
						fprintf(conn->stream_w, "* * %s %06X ", w->units[i]->name?w->units[i]->name:"<>", w->units[i]->id);
						j++;
						}
					if (j) fprintf(conn->stream_w, "\n");
					}
				else for (int i=0; i<MAX_WL_UNITS; i++) if (n && w->units[i]==n) sWLOpenUnit(conn, w, i, u->name?u->name:"<>");
				} // multi==1
			else {
				for (int i=0; i<MAX_WL_UNITS; i++) 
					if ((spec_from && n && w->units[i]==n) || (!spec_from && w->units[i] && w->totalunits==1)) sWLOpenUnit(conn, w, i, u->name?u->name:"<>");
				} // multi==0
			} //for-if, all WLdata
		} // auth
       	else if (!strcasecmp(param[0], "lookup-delay")) {
                unsigned delay=atoi(param[1]);
                if(delay>1 && delay <24*60*60) {
                        cfg->delay=delay*1000;
                        aParse(conn, "weblogin timers will be checked every %u seconds\n",delay);
                } else
                        aParse(conn, "lookup delay value invalid\n");
                }

	else aParse(conn, "unknown weblogin command: %s\n", param[0]);
	return;
	}

//////////////////////////////////////////////////////////////////////////
void sWLListCfg(Service *s, FILE *f){
	Weblogin_cfg *cfg=(Weblogin_cfg*)s->cfg;
	WLdata *w;

	fprintf(f, "service weblogin %d\n", s->instance);
	if(cfg->delay!=WEBLOGIN_DELAY) fprintf(f, "lookup-delay %d\n", cfg->delay/1000);
	for (w=cfg->WLroot; w!=NULL; w=w->next) if (w->user && w->user->name) {
		fprintf(f, "user %s ", w->user->name);
		if (w->timeout) fprintf(f, "time %s ", w->timeout_s);
		if (w->inact) fprintf(f, "inact %s ", w->inact_s);
		if (w->pol_perm) fprintf(f, "set sys-%06X-auth ", w->pol_perm);
		else fprintf(f, "set sys-deny-auth ");
		fprintf(f, "%sopen ", w->multi?"multi ":"");
		for (int i=0; i<MAX_WL_UNITS; i++) {
			if (w->units[i]) fprintf(f, "%s ", w->units[i]->name?w->units[i]->name:"<>");		
			}
		fprintf(f, "\n");
		}
	fprintf(f, "\n");

	return;
	}

//////////////////////////////////////////////////////////////////////////
void *sWL(void *ss){
	Service *s=(Service*)ss;
	Weblogin_cfg *cfg=(Weblogin_cfg*)s->cfg;
	WLdata *w;
	NetUnit *u;
	time_t now;
	unsigned violates;

	aLog(D_INFO, "service weblogin:%u thread started (%p)\n", s->instance, s->cfg);
	pthread_cleanup_push(sWLCancel, s);
	pthread_setcanceltype(PTHREAD_CANCEL_ASYNCHRONOUS, NULL);
	s->t_id=pthread_self();

	// now we should sleep before starting service
	s->Sleep();

	aLog(D_DEBUG, "service weblogin:%u checking every %d seconds\n", s->instance,cfg->delay/1000);
	while (1) {
		now=time(NULL);
		for (w=cfg->WLroot; w!=NULL; w=w->next) if (w->user && w->user->name) {
			for (int i=0; i<MAX_WL_UNITS; i++) {
				if (w->units[i]) {
					u=w->units[i];
					violates=0;

					if (u->timeout && (now - u->open)>u->timeout) {
						violates=1;
						aLog(D_INFO, "unit %s (%06X) absolute timeout reached, applying '%s':%06X\n", u->name?u->name:"<>", u->id, u->sys_policy_name, u->sys_policy_perm);
						}

					if  ((u->ap.LastUsed() && u->inact && (now - u->ap.LastUsed())>u->inact) 
							|| (!u->ap.LastUsed() && u->inact && (now - u->open)>u->inact)){
						violates=1;
						aLog(D_INFO, "unit %s (%06X) inactivity timeout reached, applying '%s':%06X\n", u->name?u->name:"<>", u->id, u->sys_policy_name, u->sys_policy_perm);
						}
					
					if (violates) {
						// actual policy setup
						u->sys_policy=w->pol;
						if (w->pol_perm) { u->sys_policy_name=SysPolicy_name[SP_LX_AUTH]; u->sys_policy_perm=w->pol_perm; }
						else u->sys_policy_name=SysPolicy_name[SP_DENY_AUTH];
						u->timeout=0; u->inact=0; u->open=0;
						}					
					}		
				}
			}

		s->Sleep(cfg->delay); // web login timeouts will be checked every cfg->delay seconds
		}

	pthread_cleanup_pop(0);
	return NULL;
	}

//////////////////////////////////////////////////////////////////////////
void sWLCancel(void *v){
	Service *s = (Service*)v;
	aFree(s->cfg);
	aLog(D_INFO, "cancelling service weblogin:%u\n", s->instance);
}
//////////////////////////////////////////////////////////////////////////
void cShowTimeouts(Connection *conn){
	NetUnit *u;
	time_t inact_t, now=time(NULL);

	for (u=Units.root; u!=NULL; u=u->next) 
		if (u->timeout || u->inact){
			fprintf(conn->stream_w, "%s (%06X) opened %ld sec. ago, last used %ld sec. ago\n", u->name?u->name:"<>", u->id, u->open?(now - u->open):-1, u->ap.LastUsed()?(now - u->ap.LastUsed()):-1);
			if (u->ap.LastUsed()) inact_t = u->inact - now + u->ap.LastUsed();
			else inact_t = u->inact - now + u->open;
			fprintf(conn->stream_w, "   absolute timeout at %ld sec, inactivity at %ld sec.\n", u->timeout?(u->timeout - now + u->open):-1, u->inact?inact_t:-1);
		}
	}
//////////////////////////////////////////////////////////////////////////
void sWLOpenUnit(Connection *conn, WLdata *w, int i, const char *user){
	w->units[i]->open=time(NULL);
	w->units[i]->sys_policy=SP_ALLOW_AUTH;
	if (w->inact_s) w->units[i]->inact=w->inact;
	if (w->timeout_s) w->units[i]->timeout=w->timeout;
	aParse(conn, "user %s is opening unit %s\n", user, w->units[i]->name?w->units[i]->name:"<>");
	}
//////////////////////////////////////////////////////////////////////////

