/*************************************************************************
***     Authentication, authorization, accounting + firewalling package
***     (c) 1998-2003 Anton Vinokurov <anton@netams.com>
***		(c) 2003 NeTAMS Development Team
***		All rights reserved. See 'Copying' file included in distribution
***		For latest version and more info, visit this project web page
***		located at http://www.netams.com
***		 					
*************************************************************************/
/* $Id: security.c,v 1.6.2.1 2004/05/06 10:35:06 jura Exp $ */

#include "netams.h"

/////////////////////////////////////////////////////////////////////////////////////////
// Permissions Management ///////////////////////////////////////////////////////////////////

char *permissions_list[256]; 

void aPermissionsInit(){

	for (int i=0; i<=255; i++) permissions_list[i]=NULL;
	permissions_list[UPERM_NONE]="none";              
	permissions_list[UPERM_LOGIN_WEB]="weblogin";          
	permissions_list[UPERM_SHOWSTAT_HIS]="showstat_his";
	permissions_list[UPERM_SHOWOBJ_HIS]="showobj_his";      
	permissions_list[UPERM_MODIFYOBJ_HIS]="modifyobj_his";    
	permissions_list[UPERM_SHOWSTAT_ALL]="showstat";
	permissions_list[UPERM_SHOWOBJ_ALL]="showobj";          
	permissions_list[UPERM_SHOWCONFIG]="showconfig";       
	permissions_list[UPERM_MODIFYOBJ_ALL]="modifyobj";
	permissions_list[UPERM_MODIFYCONFIG]="modifyconfig";     
	permissions_list[UPERM_LOGIN_INT]="intlogin";        
	permissions_list[UPERM_SYSACTION]="sysaction";
	permissions_list[UPERM_ALL]="all";

#ifndef LINUX
	crypt_set_format("md5");
#endif

	}

unsigned aCheckPerm(Connection *conn, unsigned perm){
	if (conn->permissions < perm) {
		aLog(D_WARN, "connection %s: not enough permissions\n", conn->name);
		return 1;
		}
	return 0;
	}

int aAuth(char *login, char *password){
	User *u;
	
	if (!login || !password) return -1;
	
	u=Users.getUser(login);
	
	if (!u) return -1;
	
	if (u->password) {
		if (strlen(password)==strlen(u->password)) 
			if (!strcmp(password, u->password)) return u->permissions;
		}

	if (u->crypted) {
		char *c=crypt(password, "$1$");
		if (strlen(c)==strlen(u->crypted)) 
			if (!strcmp(c, u->crypted)) return u->permissions;
		}

	return -1;
	}

