/*************************************************************************
***     Authentication, authorization, accounting + firewalling package
***     (c) 1998-2003 Anton Vinokurov <anton@netams.com>
***		(c) 2003 NeTAMS Development Team
***		All rights reserved. See 'Copying' file included in distribution
***		For latest version and more info, visit this project web page
***		located at http://www.netams.com
***		 					
*************************************************************************/
/* $Id: st_any.h,v 1.12.2.3 2004/05/06 10:35:06 jura Exp $ */

#ifdef USE_MYSQL
#ifdef LINUX
#include <mysql.h>
#endif
#ifdef FREEBSD
#include <mysql/mysql.h>
#endif
#endif

#ifdef USE_POSTGRES
#include <libpq-fe.h>
#endif

//Types of connections to storage
#define ST_CONN_RAW	1
#define ST_CONN_SUMMARY 2
#define ST_CONN_MONITOR 3
#define ST_CONN_LOGIN	4
#define ST_CONN_QUOTA	5

//////////////////////////////////////////////////////////////////////////
void stOpenHash(Service *s);
void stSaveHash(Service *s, Message *msg);
void stLoadHash(Service *s, Message *msg);
void stSyncHash(Service *s);
void stCloseHash(Service *s);


void *stOpenSql(Service *s,unsigned int type);
unsigned stSaveSql(Service *s, Message *msg);
unsigned stLoadSql(Service *s, Message *msg);
unsigned stStatSql(Service *s, Message *msg);
void stCloseSql(Service *sm, void *conn);
void stMonitorToSql(Monitor_cfg *cfg, time_t t, unsigned msec, NetUnit *u, struct ip *ip, unsigned long len);
void stLgObtainDbData(Login_cfg *cfg, NetUnit *u);
void stLgSetCfg(Login_cfg *cfg, NetUnit *u);
void stQuObtainDbData(Quota_cfg *cfg, NetUnit *u);
void stQuSetCfg(Quota_cfg *cfg, NetUnit *u);

#ifdef USE_MYSQL
void *my_stOpenSql(Service *s,unsigned int type);
unsigned my_stSaveSql(Service *s, Message *msg);
unsigned my_stLoadSql(Service *s, Message *msg);
unsigned my_stStatSql(Service *s, Message *msg);
void my_stCloseSql(Service *s, void *conn);
void my_stMonitorToSql(Monitor_cfg *cfg, time_t t, unsigned msec, NetUnit *u, struct ip *ip, unsigned long len);
unsigned my_stStatSql_p(stat_data *s, char prefix, MYSQL *m, int i, oid u, oid p, unsigned points);
void my_stLgObtainDbData(Login_cfg *cfg, NetUnit *u);
void my_stLgSetCfg(NetUnit *u, void *fd);
void my_stQuObtainDbData(Quota_cfg *cfg, NetUnit *u);
void my_stQuSetCfg(NetUnit *u, void *fd);
#endif

#ifdef USE_POSTGRES
void *pg_stOpenSql(Service *s,unsigned int type);
unsigned pg_stSaveSql(Service *s, Message *msg);
unsigned pg_stLoadSql(Service *s, Message *msg);
unsigned pg_stStatSql(Service *s, Message *msg);
void pg_stCloseSql(Service *sm, void *conn);
void pg_stMonitorToSql(Monitor_cfg *cfg, time_t t, unsigned msec, NetUnit *u, struct ip *ip, unsigned long len);
unsigned pg_stStatSql_p(stat_data *s, char prefix, PGconn *conn, int i, oid u, oid p, unsigned points);
void pg_stLgObtainDbData(Login_cfg *cfg, NetUnit *u);
void pg_stLgSetCfg(NetUnit *u, void *fd);
void pg_stQuObtainDbData(Quota_cfg *cfg, NetUnit *u);
void pg_stQuSetCfg(NetUnit *u, void *fd);
#endif

//////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////
