/*************************************************************************
***     Authentication, authorization, accounting + firewalling package
***     (c) 1998-2003 Anton Vinokurov <anton@netams.com>
***		(c) 2003 NeTAMS Development Team
***		All rights reserved. See 'Copying' file included in distribution
***		For latest version and more info, visit this project web page
***		located at http://www.netams.com
***		 					
*************************************************************************/
/* $Id: st_hash.c,v 1.5.2.3 2004/08/17 09:55:43 jura Exp $ */

#include "netams.h"

#ifdef USE_HASH

#ifndef LINUX
#include <db.h>
#else
#include <db1/db.h>
#endif

int stSaveHashRaw(DB *db, char *key, char *value);
int stLoadHashRaw(DB *db, char *key, char *value);

//////////////////////////////////////////////////////////////////////////
void stOpenHash(Service *s){
	ServiceStorage_cfg *cfg=(ServiceStorage_cfg *)s->cfg;
	// first, we will determine the path to hash files
	// two ways - the directory where config file is, or what is specified in 'path' variable
	
	int fd;
	struct stat sb;
	char *c;
	char *hash_path; hash_path=(char*)aMalloc(255);
	char *hash_file; hash_file=(char*)aMalloc(255);

	if (cfg->username) {
		strcpy(hash_path, cfg->username);

		} else {
		c=strrchr(config_file_name, '/'); 
		if (c) strncpy(hash_path, config_file_name, (c-config_file_name));
		else strcpy(hash_path, "./");

		}
	sprintf(hash_file, "%s/netams-sumary.db", hash_path);

	fd=open(hash_file, O_RDWR, S_IRWXU);
	if (fd!=-1) { fstat(fd, &sb); close(fd); if (!sb.st_size) { unlink(hash_file); aLog(D_INFO, "stOpenHash(%s)%d: old archive truncated\n", hash_file, s->instance);} }

	cfg->fd1=(void*)dbopen(hash_file, O_CREAT|O_RDWR, S_IRWXU, DB_HASH, NULL);
	if (cfg->fd1==NULL) aLog(D_WARN, "stOpenHash:%d(%s) %s\n", s->instance, hash_file, strerror(errno));
	aLog(D_INFO, "hash-summary:%d database opened at %s\n", s->instance, hash_path); 

	sprintf(hash_file, "%s/netams-raw.db", hash_path);

	fd=open(hash_file, O_RDWR, S_IRWXU);
	if (fd!=-1) { fstat(fd, &sb); close(fd); if (!sb.st_size) { unlink(hash_file); aLog(D_INFO, "stOpenHash(%s)%d: old archive truncated\n", hash_file, s->instance);} }

	cfg->fd2=(void*)dbopen(hash_file, O_CREAT|O_RDWR, S_IRWXU, DB_HASH, NULL);
	if (cfg->fd2==NULL) aLog(D_WARN, "stOpenHash:%d(%s) %s\n", s->instance, hash_file, strerror(errno));
	aLog(D_INFO, "hash-raw:%d database opened at %s\n", s->instance, hash_path); 
		
	}	

//////////////////////////////////////////////////////////////////////////
void stCloseHash(Service *s){
	ServiceStorage_cfg *cfg=(ServiceStorage_cfg *)s->cfg;
	DB *db1;
	DB *db2;

	db1=(DB*)cfg->fd1;
	db2=(DB*)cfg->fd2;

	if (cfg->fd1) { 
		db1->close(db1);
		aLog(D_INFO, "hash-summary:%d closed\n", s->instance); 
		}

	if (cfg->fd2) { 
		db2->close(db2);
		aLog(D_INFO, "hash-raw:%d closed\n", s->instance); 
		}
	}

//////////////////////////////////////////////////////////////////////////
void stSaveHash(Service *s, Message *msg){

	ServiceStorage_cfg *cfg=(ServiceStorage_cfg *)s->cfg;
	char *key, *value;

	key=(char*)aMalloc(80); 
	value=(char*)aMalloc(80); 
	
	// assuming type is STORE
	switch (msg->prefix){
		case 'F':
			snprintf(key, 80, "%06X-%06X-%lu-%lu ", msg->netunit, msg->ap, (unsigned long)msg->data.from, (unsigned long)msg->data.to);
			snprintf(value, 80, "%qu %qu ", msg->data.in, msg->data.out);
			stSaveHashRaw((DB*)cfg->fd2, key, value);
			break;

		case 'T':
			snprintf(key, 80, "%c-%06X-%06X ", msg->prefix, msg->netunit, msg->ap);
			snprintf(value, 80, "%lu %qu %qu ", (unsigned long)msg->data.from, msg->data.in, msg->data.out);
			stSaveHashRaw((DB*)cfg->fd1, key, value);
			break;

		case 'M':
		case 'W':
		case 'D':
		case 'H':
			snprintf(key, 80, "%c-%06X-%06X-%lu ", msg->prefix, msg->netunit, msg->ap, (unsigned long)msg->data.from);
			snprintf(value, 80, "%qu %qu ", msg->data.in, msg->data.out);
			stSaveHashRaw((DB*)cfg->fd1, key, value);
			break;
		}

	aFree(key);
	aFree(value);
					 
	}				 

//////////////////////////////////////////////////////////////////////////
int stSaveHashRaw(DB *db, char *key, char *value){
	DBT k, v;
	int i;

	if (!db) return 1;
	 
	k.size=strlen(key); k.data=key; v.size=strlen(value); v.data=value;
	i=db->put(db, &k, &v, 0);

	aDebug(DEBUG_STORAGE, "HASH->HDD '%s'.'%s'%s\n", key, value, !i?"":strerror(errno));

	return i;
	}

//////////////////////////////////////////////////////////////////////////
void stLoadHash(Service *s, Message *msg){
	char *key, *value;

	msg->id=s->instance;
	ServiceStorage_cfg *cfg=(ServiceStorage_cfg *)s->cfg;

	key=(char*)aMalloc(80); 
	value=(char*)aMalloc(80); 
	
	// assuming type is READ
	if (msg->pdata) { 
		switch (msg->prefix){
			case 'T':
				snprintf(key, 80, "%c-%06X-%06X ", msg->prefix, msg->netunit, msg->ap);
				if (!stLoadHashRaw((DB*)cfg->fd1, key, value))
					sscanf(value, "%lu %qu %qu", &msg->pdata->t.from, &msg->pdata->t.in, &msg->pdata->t.out); 
				break;

			case 'M':
				snprintf(key, 80, "%c-%06X-%06X-%lu ", msg->prefix, msg->netunit, msg->ap, (unsigned long)msg->pdata->m.from);
				stLoadHashRaw((DB*)cfg->fd1, key, value);
				sscanf(value, "%qu %qu", &msg->pdata->m.in, &msg->pdata->m.out); 
				break;

			case 'W':
				snprintf(key, 80, "%c-%06X-%06X-%lu ", msg->prefix, msg->netunit, msg->ap, (unsigned long)msg->pdata->w.from);
				stLoadHashRaw((DB*)cfg->fd1, key, value);
				sscanf(value, "%qu %qu", &msg->pdata->w.in, &msg->pdata->w.out); 
				break;

			case 'D':
				snprintf(key, 80, "%c-%06X-%06X-%lu ", msg->prefix, msg->netunit, msg->ap, (unsigned long)msg->pdata->d.from);
				stLoadHashRaw((DB*)cfg->fd1, key, value);
				sscanf(value, "%qu %qu", &msg->pdata->d.in, &msg->pdata->d.out); 
				break;

			case 'H':
				snprintf(key, 80, "%c-%06X-%06X-%lu ", msg->prefix, msg->netunit, msg->ap, (unsigned long)msg->pdata->h.from);
				stLoadHashRaw((DB*)cfg->fd1, key, value);
				sscanf(value, "%qu %qu", &msg->pdata->h.in, &msg->pdata->h.out); 
				break;

			case 'F':
				snprintf(key, 80, "%06X-%06X-%lu-%lu ", msg->netunit, msg->ap, (unsigned long)msg->pdata->flow.from, (unsigned long)msg->pdata->flow.to);
				stLoadHashRaw((DB*)cfg->fd2, key, value);
				sscanf(value, "%qu %qu", &msg->pdata->flow.in, &msg->pdata->flow.out); 
				break;
			}
		}  // pdata is not NULL
	else { // pdata is NULL
		switch (msg->prefix){
			case 'F':
				snprintf(key, 80, "%06X-%06X-%lu-%lu ", msg->netunit, msg->ap, (unsigned long)msg->data.from, (unsigned long)msg->data.to);
				stLoadHashRaw((DB*)cfg->fd2, key, value);
				sscanf(value, "%qu %qu", &msg->data.in, &msg->data.out);
				break;

			case 'T':
				snprintf(key, 80, "%c-%06X-%06X ", msg->prefix, msg->netunit, msg->ap);
				stLoadHashRaw((DB*)cfg->fd1, key, value);
				sscanf(value, "%lu %qu %qu", &msg->data.from, &msg->data.in, &msg->data.out); 
				break;

			case 'M':
			case 'W':
			case 'D':
			case 'H':
				snprintf(key, 80, "%c-%06X-%06X-%lu ", msg->prefix, msg->netunit, msg->ap, (unsigned long)msg->data.from);
				stLoadHashRaw((DB*)cfg->fd1, key, value);
				sscanf(value, "%qu %qu", &msg->data.in, &msg->data.out); 
				break;

			}
		}	// pdata is NULL

	
	aFree(key);
	aFree(value);
					 
	}

//////////////////////////////////////////////////////////////////////////
int stLoadHashRaw(DB *db, char *key, char *value){
	DBT k, v;
	int i; 

	if (!db) return 1;
	 
	k.size=strlen(key); k.data=key; v.size=strlen(value); 
	i=db->get(db, &k, &v, 0);
	if (i==0) { 
		memcpy(value, v.data, v.size);
		aDebug(DEBUG_STORAGE, "HASH<-HDD '%s'.'%s'\n", key, value);
		}
	else if (i==1) { 
		strcpy(value, "0 0 0 ");
		aDebug(DEBUG_STORAGE, "HASH<-HDD '%s'.notfound\n", key);
		}
	else aDebug(DEBUG_STORAGE, "HASH<-HDD %s\n", strerror(errno));

	return i;
	}

//////////////////////////////////////////////////////////////////////////
void stSyncHash(Service *s){

	ServiceStorage_cfg *cfg=(ServiceStorage_cfg *)s->cfg;

	if (cfg->fd1) ((DB*)(cfg->fd1))->sync((DB*)cfg->fd1, 0);
	if (cfg->fd2) ((DB*)(cfg->fd2))->sync((DB*)cfg->fd2, 0);

	}

//////////////////////////////////////////////////////////////////////////
#endif
